/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.support;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.spring.repository.JRepository;
import org.babyfish.jimmer.spring.repository.Sorts;
import org.babyfish.jimmer.spring.repository.support.Utils;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.mutation.Mutations;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public class JRepositoryImpl<E, ID>
implements JRepository<E, ID> {
    private static final TypedProp.Scalar<?, ?>[] EMPTY_SORTED_PROPS = new TypedProp.Scalar[0];
    protected final JSqlClient sqlClient;
    protected final Class<E> entityType;
    protected final ImmutableType immutableType;

    protected JRepositoryImpl(JSqlClient sqlClient) {
        this(sqlClient, null);
    }

    public JRepositoryImpl(JSqlClient sqlClient, Class<E> entityType) {
        Utils.validateSqlClient(sqlClient);
        this.sqlClient = sqlClient;
        if (entityType != null) {
            this.entityType = entityType;
        } else {
            Class[] typeArguments = GenericTypeResolver.resolveTypeArguments(this.getClass(), JRepository.class);
            if (typeArguments == null) {
                throw new IllegalArgumentException("The class \"" + this.getClass() + "\" does not explicitly specify the type arguments of \"" + JRepository.class.getName() + "\" so that the entityType must be specified");
            }
            this.entityType = typeArguments[0];
        }
        this.immutableType = ImmutableType.get(entityType);
        if (!this.immutableType.isEntity()) {
            throw new IllegalArgumentException("\"" + entityType + "\" is not entity type decorated by @" + Entity.class.getName());
        }
    }

    @Override
    public JSqlClient sql() {
        return this.sqlClient;
    }

    @Override
    public JRepository.Pager<E> pager(Pageable pageable) {
        return new PagerImpl(pageable);
    }

    @Override
    public JRepository.Pager<E> pager(int pageIndex, int pageSize, TypedProp.Scalar<?, ?> ... props) {
        return new PagerImpl((Pageable)PageRequest.of((int)pageIndex, (int)pageSize, (Sort)Sorts.toSort(props)));
    }

    @Override
    public E findNullable(ID id) {
        return (E)this.sqlClient.getEntities().findById(this.entityType, id);
    }

    @Override
    public E findNullable(ID id, Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this.findNullable(id);
        }
        return (E)this.sqlClient.getEntities().findById(fetcher, id);
    }

    @Override
    public List<E> findByIds(Iterable<ID> ids) {
        return this.sqlClient.getEntities().findByIds(this.entityType, Utils.toCollection(ids));
    }

    @Override
    public List<E> findByIds(Iterable<ID> ids, Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this.findByIds(ids);
        }
        return this.sqlClient.getEntities().findByIds(fetcher, Utils.toCollection(ids));
    }

    @Override
    public Map<ID, E> findMapByIds(Iterable<ID> ids) {
        return this.sqlClient.getEntities().findMapByIds(this.entityType, Utils.toCollection(ids));
    }

    @Override
    public Map<ID, E> findMapByIds(Iterable<ID> ids, Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this.findMapByIds(ids);
        }
        return this.sqlClient.getEntities().findMapByIds(fetcher, Utils.toCollection(ids));
    }

    @Override
    @NotNull
    public List<E> findAll() {
        return this.sqlClient.getEntities().findAll(this.entityType, new TypedProp.Scalar[0]);
    }

    @Override
    public List<E> findAll(Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this.findAll();
        }
        return this.sqlClient.getEntities().findAll(fetcher, new TypedProp.Scalar[0]);
    }

    @Override
    public List<E> findAll(TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.sqlClient.getEntities().findAll(this.entityType, sortedProps);
    }

    @Override
    public List<E> findAll(Fetcher<E> fetcher, TypedProp.Scalar<?, ?> ... sortedProps) {
        if (fetcher == null) {
            return this.findAll(sortedProps);
        }
        return this.sqlClient.getEntities().findAll(fetcher, sortedProps);
    }

    @Override
    @NotNull
    public List<E> findAll(@NotNull Sort sort) {
        return this.sqlClient.getEntities().findAll(this.entityType, Sorts.toTypedProps(this.entityType, sort));
    }

    @Override
    public List<E> findAll(Fetcher<E> fetcher, Sort sort) {
        if (fetcher == null) {
            return this.findAll(sort);
        }
        return this.sqlClient.getEntities().findAll(fetcher, Sorts.toTypedProps(this.entityType, sort));
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize) {
        return this.findAll(pageIndex, pageSize, (Fetcher<E>)null, EMPTY_SORTED_PROPS);
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, Fetcher<E> fetcher) {
        return this.findAll(pageIndex, pageSize, fetcher, EMPTY_SORTED_PROPS);
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.findAll(pageIndex, pageSize, (Fetcher<E>)null, sortedProps);
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, Fetcher<E> fetcher, TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.pager(pageIndex, pageSize, sortedProps).execute(this.createQuery(fetcher, sortedProps));
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, Sort sort) {
        return this.findAll((Pageable)PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sort), null);
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, Fetcher<E> fetcher, Sort sort) {
        return this.findAll((Pageable)PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sort), fetcher);
    }

    @Override
    @NotNull
    public Page<E> findAll(@NotNull Pageable pageable) {
        return this.findAll(pageable, null);
    }

    @Override
    public Page<E> findAll(Pageable pageable, Fetcher<E> fetcher) {
        return this.pager(pageable).execute(this.createQuery(fetcher, Sorts.toTypedProps(this.entityType, pageable.getSort())));
    }

    @Override
    public long count() {
        return this.createQuery(null, EMPTY_SORTED_PROPS).count();
    }

    @Override
    public void delete(@NotNull E entity) {
        this.sqlClient.getEntities().delete(this.entityType, ImmutableObjects.get(entity, (int)this.immutableType.getIdProp().getId()));
    }

    @Override
    public void deleteAll(@NotNull Iterable<? extends E> entities) {
        this.sqlClient.getEntities().batchDelete(this.entityType, (Collection)Utils.toCollection(entities).stream().map(it -> ImmutableObjects.get((Object)it, (int)this.immutableType.getIdProp().getId())).collect(Collectors.toList()));
    }

    @Override
    public void deleteAll() {
        Mutations.createDelete((JSqlClient)this.sqlClient, (ImmutableType)this.immutableType, (d, t) -> {}).execute();
    }

    @Override
    public void deleteById(@NotNull ID id) {
        this.sqlClient.getEntities().delete(this.entityType, id);
    }

    @Override
    public void deleteByIds(Iterable<? extends ID> ids) {
        this.sqlClient.getEntities().batchDelete(this.entityType, Utils.toCollection(ids));
    }

    @Override
    public JRepository.GraphQl<E> graphql() {
        return new GraphQlImpl();
    }

    private ConfigurableRootQuery<?, E> createQuery(Fetcher<E> fetcher, TypedProp.Scalar<?, ?>[] sortedProps) {
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, this.immutableType, ExecutionPurpose.QUERY, false);
        Table table = query.getTable();
        for (TypedProp.Scalar<?, ?> sortedProp : sortedProps) {
            if (!sortedProp.unwrap().getDeclaringType().isAssignableFrom(this.immutableType)) {
                throw new IllegalArgumentException("The sorted field \"" + sortedProp + "\" does not belong to the type \"" + this.immutableType + "\" or its super types");
            }
            if (sortedProp instanceof TypedProp.Scalar.Desc) {
                query.orderBy(new Order[]{table.get(sortedProp.unwrap().getName()).desc()});
                continue;
            }
            query.orderBy(new Order[]{table.get(sortedProp.unwrap().getName()).asc()});
        }
        query.freeze();
        return query.select((Selection)(fetcher != null ? table.fetch(fetcher) : table));
    }

    private static class PagerImpl<E>
    implements JRepository.Pager<E> {
        private final Pageable pageable;

        private PagerImpl(Pageable pageable) {
            this.pageable = pageable;
        }

        @Override
        public Page<E> execute(ConfigurableRootQuery<?, E> query) {
            if (this.pageable.getPageSize() == 0) {
                return new PageImpl((List)query.execute());
            }
            long offset = this.pageable.getOffset();
            if (offset > (long)(Integer.MAX_VALUE - this.pageable.getPageSize())) {
                throw new IllegalArgumentException("offset is too big");
            }
            int total = query.count();
            List content = (List)query.limit(this.pageable.getPageSize(), (int)offset).execute();
            return new PageImpl(content, this.pageable, (long)total);
        }
    }

    private class GraphQlImpl
    implements JRepository.GraphQl<E> {
        private GraphQlImpl() {
        }

        @Override
        public <X> Map<E, X> load(TypedProp.Scalar<E, X> prop, Collection<E> sources) {
            return JRepositoryImpl.this.sqlClient.getLoaders().value(prop).batchLoad(sources);
        }

        @Override
        public <X> Map<E, X> load(TypedProp.Reference<E, X> prop, Collection<E> sources) {
            return JRepositoryImpl.this.sqlClient.getLoaders().reference(prop).batchLoad(sources);
        }

        @Override
        public <X> Map<E, List<X>> load(TypedProp.ReferenceList<E, X> prop, Collection<E> sources) {
            return JRepositoryImpl.this.sqlClient.getLoaders().list(prop).batchLoad(sources);
        }
    }
}

