/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.spring.model.Input;
import org.babyfish.jimmer.spring.repository.JRepository;
import org.babyfish.jimmer.spring.repository.KRepository;
import org.babyfish.jimmer.spring.repository.KSortsKt;
import org.babyfish.jimmer.spring.repository.support.KRepositoryImpl;
import org.babyfish.jimmer.spring.repository.support.Utils;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.kt.KEntities;
import org.babyfish.jimmer.sql.kt.KSqlClient;
import org.babyfish.jimmer.sql.kt.ast.KExecutable;
import org.babyfish.jimmer.sql.kt.ast.mutation.KSimpleSaveResult;
import org.babyfish.jimmer.sql.kt.ast.query.FindDsl;
import org.babyfish.jimmer.sql.kt.ast.query.KConfigurableRootQuery;
import org.babyfish.jimmer.sql.kt.ast.query.KMutableQuery;
import org.babyfish.jimmer.sql.kt.ast.query.KMutableRootQuery;
import org.babyfish.jimmer.sql.kt.ast.query.KTypedRootQuery;
import org.babyfish.jimmer.sql.kt.ast.table.KNonNullTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AliasFor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u0001AB\u001d\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tB\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0019H\u0016J\u0016\u0010\u001c\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0016J\u0015\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010!\u001a\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00010\u001eH\u0016JO\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010)2\u001f\u0010*\u001a\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000,\u0012\u0004\u0012\u00020\u0019\u0018\u00010+\u00a2\u0006\u0002\b-H\u0016J6\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010)2\u0006\u0010.\u001a\u00020/H\u0016J?\u0010#\u001a\b\u0012\u0004\u0012\u00028\u0000002\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010)2\u001f\u0010*\u001a\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000,\u0012\u0004\u0012\u00020\u0019\u0018\u00010+\u00a2\u0006\u0002\b-H\u0016J&\u0010#\u001a\b\u0012\u0004\u0012\u00028\u0000002\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010)2\u0006\u0010.\u001a\u00020/H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u00101\u001a\u000202H\u0016J&\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u00101\u001a\u0002022\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010)H\u0016J,\u00103\u001a\b\u0012\u0004\u0012\u00028\u0000002\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00010\u001e2\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010)H\u0016J2\u00104\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00010\u001e2\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010)H\u0016J'\u00106\u001a\u0004\u0018\u00018\u00002\u0006\u0010 \u001a\u00028\u00012\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010)H\u0016\u00a2\u0006\u0002\u00107J?\u00108\u001a\b\u0012\u0004\u0012\u00028\u0000092\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u001f\u0010*\u001a\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000,\u0012\u0004\u0012\u00020\u0019\u0018\u00010+\u00a2\u0006\u0002\b-H\u0016J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00028\u0000092\u0006\u00101\u001a\u000202H\u0016J\u001f\u0010:\u001a\u0002H;\"\b\b\u0002\u0010;*\u00028\u00002\u0006\u0010\u001a\u001a\u0002H;H\u0016\u00a2\u0006\u0002\u0010<J\u001b\u0010:\u001a\u00028\u00002\f\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000>H\u0016\u00a2\u0006\u0002\u0010?J&\u0010@\u001a\b\u0012\u0004\u0012\u0002H;00\"\b\b\u0002\u0010;*\u00028\u00002\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H;0\u001eH\u0016R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006B"}, d2={"Lorg/babyfish/jimmer/spring/repository/support/KRepositoryImpl;", "E", "", "ID", "Lorg/babyfish/jimmer/spring/repository/KRepository;", "sql", "Lorg/babyfish/jimmer/sql/kt/KSqlClient;", "entityType", "Ljava/lang/Class;", "(Lorg/babyfish/jimmer/sql/kt/KSqlClient;Ljava/lang/Class;)V", "Lkotlin/reflect/KClass;", "(Lorg/babyfish/jimmer/sql/kt/KSqlClient;Lkotlin/reflect/KClass;)V", "getEntityType$annotations", "()V", "getEntityType", "()Lkotlin/reflect/KClass;", "immutableType", "Lorg/babyfish/jimmer/meta/ImmutableType;", "getImmutableType", "()Lorg/babyfish/jimmer/meta/ImmutableType;", "getSql", "()Lorg/babyfish/jimmer/sql/kt/KSqlClient;", "count", "", "delete", "", "entity", "(Ljava/lang/Object;)V", "deleteAll", "entities", "", "deleteById", "id", "deleteByIds", "ids", "findAll", "Lorg/springframework/data/domain/Page;", "pageIndex", "", "pageSize", "fetcher", "Lorg/babyfish/jimmer/sql/fetcher/Fetcher;", "block", "Lkotlin/Function1;", "Lorg/babyfish/jimmer/sql/kt/ast/query/FindDsl;", "Lkotlin/ExtensionFunctionType;", "sort", "Lorg/springframework/data/domain/Sort;", "", "pageable", "Lorg/springframework/data/domain/Pageable;", "findByIds", "findMapByIds", "", "findNullable", "(Ljava/lang/Object;Lorg/babyfish/jimmer/sql/fetcher/Fetcher;)Ljava/lang/Object;", "pager", "Lorg/babyfish/jimmer/spring/repository/KRepository$Pager;", "save", "S", "(Ljava/lang/Object;)Ljava/lang/Object;", "input", "Lorg/babyfish/jimmer/spring/model/Input;", "(Lorg/babyfish/jimmer/spring/model/Input;)Ljava/lang/Object;", "saveAll", "PagerImpl", "jimmer-spring-boot-starter"})
public class KRepositoryImpl<E, ID>
implements KRepository<E, ID> {
    @NotNull
    private final KSqlClient sql;
    @NotNull
    private final KClass<E> entityType;
    @NotNull
    private final ImmutableType immutableType;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KRepositoryImpl(@NotNull KSqlClient sql, @Nullable KClass<E> entityType) {
        KClass kClass;
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        this.sql = sql;
        Utils.validateSqlClient(this.getSql().getJavaClient());
        KRepositoryImpl kRepositoryImpl = this;
        if (entityType != null) {
            kClass = entityType;
        } else {
            void it;
            Class[] classArray = GenericTypeResolver.resolveTypeArguments(this.getClass(), JRepository.class);
            if (classArray == null) throw new IllegalArgumentException("The class \"" + this.getClass() + "\" does not explicitly specify the type arguments of \"" + JRepository.class.getName() + "\" so that the entityType must be specified");
            Class[] classArray2 = classArray;
            KRepositoryImpl kRepositoryImpl2 = kRepositoryImpl;
            boolean bl = false;
            void v2 = it[0];
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it[0]");
            KClass kClass2 = JvmClassMappingKt.getKotlinClass((Class)v2);
            Intrinsics.checkNotNull((Object)kClass2, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<E of org.babyfish.jimmer.spring.repository.support.KRepositoryImpl.entityType$lambda-0>");
            kRepositoryImpl = kRepositoryImpl2;
            KClass kClass3 = kClass2;
            if (kClass3 == null) throw new IllegalArgumentException("The class \"" + this.getClass() + "\" does not explicitly specify the type arguments of \"" + JRepository.class.getName() + "\" so that the entityType must be specified");
            kClass = kClass3;
        }
        kRepositoryImpl.entityType = kClass;
        ImmutableType immutableType = ImmutableType.get((Class)JvmClassMappingKt.getJavaClass(this.entityType));
        Intrinsics.checkNotNullExpressionValue((Object)immutableType, (String)"get(this.entityType.java)");
        this.immutableType = immutableType;
    }

    public /* synthetic */ KRepositoryImpl(KSqlClient kSqlClient, KClass kClass, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kClass = null;
        }
        this(kSqlClient, kClass);
    }

    @Override
    @NotNull
    public KSqlClient getSql() {
        return this.sql;
    }

    protected KRepositoryImpl(@NotNull KSqlClient sql, @NotNull Class<E> entityType) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        this(sql, JvmClassMappingKt.getKotlinClass(entityType));
    }

    @NotNull
    protected final KClass<E> getEntityType() {
        return this.entityType;
    }

    protected static /* synthetic */ void getEntityType$annotations() {
    }

    @NotNull
    protected final ImmutableType getImmutableType() {
        return this.immutableType;
    }

    @Override
    @NotNull
    public KRepository.Pager<E> pager(int pageIndex, int pageSize, @Nullable Function1<? super FindDsl<E>, Unit> block) {
        Sort sort = block;
        if (sort == null || (sort = KSortsKt.toSort(sort)) == null) {
            Sort sort2 = Sort.unsorted();
            sort = sort2;
            Intrinsics.checkNotNullExpressionValue((Object)sort2, (String)"unsorted()");
        }
        Sort sort3 = sort;
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sort3);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(pageIndex, pageSize, sort)");
        return new PagerImpl((Pageable)pageRequest);
    }

    @Override
    @NotNull
    public KRepository.Pager<E> pager(@NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return new PagerImpl(pageable);
    }

    @Override
    @Nullable
    public E findNullable(@NotNull ID id, @Nullable Fetcher<E> fetcher) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return (E)(fetcher != null ? this.getSql().getEntities().findById(fetcher, id) : this.getSql().getEntities().findById(this.entityType, id));
    }

    @Override
    @NotNull
    public List<E> findByIds(@NotNull Iterable<? extends ID> ids, @Nullable Fetcher<E> fetcher) {
        List list;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (fetcher != null) {
            KEntities kEntities = this.getSql().getEntities();
            Collection<? extends ID> collection = Utils.toCollection(ids);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"toCollection(ids)");
            list = kEntities.findByIds(fetcher, collection);
        } else {
            KEntities kEntities = this.getSql().getEntities();
            Collection<? extends ID> collection = Utils.toCollection(ids);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"toCollection(ids)");
            list = kEntities.findByIds(this.entityType, collection);
        }
        return list;
    }

    @Override
    @NotNull
    public Map<ID, E> findMapByIds(@NotNull Iterable<? extends ID> ids, @Nullable Fetcher<E> fetcher) {
        Map map;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (fetcher != null) {
            KEntities kEntities = this.getSql().getEntities();
            Collection<? extends ID> collection = Utils.toCollection(ids);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"toCollection(ids)");
            map = kEntities.findMapByIds(fetcher, collection);
        } else {
            KEntities kEntities = this.getSql().getEntities();
            Collection<? extends ID> collection = Utils.toCollection(ids);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"toCollection(ids)");
            map = kEntities.findMapByIds(this.entityType, collection);
        }
        return map;
    }

    @Override
    @NotNull
    public List<E> findAll(@Nullable Fetcher<E> fetcher, @Nullable Function1<? super FindDsl<E>, Unit> block) {
        return fetcher != null ? this.getSql().getEntities().findAll(fetcher, block) : this.getSql().getEntities().findAll(this.entityType, block);
    }

    @Override
    @NotNull
    public List<E> findAll(@Nullable Fetcher<E> fetcher, @NotNull Sort sort) {
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        return fetcher != null ? this.getSql().getEntities().findAll(fetcher, KSortsKt.toFindDslBlock(sort, this.immutableType)) : this.getSql().getEntities().findAll(this.entityType, KSortsKt.toFindDslBlock(sort, this.immutableType));
    }

    @Override
    @NotNull
    public Page<E> findAll(int pageIndex, int pageSize, @Nullable Fetcher<E> fetcher, @Nullable Function1<? super FindDsl<E>, Unit> block) {
        return this.pager(pageIndex, pageSize, block).execute(this.getSql().createQuery(this.entityType, new Function1<KMutableRootQuery<E>, KConfigurableRootQuery<E, E>>(block, fetcher){
            final /* synthetic */ Function1<FindDsl<E>, Unit> $block;
            final /* synthetic */ Fetcher<E> $fetcher;
            {
                this.$block = $block;
                this.$fetcher = $fetcher;
                super(1);
            }

            @NotNull
            public final KConfigurableRootQuery<E, E> invoke(@NotNull KMutableRootQuery<E> $this$createQuery) {
                Intrinsics.checkNotNullParameter($this$createQuery, (String)"$this$createQuery");
                KSortsKt.orderBy((KMutableQuery)$this$createQuery, this.$block);
                return $this$createQuery.select(((KNonNullTable)$this$createQuery.getTable()).fetch(this.$fetcher));
            }
        }));
    }

    @Override
    @NotNull
    public Page<E> findAll(int pageIndex, int pageSize, @Nullable Fetcher<E> fetcher, @NotNull Sort sort) {
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        return this.pager(pageIndex, pageSize, sort).execute(this.getSql().createQuery(this.entityType, new Function1<KMutableRootQuery<E>, KConfigurableRootQuery<E, E>>(sort, fetcher){
            final /* synthetic */ Sort $sort;
            final /* synthetic */ Fetcher<E> $fetcher;
            {
                this.$sort = $sort;
                this.$fetcher = $fetcher;
                super(1);
            }

            @NotNull
            public final KConfigurableRootQuery<E, E> invoke(@NotNull KMutableRootQuery<E> $this$createQuery) {
                Intrinsics.checkNotNullParameter($this$createQuery, (String)"$this$createQuery");
                KSortsKt.orderBy((KMutableQuery)$this$createQuery, this.$sort);
                return $this$createQuery.select(((KNonNullTable)$this$createQuery.getTable()).fetch(this.$fetcher));
            }
        }));
    }

    @Override
    @NotNull
    public Page<E> findAll(@NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return this.findAll(pageable, null);
    }

    @Override
    @NotNull
    public Page<E> findAll(@NotNull Pageable pageable, @Nullable Fetcher<E> fetcher) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return this.pager(pageable).execute(this.getSql().createQuery(this.entityType, new Function1<KMutableRootQuery<E>, KConfigurableRootQuery<E, E>>(pageable, fetcher){
            final /* synthetic */ Pageable $pageable;
            final /* synthetic */ Fetcher<E> $fetcher;
            {
                this.$pageable = $pageable;
                this.$fetcher = $fetcher;
                super(1);
            }

            @NotNull
            public final KConfigurableRootQuery<E, E> invoke(@NotNull KMutableRootQuery<E> $this$createQuery) {
                Intrinsics.checkNotNullParameter($this$createQuery, (String)"$this$createQuery");
                KSortsKt.orderBy((KMutableQuery)$this$createQuery, this.$pageable.getSort());
                return $this$createQuery.select(((KNonNullTable)$this$createQuery.getTable()).fetch(this.$fetcher));
            }
        }));
    }

    @Override
    public long count() {
        return ((Number)KTypedRootQuery.DefaultImpls.fetchOne$default((KTypedRootQuery)((KTypedRootQuery)this.getSql().createQuery(this.entityType, (Function1)count.1.INSTANCE)), null, (int)1, null)).longValue();
    }

    @Override
    @NotNull
    public <S extends E> S save(@NotNull S entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        return (S)KEntities.DefaultImpls.save$default((KEntities)this.getSql().getEntities(), entity, null, (Function1)save.1.INSTANCE, (int)2, null).getModifiedEntity();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <S extends E> List<S> saveAll(@NotNull Iterable<? extends S> entities) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        KEntities kEntities = this.getSql().getEntities();
        Collection<? extends S> collection = Utils.toCollection(entities);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"toCollection(entities)");
        Iterable $this$map$iv = KEntities.DefaultImpls.batchSave$default((KEntities)kEntities, collection, null, (Function1)saveAll.1.INSTANCE, (int)2, null).getSimpleResults();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KSimpleSaveResult kSimpleSaveResult = (KSimpleSaveResult)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getModifiedEntity());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public E save(@NotNull Input<E> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = KEntities.DefaultImpls.save$default((KEntities)this.getSql().getEntities(), input.toEntity(), null, (Function1)save.2.INSTANCE, (int)2, null).getModifiedEntity();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sql.entities.save(input.\u2026\n        }.modifiedEntity");
        return (E)object;
    }

    @Override
    public void delete(@NotNull E entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        KEntities kEntities = this.getSql().getEntities();
        Object object = ImmutableObjects.get(entity, (ImmutableProp)this.immutableType.getIdProp());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(entity, immutableType.idProp)");
        KEntities.DefaultImpls.delete$default((KEntities)kEntities, this.entityType, (Object)object, null, null, (int)12, null);
    }

    @Override
    public void deleteById(@NotNull ID id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        KEntities.DefaultImpls.delete$default((KEntities)this.getSql().getEntities(), this.entityType, id, null, null, (int)12, null);
    }

    @Override
    public void deleteByIds(@NotNull Iterable<? extends ID> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        KEntities kEntities = this.getSql().getEntities();
        Collection<? extends ID> collection = Utils.toCollection(ids);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"toCollection(ids)");
        KEntities.DefaultImpls.batchDelete$default((KEntities)kEntities, this.entityType, collection, null, null, (int)12, null);
    }

    @Override
    public void deleteAll() {
        KExecutable.DefaultImpls.execute$default((KExecutable)this.getSql().createDelete(this.entityType, (Function1)deleteAll.1.INSTANCE), null, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void deleteAll(@NotNull Iterable<? extends E> entities) {
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Iterable<? extends E> iterable = entities;
        KClass<E> kClass = this.entityType;
        KEntities kEntities = this.getSql().getEntities();
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ImmutableObjects.get((Object)it, (ImmutableProp)this.immutableType.getIdProp()));
        }
        collection = (List)destination$iv$iv;
        KEntities.DefaultImpls.batchDelete$default((KEntities)kEntities, kClass, (Collection)collection, null, null, (int)12, null);
    }

    @Override
    @NotNull
    public KRepository.Pager<E> pager(int pageIndex, int pageSize, @Nullable Sort sort) {
        return KRepository.DefaultImpls.pager(this, pageIndex, pageSize, sort);
    }

    @Override
    @NotNull
    public List<E> findAll() {
        return KRepository.DefaultImpls.findAll(this);
    }

    @Override
    @NotNull
    public List<E> findAll(@NotNull Sort sort) {
        return KRepository.DefaultImpls.findAll(this, sort);
    }

    @Override
    @NotNull
    public Optional<E> findById(@NotNull ID id) {
        return KRepository.DefaultImpls.findById(this, id);
    }

    @Override
    @NotNull
    public Optional<E> findById(@NotNull ID id, @NotNull Fetcher<E> fetcher) {
        return KRepository.DefaultImpls.findById(this, id, fetcher);
    }

    @Override
    @AliasFor(value="findByIds")
    @NotNull
    public List<E> findAllById(@NotNull Iterable<? extends ID> ids) {
        return KRepository.DefaultImpls.findAllById(this, ids);
    }

    @Override
    public boolean existsById(@NotNull ID id) {
        return KRepository.DefaultImpls.existsById(this, id);
    }

    @Override
    @AliasFor(value="deleteByIds")
    public void deleteAllById(@NotNull Iterable<? extends ID> ids) {
        KRepository.DefaultImpls.deleteAllById(this, ids);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u00072\u0010\u0010\b\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/babyfish/jimmer/spring/repository/support/KRepositoryImpl$PagerImpl;", "E", "Lorg/babyfish/jimmer/spring/repository/KRepository$Pager;", "pageable", "Lorg/springframework/data/domain/Pageable;", "(Lorg/springframework/data/domain/Pageable;)V", "execute", "Lorg/springframework/data/domain/Page;", "query", "Lorg/babyfish/jimmer/sql/kt/ast/query/KConfigurableRootQuery;", "jimmer-spring-boot-starter"})
    private static final class PagerImpl<E>
    implements KRepository.Pager<E> {
        @NotNull
        private final Pageable pageable;

        public PagerImpl(@NotNull Pageable pageable) {
            Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
            this.pageable = pageable;
        }

        @Override
        @NotNull
        public Page<E> execute(@NotNull KConfigurableRootQuery<?, E> query) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            if (this.pageable.getPageSize() == 0) {
                return (Page)new PageImpl((List)KExecutable.DefaultImpls.execute$default((KExecutable)((KExecutable)query), null, (int)1, null));
            }
            long offset = this.pageable.getOffset();
            if (!(offset <= (long)(Integer.MAX_VALUE - this.pageable.getPageSize()))) {
                boolean $i$a$-require-KRepositoryImpl$PagerImpl$execute$22 = false;
                String $i$a$-require-KRepositoryImpl$PagerImpl$execute$22 = "offset is too big";
                throw new IllegalArgumentException($i$a$-require-KRepositoryImpl$PagerImpl$execute$22.toString());
            }
            int total = KConfigurableRootQuery.DefaultImpls.count$default(query, null, (int)1, null);
            List content = (List)KExecutable.DefaultImpls.execute$default((KExecutable)((KExecutable)query.limit(this.pageable.getPageSize(), (int)offset)), null, (int)1, null);
            return (Page)new PageImpl(content, this.pageable, (long)total);
        }
    }
}

