/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cfg;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;

@ConstructorBinding
@ConfigurationProperties(value="jimmer")
public class JimmerProperties {
    @NotNull
    private final TypeScript ts;

    public JimmerProperties(@Nullable TypeScript ts) {
        this.ts = ts == null ? new TypeScript(null) : ts;
    }

    @NotNull
    public TypeScript getTs() {
        return this.ts;
    }

    @ConstructorBinding
    public static class TypeScript {
        @Nullable
        private final String path;

        public TypeScript(@Nullable String path) {
            if (path == null || path.isEmpty()) {
                this.path = null;
            } else {
                if (!path.startsWith("/")) {
                    throw new IllegalArgumentException("`jimmer.ts.path` must start with \"/\"");
                }
                this.path = path;
            }
        }

        @Nullable
        public String getPath() {
            return this.path;
        }

        public String toString() {
            return "TypeScript{path='" + this.path + '\'' + '}';
        }
    }
}

