/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.bytecode;

import java.lang.reflect.Method;
import org.babyfish.jimmer.impl.asm.MethodVisitor;
import org.babyfish.jimmer.spring.repository.bytecode.ClassCodeWriter;

public class MethodCodeWriter {
    protected final ClassCodeWriter parent;
    protected final Method method;
    private MethodVisitor mv;

    protected MethodCodeWriter(ClassCodeWriter parent, Method method) {
        this.parent = parent;
        this.method = method;
    }

    public void write() {
        if (!this.method.isDefault()) {
            throw new IllegalStateException("The current version does not support spring-data-style abstract custom method \"" + String.valueOf(this.method) + "\", please wait for the next version. Now, you can write strongly typed DSL using java-default method.");
        }
    }

    protected void visitLoadSqlClient() {
        this.mv.visitVarInsn(25, 0);
        this.mv.visitFieldInsn(180, this.parent.getImplInternalName(), "sqlClient", this.parent.getSqlClientDescriptor());
    }

    public MethodVisitor getMethodVisitor() {
        return this.mv;
    }

    protected void visitReturn(Class<?> type) {
        if (type == Void.TYPE) {
            this.mv.visitInsn(177);
        } else if (type == Boolean.TYPE) {
            this.mv.visitInsn(172);
        } else if (type == Character.TYPE) {
            this.mv.visitInsn(172);
        } else if (type == Byte.TYPE) {
            this.mv.visitInsn(172);
        } else if (type == Short.TYPE) {
            this.mv.visitInsn(172);
        } else if (type == Integer.TYPE) {
            this.mv.visitInsn(172);
        } else if (type == Long.TYPE) {
            this.mv.visitInsn(173);
        } else if (type == Float.TYPE) {
            this.mv.visitInsn(174);
        } else if (type == Double.TYPE) {
            this.mv.visitInsn(175);
        } else {
            this.mv.visitInsn(176);
        }
    }

    protected static class VarLoader {
        private final MethodVisitor mv;
        private int slot;

        public VarLoader(MethodVisitor mv, int slot) {
            this.mv = mv;
            this.slot = slot;
        }

        public void load(Class<?> type) {
            if (type == Boolean.TYPE) {
                this.mv.visitVarInsn(21, this.slot++);
            } else if (type == Character.TYPE) {
                this.mv.visitVarInsn(21, this.slot++);
            } else if (type == Byte.TYPE) {
                this.mv.visitVarInsn(21, this.slot++);
            } else if (type == Short.TYPE) {
                this.mv.visitVarInsn(21, this.slot++);
            } else if (type == Integer.TYPE) {
                this.mv.visitVarInsn(21, this.slot++);
            } else if (type == Long.TYPE) {
                this.mv.visitVarInsn(22, this.slot);
                this.slot += 2;
            } else if (type == Float.TYPE) {
                this.mv.visitVarInsn(23, this.slot++);
            } else if (type == Double.TYPE) {
                this.mv.visitVarInsn(24, this.slot);
                this.slot += 2;
            } else {
                this.mv.visitVarInsn(25, this.slot++);
            }
        }
    }
}

