/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.bytecode;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.babyfish.jimmer.impl.asm.ClassWriter;
import org.babyfish.jimmer.impl.asm.MethodVisitor;
import org.babyfish.jimmer.impl.asm.Type;
import org.babyfish.jimmer.spring.repository.bytecode.MethodCodeWriter;
import org.springframework.data.repository.core.RepositoryInformation;

public abstract class ClassCodeWriter {
    public static final String ASM_IMPL_SUFFIX = "{AsmImpl}";
    private final RepositoryInformation metadata;
    private final Class<?> superType;
    private final String interfaceInternalName;
    private final String implInternalName;
    private final String superInternalName;
    private final String entityInternalName;
    private final String sqlClientInternalName;
    private final String sqlClientDescriptor;
    private ClassWriter cw;

    protected ClassCodeWriter(RepositoryInformation metadata, Class<?> sqlClientType, Class<?> superType) {
        this.metadata = metadata;
        this.superType = superType;
        this.interfaceInternalName = Type.getInternalName((Class)metadata.getRepositoryInterface());
        this.implInternalName = this.interfaceInternalName + ASM_IMPL_SUFFIX;
        this.superInternalName = Type.getInternalName(superType);
        this.entityInternalName = Type.getInternalName((Class)metadata.getDomainType());
        this.sqlClientInternalName = Type.getInternalName(sqlClientType);
        this.sqlClientDescriptor = Type.getDescriptor(sqlClientType);
    }

    public RepositoryInformation getMetadata() {
        return this.metadata;
    }

    public String getInterfaceInternalName() {
        return this.interfaceInternalName;
    }

    public String getImplInternalName() {
        return this.implInternalName;
    }

    public String getEntityInternalName() {
        return this.entityInternalName;
    }

    public String getSqlClientInternalName() {
        return this.sqlClientInternalName;
    }

    public String getSqlClientDescriptor() {
        return this.sqlClientDescriptor;
    }

    public ClassWriter getClassVisitor() {
        return this.cw;
    }

    public byte[] write() {
        this.cw = new ClassWriter(3);
        this.cw.visit(52, 1, this.implInternalName, null, this.superInternalName, null);
        this.writeInit();
        Class repositoryInterface = this.metadata.getRepositoryInterface();
        for (Method method : repositoryInterface.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass().isAssignableFrom(this.superType)) continue;
            this.createMethodCodeWriter(method).write();
        }
        this.cw.visitEnd();
        return this.cw.toByteArray();
    }

    private void writeInit() {
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", "(" + this.sqlClientDescriptor + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)Type.getType((Class)this.metadata.getDomainType()));
        mv.visitMethodInsn(183, this.superInternalName, "<init>", "(" + this.sqlClientDescriptor + "Ljava/lang/Class;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected MethodCodeWriter createMethodCodeWriter(Method method) {
        return new MethodCodeWriter(this, method);
    }

    public static String implementationClassName(Class<?> itf) {
        return itf.getName() + ASM_IMPL_SUFFIX;
    }
}

