/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.mapstruct.ap;

import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.babyfish.jimmer.mapstruct.ap.ImmutableUtils;
import org.mapstruct.ap.spi.BuilderInfo;
import org.mapstruct.ap.spi.DefaultBuilderProvider;
import org.mapstruct.ap.spi.TypeHierarchyErroneousException;

public class ImmutableBuilderProvider
extends DefaultBuilderProvider {
    public BuilderInfo findBuilderInfo(TypeMirror type) {
        Element element;
        if (type.getKind() == TypeKind.DECLARED && ImmutableUtils.isImmutable(element = ((DeclaredType)type).asElement())) {
            String qualifiedName = ((TypeElement)element).getQualifiedName().toString() + "Draft.MapStruct";
            TypeElement builderElement = this.elementUtils.getTypeElement(qualifiedName);
            if (builderElement == null) {
                throw new TypeHierarchyErroneousException(type);
            }
            return this.parseBuilderInfo(builderElement);
        }
        return super.findBuilderInfo(type);
    }

    private BuilderInfo parseBuilderInfo(TypeElement builderElement) {
        ExecutableElement creator = null;
        ExecutableElement builder = null;
        for (Element element : this.elementUtils.getAllMembers(builderElement)) {
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                creator = (ExecutableElement)element;
            }
            if (element.getKind() != ElementKind.METHOD || !((ExecutableElement)element).getParameters().isEmpty()) continue;
            builder = (ExecutableElement)element;
        }
        return new BuilderInfo.Builder().builderCreationMethod(creator).buildMethod(Collections.singletonList(builder)).build();
    }
}

