/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.ksp.dto;

import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.babyfish.jimmer.dto.compiler.DtoAstException;
import org.babyfish.jimmer.dto.compiler.DtoFile;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.ksp.Context;
import org.babyfish.jimmer.ksp.KspDtoCompiler;
import org.babyfish.jimmer.ksp.UtilsKt;
import org.babyfish.jimmer.ksp.dto.DtoContext;
import org.babyfish.jimmer.ksp.dto.DtoException;
import org.babyfish.jimmer.ksp.dto.DtoGenerator;
import org.babyfish.jimmer.ksp.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.ksp.immutable.meta.ImmutableType;
import org.babyfish.jimmer.sql.Entity;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\n\u001a \u0012\u0004\u0012\u00020\f\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000e0\r0\u000bH\u0002J.\u0010\u0010\u001a\u00020\u00112$\u0010\u0012\u001a \u0012\u0004\u0012\u00020\f\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000e0\u00130\u000bH\u0002J\u0006\u0010\u0014\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/babyfish/jimmer/ksp/dto/DtoProcessor;", "", "ctx", "Lorg/babyfish/jimmer/ksp/Context;", "dtoDirs", "", "", "dtoMutable", "", "(Lorg/babyfish/jimmer/ksp/Context;Ljava/util/Collection;Z)V", "findDtoTypeMap", "", "Lorg/babyfish/jimmer/ksp/immutable/meta/ImmutableType;", "", "Lorg/babyfish/jimmer/dto/compiler/DtoType;", "Lorg/babyfish/jimmer/ksp/immutable/meta/ImmutableProp;", "generateDtoTypes", "", "dtoTypeMap", "", "process", "jimmer-ksp"})
public final class DtoProcessor {
    @NotNull
    private final Context ctx;
    @NotNull
    private final Collection<String> dtoDirs;
    private final boolean dtoMutable;

    public DtoProcessor(@NotNull Context ctx, @NotNull Collection<String> dtoDirs, boolean dtoMutable) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(dtoDirs, (String)"dtoDirs");
        this.ctx = ctx;
        this.dtoDirs = dtoDirs;
        this.dtoMutable = dtoMutable;
    }

    public final boolean process() {
        Map<ImmutableType, List<DtoType<ImmutableType, ImmutableProp>>> dtoTypeMap = this.findDtoTypeMap();
        this.generateDtoTypes(dtoTypeMap);
        return !dtoTypeMap.isEmpty();
    }

    private final Map<ImmutableType, List<DtoType<ImmutableType, ImmutableProp>>> findDtoTypeMap() {
        KspDtoCompiler compiler;
        Map dtoTypeMap = new LinkedHashMap();
        DtoContext dtoCtx = new DtoContext((KSFile)SequencesKt.firstOrNull((Sequence)this.ctx.getResolver().getAllFiles()), this.dtoDirs);
        Map immutableTypeMap = new LinkedHashMap();
        for (DtoFile entry : dtoCtx.getDtoFiles()) {
            KspDtoCompiler kspDtoCompiler;
            try {
                kspDtoCompiler = new KspDtoCompiler(entry);
            }
            catch (DtoAstException ex) {
                throw new DtoException("Failed to parse \"" + entry.getAbsolutePath() + "\": " + ex.getMessage(), ex);
            }
            catch (Throwable ex) {
                throw new DtoException("Failed to read \"" + entry.getAbsolutePath() + "\": " + ex.getMessage(), ex);
            }
            compiler = kspDtoCompiler;
            Resolver resolver = this.ctx.getResolver();
            String string = compiler.getSourceTypeName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compiler.sourceTypeName");
            KSClassDeclaration classDeclaration = com.google.devtools.ksp.UtilsKt.getClassDeclarationByName((Resolver)resolver, (String)string);
            if (classDeclaration == null) {
                throw new DtoException("Failed to parse \"" + entry.getAbsolutePath() + "\": No entity type \"" + compiler.getSourceTypeName() + '\"', null, 2, null);
            }
            if (!this.ctx.include(classDeclaration)) continue;
            if (UtilsKt.annotation((KSAnnotated)classDeclaration, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Entity.class)) == null) {
                throw new DtoException("Failed to parse \"" + entry.getAbsolutePath() + "\": the \"" + compiler.getSourceTypeName() + "\" is not decorated by \"@" + Reflection.getOrCreateKotlinClass(Entity.class).getQualifiedName() + '\"', null, 2, null);
            }
            immutableTypeMap.put(compiler, this.ctx.typeOf(classDeclaration));
        }
        this.ctx.resolve();
        for (Map.Entry entry : immutableTypeMap.entrySet()) {
            compiler = (KspDtoCompiler)((Object)entry.getKey());
            ImmutableType immutableType = (ImmutableType)entry.getValue();
            List list = dtoTypeMap.computeIfAbsent(immutableType, DtoProcessor::findDtoTypeMap$lambda-0);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"dtoTypeMap.computeIfAbse\u2026bleListOf()\n            }");
            Collection collection = list;
            List list2 = compiler.compile(immutableType);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"compiler.compile(immutableType)");
            Iterable iterable = list2;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
        return dtoTypeMap;
    }

    private final void generateDtoTypes(Map<ImmutableType, ? extends List<? extends DtoType<ImmutableType, ImmutableProp>>> dtoTypeMap) {
        List allFiles = SequencesKt.toList((Sequence)this.ctx.getResolver().getAllFiles());
        for (List<? extends DtoType<ImmutableType, ImmutableProp>> list : dtoTypeMap.values()) {
            for (DtoType<ImmutableType, ImmutableProp> dtoType : list) {
                new DtoGenerator(this.ctx, dtoType, this.dtoMutable, this.ctx.getEnvironment().getCodeGenerator()).generate(allFiles);
            }
        }
    }

    private static final List findDtoTypeMap$lambda-0(ImmutableType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }
}

