/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.ksp.generator;

import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.babyfish.jimmer.ksp.MetaException;
import org.babyfish.jimmer.ksp.generator.ConstantsKt;
import org.babyfish.jimmer.ksp.generator.UtilsKt;
import org.babyfish.jimmer.ksp.generator.ValidationGenerator;
import org.babyfish.jimmer.ksp.generator.ValidationsKt;
import org.babyfish.jimmer.ksp.meta.ImmutableProp;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\rH\u0002J\b\u0010\u0012\u001a\u00020\rH\u0002J\b\u0010\u0013\u001a\u00020\rH\u0002J\b\u0010\u0014\u001a\u00020\rH\u0002J\b\u0010\u0015\u001a\u00020\rH\u0002J\b\u0010\u0016\u001a\u00020\rH\u0002J\b\u0010\u0017\u001a\u00020\rH\u0002J\u0014\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J;\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"H\u0002\u00a2\u0006\u0002\u0010#J\"\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\t2\b\u0010(\u001a\u0004\u0018\u00010\tH\u0002R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/babyfish/jimmer/ksp/generator/ValidationGenerator;", "", "prop", "Lorg/babyfish/jimmer/ksp/meta/ImmutableProp;", "parent", "Lcom/squareup/kotlinpoet/CodeBlock$Builder;", "(Lorg/babyfish/jimmer/ksp/meta/ImmutableProp;Lcom/squareup/kotlinpoet/CodeBlock$Builder;)V", "annoMultiMap", "", "", "", "Lcom/google/devtools/ksp/symbol/KSAnnotation;", "generate", "", "generateAssert", "generateBound", "generateConstraints", "generateDigits", "generateEmail", "generateNotBlank", "generateNotEmpty", "generatePattern", "generateSize", "generateTime", "isSimpleType", "", "type", "Lkotlin/reflect/KClass;", "validate", "condition", "args", "", "errorMessage", "defaultMessageSupplier", "Lkotlin/Function0;", "(Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "validateBound", "bound", "Ljava/math/BigDecimal;", "cmp", "message", "jimmer-ksp"})
public final class ValidationGenerator {
    @NotNull
    private final ImmutableProp prop;
    @NotNull
    private final CodeBlock.Builder parent;
    @NotNull
    private final Map<String, List<KSAnnotation>> annoMultiMap;

    public ValidationGenerator(@NotNull ImmutableProp prop, @NotNull CodeBlock.Builder parent) {
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.prop = prop;
        this.parent = parent;
        this.annoMultiMap = ValidationsKt.getValidationAnnotationMirrorMultiMap(this.prop);
    }

    public final void generate() {
        List<KSAnnotation> nullityAnnotations2 = this.prop.annotations((Function1<? super KSAnnotation, Boolean>)((Function1)generate.nullityAnnotations.1.INSTANCE));
        if (!((Collection)nullityAnnotations2).isEmpty()) {
            throw new MetaException((KSDeclaration)this.prop.getPropDeclaration(), "it cannot be decorated by that annotation '@" + org.babyfish.jimmer.ksp.UtilsKt.getFullName(nullityAnnotations2.get(0)) + "', kotlin decides the nullity of property by language, not by annotation", null, 4, null);
        }
        this.generateNotEmpty();
        this.generateNotBlank();
        this.generateSize();
        this.generateBound();
        this.generateEmail();
        this.generatePattern();
        this.generateConstraints();
        this.generateAssert();
        this.generateDigits();
        this.generateTime();
    }

    private final void generateNotEmpty() {
        KSAnnotation kSAnnotation = this.annoMultiMap.get("NotEmpty");
        if (kSAnnotation == null || (kSAnnotation = kSAnnotation.get(0)) == null) {
            return;
        }
        KSAnnotation notEmpty = kSAnnotation;
        if (!this.isSimpleType(Reflection.getOrCreateKotlinClass(String.class)) && !this.isSimpleType(Reflection.getOrCreateKotlinClass(List.class))) {
            throw new MetaException((KSDeclaration)this.prop.getPropDeclaration(), "it's decorated by the annotation @" + org.babyfish.jimmer.ksp.UtilsKt.getFullName(notEmpty) + " but its type is neither string nor list", null, 4, null);
        }
        Object[] objectArray = new Object[]{this.prop.getName()};
        this.validate("%L.isEmpty()", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(notEmpty, "message"), (Function0<String>)((Function0)generateNotEmpty.1.INSTANCE));
    }

    private final void generateNotBlank() {
        KSAnnotation kSAnnotation = this.annoMultiMap.get("NotBlank");
        if (kSAnnotation == null || (kSAnnotation = kSAnnotation.get(0)) == null) {
            return;
        }
        KSAnnotation notBlank = kSAnnotation;
        if (!this.isSimpleType(Reflection.getOrCreateKotlinClass(String.class))) {
            throw new MetaException((KSDeclaration)this.prop.getPropDeclaration(), "it's decorated by the annotation @" + org.babyfish.jimmer.ksp.UtilsKt.getFullName(notBlank) + " but its type is not string", null, 4, null);
        }
        Object[] objectArray = new Object[]{this.prop.getName()};
        this.validate("%L.trim().isEmpty()", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(notBlank, "message"), (Function0<String>)((Function0)generateNotBlank.1.INSTANCE));
    }

    private final void generateSize() {
        String sizeProp;
        List sizes;
        List list = this.annoMultiMap.get("Size");
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if ((sizes = list).isEmpty()) {
            return;
        }
        if (!this.isSimpleType(Reflection.getOrCreateKotlinClass(String.class)) && !this.isSimpleType(Reflection.getOrCreateKotlinClass(List.class))) {
            throw new MetaException((KSDeclaration)this.prop.getPropDeclaration(), "it's decorated by the annotation @" + org.babyfish.jimmer.ksp.UtilsKt.getFullName((KSAnnotation)sizes.get(0)) + " but its type is neither string nor list", null, 4, null);
        }
        int min = 0;
        int max = Integer.MAX_VALUE;
        String minMessage = null;
        String maxMessage = null;
        for (KSAnnotation size : sizes) {
            Object t = org.babyfish.jimmer.ksp.UtilsKt.get(size, "min");
            Intrinsics.checkNotNull(t);
            int sizeMin = ((Number)t).intValue();
            if (sizeMin > min) {
                min = sizeMin;
                minMessage = (String)org.babyfish.jimmer.ksp.UtilsKt.get(size, "message");
            }
            Object t2 = org.babyfish.jimmer.ksp.UtilsKt.get(size, "max");
            Intrinsics.checkNotNull(t2);
            int sizeMax = ((Number)t2).intValue();
            if (sizeMax >= max) continue;
            max = sizeMax;
            maxMessage = (String)org.babyfish.jimmer.ksp.UtilsKt.get(size, "message");
        }
        if (min > max) {
            throw new MetaException((KSDeclaration)this.prop.getPropDeclaration(), "its size validation rules is illegal so that there is not valid length", null, 4, null);
        }
        if (min == 0 && max == Integer.MAX_VALUE) {
            return;
        }
        String string = sizeProp = this.isSimpleType(Reflection.getOrCreateKotlinClass(String.class)) ? "length" : "size";
        if (min > 0) {
            int finalValue = min;
            Object[] objectArray = new Object[]{this.prop.getName(), sizeProp, finalValue};
            this.validate("%L.%L < %L", objectArray, minMessage, (Function0<String>)((Function0)new Function0<String>(finalValue){
                final /* synthetic */ int $finalValue;
                {
                    this.$finalValue = $finalValue;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "it cannot be less than " + this.$finalValue;
                }
            }));
        }
        if (max < Integer.MAX_VALUE) {
            int finalValue = max;
            Object[] objectArray = new Object[]{this.prop.getName(), sizeProp, finalValue};
            this.validate("%L.%L > %L", objectArray, maxMessage, (Function0<String>)((Function0)new Function0<String>(finalValue){
                final /* synthetic */ int $finalValue;
                {
                    this.$finalValue = $finalValue;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "it cannot be greater than " + this.$finalValue;
                }
            }));
        }
    }

    private final void generateBound() {
        BigDecimal value;
        List decimalMaxList;
        Object[] objectArray;
        List annotations2;
        List list;
        List decimalMinList;
        List list2;
        List negativeOrZeros;
        List list3;
        List negatives;
        List list4;
        List positiveOrZeros;
        List list5;
        List positives;
        List list6;
        List maxList;
        List list7;
        List minList;
        List list8 = this.annoMultiMap.get("Min");
        if (list8 == null) {
            list8 = minList = CollectionsKt.emptyList();
        }
        if ((list7 = this.annoMultiMap.get("Max")) == null) {
            list7 = maxList = CollectionsKt.emptyList();
        }
        if ((list6 = this.annoMultiMap.get("Positive")) == null) {
            list6 = positives = CollectionsKt.emptyList();
        }
        if ((list5 = this.annoMultiMap.get("PositiveOrZero")) == null) {
            list5 = positiveOrZeros = CollectionsKt.emptyList();
        }
        if ((list4 = this.annoMultiMap.get("Negative")) == null) {
            list4 = negatives = CollectionsKt.emptyList();
        }
        if ((list3 = this.annoMultiMap.get("NegativeOrZero")) == null) {
            list3 = negativeOrZeros = CollectionsKt.emptyList();
        }
        if ((list2 = this.annoMultiMap.get("DecimalMin")) == null) {
            list2 = decimalMinList = CollectionsKt.emptyList();
        }
        if ((list = this.annoMultiMap.get("DecimalMax")) == null) {
            list = CollectionsKt.emptyList();
        }
        if ((annotations2 = CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])(objectArray = new List[]{minList, maxList, positives, positiveOrZeros, negatives, negativeOrZeros, decimalMinList, decimalMaxList = list})))).isEmpty()) {
            return;
        }
        if (!(org.babyfish.jimmer.ksp.UtilsKt.isBuiltInType$default(ImmutableProp.typeName$default(this.prop, false, null, 3, null), null, 1, null) || this.isSimpleType(Reflection.getOrCreateKotlinClass(BigInteger.class)) || this.isSimpleType(Reflection.getOrCreateKotlinClass(BigDecimal.class)))) {
            throw new MetaException((KSDeclaration)this.prop.getPropDeclaration(), "it's decorated by the annotation @" + org.babyfish.jimmer.ksp.UtilsKt.getFullName((KSAnnotation)annotations2.get(0)) + " but its type is numeric", null, 4, null);
        }
        BigDecimal minValue = null;
        BigDecimal maxValue = null;
        String message = null;
        for (KSAnnotation min : minList) {
            Object t = org.babyfish.jimmer.ksp.UtilsKt.get(min, "value");
            Intrinsics.checkNotNull(t);
            long annoValue = ((Number)t).longValue();
            if (minValue != null && new BigDecimal(annoValue).compareTo(minValue) <= 0) continue;
            minValue = new BigDecimal(annoValue);
            message = (String)org.babyfish.jimmer.ksp.UtilsKt.get(min, "message");
        }
        for (KSAnnotation decimalMin : decimalMinList) {
            Object t = org.babyfish.jimmer.ksp.UtilsKt.get(decimalMin, "value");
            Intrinsics.checkNotNull(t);
            String annoValue = (String)t;
            value = new BigDecimal(annoValue);
            if (minValue != null && value.compareTo(minValue) <= 0) continue;
            minValue = value;
            message = (String)org.babyfish.jimmer.ksp.UtilsKt.get(decimalMin, "message");
        }
        for (KSAnnotation positive : positives) {
            if (minValue != null && BigDecimal.ONE.compareTo(minValue) <= 0) continue;
            minValue = BigDecimal.ONE;
            message = (String)org.babyfish.jimmer.ksp.UtilsKt.get(positive, "message");
        }
        for (KSAnnotation positiveOrZero : positiveOrZeros) {
            if (minValue != null && BigDecimal.ZERO.compareTo(minValue) <= 0) continue;
            minValue = BigDecimal.ZERO;
            message = (String)org.babyfish.jimmer.ksp.UtilsKt.get(positiveOrZero, "message");
        }
        for (KSAnnotation max : maxList) {
            Object t = org.babyfish.jimmer.ksp.UtilsKt.get(max, "value");
            Intrinsics.checkNotNull(t);
            long annoValue = ((Number)t).longValue();
            if (maxValue != null && new BigDecimal(annoValue).compareTo(maxValue) >= 0) continue;
            maxValue = new BigDecimal(annoValue);
            message = (String)org.babyfish.jimmer.ksp.UtilsKt.get(max, "message");
        }
        for (KSAnnotation decimalMax : decimalMaxList) {
            Object t = org.babyfish.jimmer.ksp.UtilsKt.get(decimalMax, "value");
            Intrinsics.checkNotNull(t);
            String annoValue = (String)t;
            value = new BigDecimal(annoValue);
            if (maxValue != null && value.compareTo(maxValue) >= 0) continue;
            maxValue = value;
            message = (String)org.babyfish.jimmer.ksp.UtilsKt.get(decimalMax, "message");
        }
        for (KSAnnotation negative : negatives) {
            if (maxValue != null && BigDecimal.ONE.negate().compareTo(maxValue) >= 0) continue;
            maxValue = BigDecimal.ONE.negate();
            message = (String)org.babyfish.jimmer.ksp.UtilsKt.get(negative, "message");
        }
        for (KSAnnotation negativeOrZero : negativeOrZeros) {
            if (maxValue != null && BigDecimal.ZERO.compareTo(maxValue) >= 0) continue;
            maxValue = BigDecimal.ZERO;
            message = (String)org.babyfish.jimmer.ksp.UtilsKt.get(negativeOrZero, "message");
        }
        if (minValue != null && maxValue != null && minValue.compareTo(maxValue) > 0) {
            throw new MetaException((KSDeclaration)this.prop.getPropDeclaration(), "its numeric range validation rules is illegal so that there is not valid number", null, 4, null);
        }
        if (minValue != null) {
            this.validateBound(minValue, "<", message);
        }
        if (maxValue != null) {
            this.validateBound(maxValue, ">", message);
        }
    }

    private final void generateEmail() {
        KSAnnotation kSAnnotation = this.annoMultiMap.get("Email");
        if (kSAnnotation == null || (kSAnnotation = kSAnnotation.get(0)) == null) {
            return;
        }
        KSAnnotation email = kSAnnotation;
        if (!this.isSimpleType(Reflection.getOrCreateKotlinClass(String.class))) {
            throw new MetaException((KSDeclaration)this.prop.getPropDeclaration(), "it's decorated by the annotation @" + org.babyfish.jimmer.ksp.UtilsKt.getFullName(email) + " but its type is not string", null, 4, null);
        }
        Object[] objectArray = new Object[]{"__email_pattern", this.prop.getName()};
        this.validate("!%L.matcher(%L).matches()", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(email, "message"), (Function0<String>)((Function0)generateEmail.1.INSTANCE));
    }

    private final void generatePattern() {
        List<KSAnnotation> list = this.annoMultiMap.get("Pattern");
        if (list == null) {
            return;
        }
        List<KSAnnotation> patterns = list;
        if (!this.isSimpleType(Reflection.getOrCreateKotlinClass(String.class))) {
            throw new MetaException((KSDeclaration)this.prop.getPropDeclaration(), "it's decorated by the annotation @" + org.babyfish.jimmer.ksp.UtilsKt.getFullName(patterns.get(0)) + " but its type is not string", null, 4, null);
        }
        int n = patterns.size();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = new Object[]{UtilsKt.regexpPatternFieldName(this.prop, i), this.prop.getName()};
            this.validate("!%L.matcher(%L).matches()", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(patterns.get(i), "message"), (Function0<String>)((Function0)new Function0<String>(patterns, i){
                final /* synthetic */ List<KSAnnotation> $patterns;
                final /* synthetic */ int $i;
                {
                    this.$patterns = $patterns;
                    this.$i = $i;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("it does not match the regexp '");
                    T t = org.babyfish.jimmer.ksp.UtilsKt.get(this.$patterns.get(this.$i), "regexp");
                    Intrinsics.checkNotNull(t);
                    return stringBuilder.append(StringsKt.replace$default((String)((String)t), (String)"\\", (String)"\\\\", (boolean)false, (int)4, null)).append('\'').toString();
                }
            }));
        }
    }

    private final void generateConstraints() {
        for (Map.Entry<ClassName, String> e : this.prop.getValidationMessages().entrySet()) {
            Object[] objectArray = new Object[]{UtilsKt.validatorFieldName(this.prop, e.getKey()), this.prop.getName()};
            this.parent.addStatement("%L.validate(%L)", objectArray);
        }
    }

    private final void generateAssert() {
        boolean $i$f$emptyArray;
        List assertTrueList;
        Object object;
        List annotations2;
        List list;
        List assertFalseList;
        List list2 = this.annoMultiMap.get("AssertFalse");
        if (list2 == null) {
            list2 = assertFalseList = CollectionsKt.emptyList();
        }
        if ((list = this.annoMultiMap.get("AssertTrue")) == null) {
            list = CollectionsKt.emptyList();
        }
        if ((annotations2 = CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])(object = new List[]{assertFalseList, assertTrueList = list})))).isEmpty()) {
            return;
        }
        if (!this.isSimpleType(Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            throw new MetaException((KSDeclaration)this.prop.getPropDeclaration(), "it's decorated by the annotation @" + org.babyfish.jimmer.ksp.UtilsKt.getFullName((KSAnnotation)annotations2.get(0)) + " but its type is not boolean", null, 4, null);
        }
        for (KSAnnotation assertFalse : assertFalseList) {
            $i$f$emptyArray = false;
            this.validate(this.prop.getName() + " != false", new Object[0], (String)org.babyfish.jimmer.ksp.UtilsKt.get(assertFalse, "message"), (Function0<String>)((Function0)generateAssert.1.INSTANCE));
        }
        for (KSAnnotation assertTrue : assertTrueList) {
            $i$f$emptyArray = false;
            this.validate(this.prop.getName() + " != true", new Object[0], (String)org.babyfish.jimmer.ksp.UtilsKt.get(assertTrue, "message"), (Function0<String>)((Function0)generateAssert.2.INSTANCE));
        }
    }

    private final void generateDigits() {
        int fraction;
        KSAnnotation kSAnnotation = this.annoMultiMap.get("Digits");
        if (kSAnnotation == null || (kSAnnotation = kSAnnotation.get(0)) == null) {
            return;
        }
        KSAnnotation digits = kSAnnotation;
        if (!(org.babyfish.jimmer.ksp.UtilsKt.isBuiltInType$default(ImmutableProp.typeName$default(this.prop, false, null, 3, null), null, 1, null) || this.isSimpleType(Reflection.getOrCreateKotlinClass(BigDecimal.class)) || this.isSimpleType(Reflection.getOrCreateKotlinClass(BigInteger.class)) || this.isSimpleType(Reflection.getOrCreateKotlinClass(CharSequence.class)))) {
            throw new MetaException((KSDeclaration)this.prop.getPropDeclaration(), "it's decorated by the annotation @" + org.babyfish.jimmer.ksp.UtilsKt.getFullName(digits) + " but its type is not BigDecimal", null, 4, null);
        }
        Integer n = (Integer)org.babyfish.jimmer.ksp.UtilsKt.get(digits, "integer");
        int integer = n != null ? n : 0;
        Integer n2 = (Integer)org.babyfish.jimmer.ksp.UtilsKt.get(digits, "fraction");
        int n3 = fraction = n2 != null ? n2 : 0;
        if (integer < 0 || fraction < 0) {
            throw new MetaException((KSDeclaration)this.prop.getPropDeclaration(), "its numeric range validation rules is illegal so that there is not valid number", null, 4, null);
        }
        if (integer == 0 && fraction == 0) {
            throw new MetaException((KSDeclaration)this.prop.getPropDeclaration(), "its numeric range validation rules is illegal so that there is not valid number", null, 4, null);
        }
        if (Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getBIG_DECIMAL_CLASS_NAME())) {
            Object[] objectArray;
            if (integer > 0) {
                objectArray = new Object[]{this.prop.getName(), integer};
                this.validate("%L.precision() > %L", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(digits, "message"), (Function0<String>)((Function0)new Function0<String>(integer){
                    final /* synthetic */ int $integer;
                    {
                        this.$integer = $integer;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "it's precision is less than " + this.$integer;
                    }
                }));
            }
            if (fraction > 0) {
                objectArray = new Object[]{this.prop.getName(), fraction};
                this.validate("%L.scale() > %L", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(digits, "message"), (Function0<String>)((Function0)new Function0<String>(fraction){
                    final /* synthetic */ int $fraction;
                    {
                        this.$fraction = $fraction;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "it's scale is less than " + this.$fraction;
                    }
                }));
            }
        } else if (Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getBIG_INTEGER_CLASS_NAME())) {
            Object[] objectArray = new Object[]{this.prop.getName(), integer};
            this.validate("%L.precision() > %L", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(digits, "message"), (Function0<String>)((Function0)new Function0<String>(integer){
                final /* synthetic */ int $integer;
                {
                    this.$integer = $integer;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "it's precision is less than " + this.$integer;
                }
            }));
        } else {
            Object[] objectArray = new Object[]{this.prop.getName(), integer + fraction};
            this.validate("%L.toString().length > %L", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(digits, "message"), (Function0<String>)((Function0)new Function0<String>(integer, fraction){
                final /* synthetic */ int $integer;
                final /* synthetic */ int $fraction;
                {
                    this.$integer = $integer;
                    this.$fraction = $fraction;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "it's length is less than " + (this.$integer + this.$fraction);
                }
            }));
        }
    }

    private final void generateTime() {
        Object[] objectArray;
        List futures;
        Object object;
        List annotations2;
        List list;
        List futureOrPresents;
        List list2;
        List pasts;
        List list3;
        List pastOrPresents;
        List list4 = this.annoMultiMap.get("PastOrPresent");
        if (list4 == null) {
            list4 = pastOrPresents = CollectionsKt.emptyList();
        }
        if ((list3 = this.annoMultiMap.get("Past")) == null) {
            list3 = pasts = CollectionsKt.emptyList();
        }
        if ((list2 = this.annoMultiMap.get("FutureOrPresent")) == null) {
            list2 = futureOrPresents = CollectionsKt.emptyList();
        }
        if ((list = this.annoMultiMap.get("Future")) == null) {
            list = CollectionsKt.emptyList();
        }
        if ((annotations2 = CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])(object = new List[]{pastOrPresents, pasts, futureOrPresents, futures = list})))).isEmpty()) {
            return;
        }
        if (!(this.isSimpleType(Reflection.getOrCreateKotlinClass(LocalDate.class)) || this.isSimpleType(Reflection.getOrCreateKotlinClass(LocalDateTime.class)) || this.isSimpleType(Reflection.getOrCreateKotlinClass(LocalTime.class)))) {
            throw new MetaException((KSDeclaration)this.prop.getPropDeclaration(), "it's decorated by the annotation @" + org.babyfish.jimmer.ksp.UtilsKt.getFullName((KSAnnotation)annotations2.get(0)) + " but its type is not date or time", null, 4, null);
        }
        for (KSAnnotation pastOrPresent : pastOrPresents) {
            if (Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getLOCAL_DATE_CLASS_NAME())) {
                objectArray = new Object[]{this.prop.getName(), Reflection.getOrCreateKotlinClass(LocalDate.class)};
                this.validate("%L.isAfter(%T.now())", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(pastOrPresent, "message"), (Function0<String>)((Function0)generateTime.1.INSTANCE));
                continue;
            }
            if (Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getLOCAL_DATE_TIME_CLASS_NAME())) {
                objectArray = new Object[]{this.prop.getName(), Reflection.getOrCreateKotlinClass(LocalDateTime.class)};
                this.validate("%L.isAfter(%T.now())", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(pastOrPresent, "message"), (Function0<String>)((Function0)generateTime.2.INSTANCE));
                continue;
            }
            if (!Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getLOCAL_TIME_CLASS_NAME())) continue;
            objectArray = new Object[]{this.prop.getName(), Reflection.getOrCreateKotlinClass(LocalTime.class)};
            this.validate("%L.isAfter(%T.now())", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(pastOrPresent, "message"), (Function0<String>)((Function0)generateTime.3.INSTANCE));
        }
        for (KSAnnotation past : pasts) {
            if (Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getLOCAL_DATE_CLASS_NAME())) {
                objectArray = new Object[]{this.prop.getName(), Reflection.getOrCreateKotlinClass(LocalDate.class)};
                this.validate("%L.isAfter(%T.now()) || %L.isEqual(%T.now())", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(past, "message"), (Function0<String>)((Function0)generateTime.4.INSTANCE));
                continue;
            }
            if (Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getLOCAL_DATE_TIME_CLASS_NAME())) {
                objectArray = new Object[]{this.prop.getName(), Reflection.getOrCreateKotlinClass(LocalDateTime.class)};
                this.validate("%L.isAfter(%T.now()) || %L.isEqual(%T.now())", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(past, "message"), (Function0<String>)((Function0)generateTime.5.INSTANCE));
                continue;
            }
            if (!Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getLOCAL_TIME_CLASS_NAME())) continue;
            objectArray = new Object[]{this.prop.getName(), Reflection.getOrCreateKotlinClass(LocalTime.class)};
            this.validate("%L.isAfter(%T.now()) || %L.isEqual(%T.now())", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(past, "message"), (Function0<String>)((Function0)generateTime.6.INSTANCE));
        }
        for (KSAnnotation futureOrPresent : futureOrPresents) {
            if (Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getLOCAL_DATE_CLASS_NAME())) {
                objectArray = new Object[]{this.prop.getName(), Reflection.getOrCreateKotlinClass(LocalDate.class)};
                this.validate("%L.isBefore(%T.now())", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(futureOrPresent, "message"), (Function0<String>)((Function0)generateTime.7.INSTANCE));
                continue;
            }
            if (Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getLOCAL_DATE_TIME_CLASS_NAME())) {
                objectArray = new Object[]{this.prop.getName(), Reflection.getOrCreateKotlinClass(LocalDateTime.class)};
                this.validate("%L.isBefore(%T.now())", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(futureOrPresent, "message"), (Function0<String>)((Function0)generateTime.8.INSTANCE));
                continue;
            }
            if (!Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getLOCAL_TIME_CLASS_NAME())) continue;
            objectArray = new Object[]{this.prop.getName(), Reflection.getOrCreateKotlinClass(LocalTime.class)};
            this.validate("%L.isBefore(%T.now())", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(futureOrPresent, "message"), (Function0<String>)((Function0)generateTime.9.INSTANCE));
        }
        for (KSAnnotation future : futures) {
            if (Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getLOCAL_DATE_CLASS_NAME())) {
                objectArray = new Object[]{this.prop.getName(), Reflection.getOrCreateKotlinClass(LocalDate.class)};
                this.validate("%L.isBefore(%T.now()) || %L.isEqual(%T.now())", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(future, "message"), (Function0<String>)((Function0)generateTime.10.INSTANCE));
                continue;
            }
            if (Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getLOCAL_DATE_TIME_CLASS_NAME())) {
                objectArray = new Object[]{this.prop.getName(), Reflection.getOrCreateKotlinClass(LocalDateTime.class)};
                this.validate("%L.isBefore(%T.now()) || %L.isEqual(%T.now())", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(future, "message"), (Function0<String>)((Function0)generateTime.11.INSTANCE));
                continue;
            }
            if (!Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getLOCAL_TIME_CLASS_NAME())) continue;
            objectArray = new Object[]{this.prop.getName(), Reflection.getOrCreateKotlinClass(LocalTime.class)};
            this.validate("%L.isBefore(%T.now()) || %L.isEqual(%T.now())", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(future, "message"), (Function0<String>)((Function0)generateTime.12.INSTANCE));
        }
    }

    private final void validate(String condition, Object[] args, String errorMessage, Function0<String> defaultMessageSupplier) {
        if (!this.prop.isNullable() || org.babyfish.jimmer.ksp.UtilsKt.isBuiltInType(ImmutableProp.typeName$default(this.prop, false, null, 3, null), false)) {
            this.parent.beginControlFlow("if (" + condition + ')', Arrays.copyOf(args, args.length));
        } else {
            this.parent.beginControlFlow("if (" + this.prop.getName() + " != null && " + condition + ')', Arrays.copyOf(args, args.length));
        }
        if (errorMessage == null || ((CharSequence)errorMessage).length() == 0 || StringsKt.startsWith$default((String)errorMessage, (String)"{javax.validation.constraints.", (boolean)false, (int)2, null)) {
            CodeBlock.Builder builder;
            CodeBlock.Builder $this$validate_u24lambda_u2d0 = builder = this.parent;
            boolean bl = false;
            Object[] objectArray = new Object[]{Reflection.getOrCreateKotlinClass(ValidationException.class)};
            $this$validate_u24lambda_u2d0.add("throw %T(\n", objectArray);
            $this$validate_u24lambda_u2d0.indent();
            objectArray = new Object[]{"Illegal value'"};
            $this$validate_u24lambda_u2d0.add("%S", objectArray);
            $this$validate_u24lambda_u2d0.add(" +\n", new Object[0]);
            objectArray = new Object[]{this.prop.getName()};
            $this$validate_u24lambda_u2d0.add("%L", objectArray);
            $this$validate_u24lambda_u2d0.add(" +\n", new Object[0]);
            objectArray = new Object[]{"'for property '" + this.prop + "', "};
            $this$validate_u24lambda_u2d0.add("%S", objectArray);
            $this$validate_u24lambda_u2d0.add(" +\n", new Object[0]);
            objectArray = new Object[]{defaultMessageSupplier.invoke()};
            $this$validate_u24lambda_u2d0.add("%S", objectArray);
            $this$validate_u24lambda_u2d0.unindent();
            $this$validate_u24lambda_u2d0.addStatement(")", new Object[0]);
        }
        this.parent.endControlFlow();
    }

    private final boolean isSimpleType(KClass<?> type) {
        ClassName className2;
        TypeName typeName = ImmutableProp.typeName$default(this.prop, false, null, 3, null);
        if (typeName instanceof ClassName) {
            className2 = (ClassName)typeName;
        } else if (typeName instanceof ParameterizedTypeName) {
            className2 = ((ParameterizedTypeName)typeName).getRawType();
        } else {
            return false;
        }
        ClassName it = className2;
        boolean bl = false;
        TypeName className3 = it.isNullable() ? TypeName.copy$default((TypeName)((TypeName)it), (boolean)false, null, (int)2, null) : (TypeName)it;
        return Intrinsics.areEqual((Object)className3, (Object)ClassNames.get(type));
    }

    private final void validateBound(BigDecimal bound, String cmp, String message) {
        Object[] objectArray;
        Object[] objectArray2;
        String bigNumLiteral = Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getBIG_DECIMAL_CLASS_NAME()) ? (Intrinsics.areEqual((Object)(objectArray2 = bound), (Object)BigDecimal.ZERO) ? "%T.ZERO" : (Intrinsics.areEqual((Object)objectArray2, (Object)BigDecimal.ONE) ? "%T.ONE" : (Intrinsics.areEqual((Object)objectArray2, (Object)BigDecimal.TEN) ? "%T.TEN" : "%T.valueOf(" + bound + ')'))) : (Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getBIG_INTEGER_CLASS_NAME()) ? (Intrinsics.areEqual((Object)(objectArray2 = bound), (Object)BigDecimal.ONE.negate()) ? "%T.NEGATIVE_ONE" : (Intrinsics.areEqual((Object)objectArray2, (Object)BigDecimal.ZERO) ? "%T.ZERO" : (Intrinsics.areEqual((Object)objectArray2, (Object)BigDecimal.ONE) ? "%T.ONE" : (Intrinsics.areEqual((Object)objectArray2, (Object)BigDecimal.TEN) ? "%T.TEN" : "%T.valueOf(" + bound + ')')))) : null);
        String string = bigNumLiteral != null ? "%L.compareTo(" + bigNumLiteral + ") %L 0" : "%L %L %L";
        if (bigNumLiteral != null) {
            objectArray2 = new Object[]{this.prop.getName(), ImmutableProp.typeName$default(this.prop, false, false, 1, null), cmp};
            objectArray = objectArray2;
        } else {
            objectArray2 = new Object[]{this.prop.getName(), cmp, bound};
            objectArray = objectArray2;
        }
        this.validate(string, objectArray, message, (Function0<String>)((Function0)new Function0<String>(cmp, (BigDecimal)bound){
            final /* synthetic */ String $cmp;
            final /* synthetic */ BigDecimal $bound;
            {
                this.$cmp = $cmp;
                this.$bound = $bound;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "it cannot be " + (Intrinsics.areEqual((Object)this.$cmp, (Object)"<") ? "less than" : "greater than") + ' ' + this.$bound;
            }
        }));
    }
}

