/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.ksp.dto;

import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.ClassKind;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSTypeReference;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.babyfish.jimmer.dto.compiler.DtoAstException;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.TypeRef;
import org.babyfish.jimmer.ksp.Context;
import org.babyfish.jimmer.ksp.MetaException;
import org.babyfish.jimmer.ksp.UtilsKt;
import org.babyfish.jimmer.ksp.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.ksp.immutable.meta.ImmutableType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u001a4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"abstractPropNames", "", "", "ctx", "Lorg/babyfish/jimmer/ksp/Context;", "dtoType", "Lorg/babyfish/jimmer/dto/compiler/DtoType;", "Lorg/babyfish/jimmer/ksp/immutable/meta/ImmutableType;", "Lorg/babyfish/jimmer/ksp/immutable/meta/ImmutableProp;", "collectMembers", "", "declaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "handledTypeNames", "", "propNames", "jimmer-ksp"})
public final class DtoInterfacesKt {
    @NotNull
    public static final Set<String> abstractPropNames(@NotNull Context ctx, @NotNull DtoType<ImmutableType, ImmutableProp> dtoType) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(dtoType, (String)"dtoType");
        if (dtoType.getSuperInterfaces().isEmpty()) {
            return SetsKt.emptySet();
        }
        Set propNames = new LinkedHashSet();
        Set handledTypeNames = new LinkedHashSet();
        for (TypeRef typeRef : dtoType.getSuperInterfaces()) {
            KSClassDeclaration declaration2;
            Resolver resolver = ctx.getResolver();
            String string = typeRef.getTypeName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeRef.typeName");
            if (com.google.devtools.ksp.UtilsKt.getClassDeclarationByName((Resolver)resolver, (String)string) == null) {
                throw new IllegalStateException(("Internal bug: super interface \"" + typeRef.getTypeName() + "\" does not exists").toString());
            }
            if (declaration2.getClassKind() != ClassKind.INTERFACE) {
                throw new DtoAstException(dtoType.getDtoFile(), typeRef.getLine(), typeRef.getCol(), "The super type \"" + typeRef.getTypeName() + "\" is not interface");
            }
            DtoInterfacesKt.collectMembers(declaration2, ctx, handledTypeNames, propNames);
        }
        return propNames;
    }

    private static final void collectMembers(KSClassDeclaration declaration2, Context ctx, Set<String> handledTypeNames, Set<String> propNames) {
        KSName kSName = declaration2.getQualifiedName();
        Intrinsics.checkNotNull((Object)kSName);
        String qualifiedName = kSName.asString();
        if (!handledTypeNames.add(qualifiedName)) {
            return;
        }
        for (KSFunctionDeclaration func : com.google.devtools.ksp.UtilsKt.getDeclaredFunctions((KSClassDeclaration)declaration2)) {
            String name = func.getSimpleName().asString();
            if (Intrinsics.areEqual((Object)name, (Object)"hashCode") && func.getParameters().isEmpty() || Intrinsics.areEqual((Object)name, (Object)"equals") && func.getParameters().size() == 1 || Intrinsics.areEqual((Object)name, (Object)"toString") && func.getParameters().isEmpty() || !func.isAbstract()) continue;
            throw new MetaException((KSDeclaration)func, "Illegal abstract method, the declaring interface \"" + qualifiedName + "\" or its derived interface is used as the super interface of generated DTO type so that this abstract method cannot have generic parameters", null, 4, null);
        }
        for (KSPropertyDeclaration prop : com.google.devtools.ksp.UtilsKt.getDeclaredProperties((KSClassDeclaration)declaration2)) {
            ((Collection)propNames).add(UtilsKt.getName(prop));
        }
        for (KSTypeReference superType : declaration2.getSuperTypes()) {
            KSDeclaration kSDeclaration = superType.resolve().getDeclaration();
            Intrinsics.checkNotNull((Object)kSDeclaration, (String)"null cannot be cast to non-null type com.google.devtools.ksp.symbol.KSClassDeclaration");
            KSClassDeclaration superDeclaration = (KSClassDeclaration)kSDeclaration;
            DtoInterfacesKt.collectMembers(superDeclaration, ctx, handledTypeNames, propNames);
        }
    }
}

