/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.ksp.generator;

import com.google.devtools.ksp.symbol.KSAnnotation;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.babyfish.jimmer.ksp.generator.ConstantsKt;
import org.babyfish.jimmer.ksp.generator.UtilsKt;
import org.babyfish.jimmer.ksp.generator.ValidationGenerator;
import org.babyfish.jimmer.ksp.meta.ImmutableProp;
import org.babyfish.jimmer.ksp.meta.MetaException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0002J\b\u0010\f\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J;\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\"\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/babyfish/jimmer/ksp/generator/ValidationGenerator;", "", "prop", "Lorg/babyfish/jimmer/ksp/meta/ImmutableProp;", "parent", "Lcom/squareup/kotlinpoet/CodeBlock$Builder;", "(Lorg/babyfish/jimmer/ksp/meta/ImmutableProp;Lcom/squareup/kotlinpoet/CodeBlock$Builder;)V", "generate", "", "generateBound", "generateConstraints", "generateEmail", "generateNotBlank", "generateNotEmpty", "generatePattern", "generateSize", "isSimpleType", "", "type", "Lkotlin/reflect/KClass;", "validate", "condition", "", "args", "", "errorMessage", "defaultMessageSupplier", "Lkotlin/Function0;", "(Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "validateBound", "bound", "", "cmp", "message", "jimmer-ksp"})
public final class ValidationGenerator {
    @NotNull
    private final ImmutableProp prop;
    @NotNull
    private final CodeBlock.Builder parent;

    public ValidationGenerator(@NotNull ImmutableProp prop, @NotNull CodeBlock.Builder parent) {
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.prop = prop;
        this.parent = parent;
    }

    public final void generate() {
        List<KSAnnotation> nullityAnnotations2 = this.prop.annotations((Function1<? super KSAnnotation, Boolean>)((Function1)generate.nullityAnnotations.1.INSTANCE));
        if (!((Collection)nullityAnnotations2).isEmpty()) {
            throw new MetaException("The prop '" + this.prop + "' cannot be decorated by that annotation '@" + org.babyfish.jimmer.ksp.UtilsKt.getFullName(nullityAnnotations2.get(0)) + "', kotlin decides the nullity of property by language, not by annotation", null, 2, null);
        }
        this.generateNotEmpty();
        this.generateNotBlank();
        this.generateSize();
        this.generateBound();
        this.generateEmail();
        this.generatePattern();
        this.generateConstraints();
    }

    private final void generateNotEmpty() {
        KSAnnotation notEmpty = this.prop.annotation((KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(NotEmpty.class));
        if (notEmpty == null) {
            return;
        }
        if (!this.isSimpleType(Reflection.getOrCreateKotlinClass(String.class)) && !this.isSimpleType(Reflection.getOrCreateKotlinClass(List.class))) {
            throw new MetaException("Illegal property \"" + this.prop + "\", it's decorated by the annotation @" + org.babyfish.jimmer.ksp.UtilsKt.getFullName(notEmpty) + " but its type is neither string nor list", null, 2, null);
        }
        Object[] objectArray = new Object[]{this.prop.getName()};
        this.validate("%L.isEmpty()", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(notEmpty, "message"), (Function0<String>)((Function0)generateNotEmpty.1.INSTANCE));
    }

    private final void generateNotBlank() {
        KSAnnotation notBlank = this.prop.annotation((KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(NotBlank.class));
        if (notBlank == null) {
            return;
        }
        if (!this.isSimpleType(Reflection.getOrCreateKotlinClass(String.class))) {
            throw new MetaException("Illegal property \"" + this.prop + "\", it's decorated by the annotation @" + org.babyfish.jimmer.ksp.UtilsKt.getFullName(notBlank) + " but its type is not string", null, 2, null);
        }
        Object[] objectArray = new Object[]{this.prop.getName()};
        this.validate("%L.trim().isEmpty()", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(notBlank, "message"), (Function0<String>)((Function0)generateNotBlank.1.INSTANCE));
    }

    private final void generateSize() {
        String sizeProp;
        List<KSAnnotation> sizes = this.prop.annotations((KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Size.class));
        if (sizes.isEmpty()) {
            return;
        }
        if (!this.isSimpleType(Reflection.getOrCreateKotlinClass(String.class)) && !this.isSimpleType(Reflection.getOrCreateKotlinClass(List.class))) {
            throw new MetaException("Illegal property \"" + this.prop + "\", it's decorated by the annotation @" + Reflection.getOrCreateKotlinClass(Size.class).getQualifiedName() + " but its type is neither string nor list", null, 2, null);
        }
        int min = 0;
        int max = Integer.MAX_VALUE;
        String minMessage = null;
        String maxMessage = null;
        for (KSAnnotation size : sizes) {
            Object t = org.babyfish.jimmer.ksp.UtilsKt.get(size, "min");
            Intrinsics.checkNotNull(t);
            int sizeMin = ((Number)t).intValue();
            if (sizeMin > min) {
                min = sizeMin;
                minMessage = (String)org.babyfish.jimmer.ksp.UtilsKt.get(size, "message");
            }
            Object t2 = org.babyfish.jimmer.ksp.UtilsKt.get(size, "max");
            Intrinsics.checkNotNull(t2);
            int sizeMax = ((Number)t2).intValue();
            if (sizeMax >= max) continue;
            max = sizeMax;
            maxMessage = (String)org.babyfish.jimmer.ksp.UtilsKt.get(size, "message");
        }
        if (min > max) {
            throw new MetaException("Illegal property \"" + this.prop + "\", its size validation rules is illegal so that there is not valid length", null, 2, null);
        }
        if (min == 0 && max == Integer.MAX_VALUE) {
            return;
        }
        String string = sizeProp = this.isSimpleType(Reflection.getOrCreateKotlinClass(String.class)) ? "length" : "size";
        if (min > 0) {
            int finalValue = min;
            Object[] objectArray = new Object[]{this.prop.getName(), sizeProp, finalValue};
            this.validate("%L.%L < %L", objectArray, minMessage, (Function0<String>)((Function0)new Function0<String>(finalValue){
                final /* synthetic */ int $finalValue;
                {
                    this.$finalValue = $finalValue;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "it cannot be less than " + this.$finalValue;
                }
            }));
        }
        if (max < Integer.MAX_VALUE) {
            int finalValue = max;
            Object[] objectArray = new Object[]{this.prop.getName(), sizeProp, finalValue};
            this.validate("%L.%L > %L", objectArray, maxMessage, (Function0<String>)((Function0)new Function0<String>(finalValue){
                final /* synthetic */ int $finalValue;
                {
                    this.$finalValue = $finalValue;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "it cannot be greater than " + this.$finalValue;
                }
            }));
        }
    }

    private final void generateBound() {
        long annoValue;
        List<KSAnnotation> negativeOrZeros;
        List<KSAnnotation> negatives;
        List<KSAnnotation> positiveOrZeros;
        List<KSAnnotation> positives;
        List<KSAnnotation> maxArr;
        List<KSAnnotation> minArr = this.prop.annotations((KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Min.class));
        Object[] objectArray = new List[]{minArr, maxArr = this.prop.annotations((KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Max.class)), positives = this.prop.annotations((KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Positive.class)), positiveOrZeros = this.prop.annotations((KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(PositiveOrZero.class)), negatives = this.prop.annotations((KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Negative.class)), negativeOrZeros = this.prop.annotations((KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(NegativeOrZero.class))};
        List annotations2 = CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray));
        if (annotations2.isEmpty()) {
            return;
        }
        if (!(org.babyfish.jimmer.ksp.UtilsKt.isBuiltInType$default(ImmutableProp.typeName$default(this.prop, false, null, 3, null), null, 1, null) || this.isSimpleType(Reflection.getOrCreateKotlinClass(BigInteger.class)) || this.isSimpleType(Reflection.getOrCreateKotlinClass(BigDecimal.class)))) {
            throw new MetaException("Illegal property \"" + this.prop + "\", it's decorated by the annotation @" + org.babyfish.jimmer.ksp.UtilsKt.getFullName((KSAnnotation)annotations2.get(0)) + " but its type is numeric", null, 2, null);
        }
        Long minValue = null;
        Long maxValue = null;
        String message = null;
        for (KSAnnotation min : minArr) {
            Object t = org.babyfish.jimmer.ksp.UtilsKt.get(min, "value");
            Intrinsics.checkNotNull(t);
            annoValue = ((Number)t).longValue();
            if (minValue != null && annoValue <= minValue) continue;
            minValue = annoValue;
            message = (String)org.babyfish.jimmer.ksp.UtilsKt.get(min, "message");
        }
        for (KSAnnotation positive : positives) {
            if (minValue != null && 1L <= minValue) continue;
            minValue = 1L;
            message = (String)org.babyfish.jimmer.ksp.UtilsKt.get(positive, "message");
        }
        for (KSAnnotation positiveOrZero : positiveOrZeros) {
            if (minValue != null && 0L <= minValue) continue;
            minValue = 0L;
            message = (String)org.babyfish.jimmer.ksp.UtilsKt.get(positiveOrZero, "message");
        }
        for (KSAnnotation max : maxArr) {
            Object t = org.babyfish.jimmer.ksp.UtilsKt.get(max, "value");
            Intrinsics.checkNotNull(t);
            annoValue = ((Number)t).longValue();
            if (maxValue != null && annoValue >= maxValue) continue;
            maxValue = annoValue;
            message = (String)org.babyfish.jimmer.ksp.UtilsKt.get(max, "message");
        }
        for (KSAnnotation negative : negatives) {
            if (maxValue != null && -1L >= maxValue) continue;
            maxValue = -1L;
            message = (String)org.babyfish.jimmer.ksp.UtilsKt.get(negative, "message");
        }
        for (KSAnnotation negativeOrZero : negativeOrZeros) {
            if (maxValue != null && 0L >= maxValue) continue;
            maxValue = 0L;
            message = (String)org.babyfish.jimmer.ksp.UtilsKt.get(negativeOrZero, "message");
        }
        if (minValue != null && maxValue != null && minValue > maxValue) {
            throw new MetaException("Illegal property \"" + this.prop + "\", its numeric range validation rules is illegal so that there is not valid number", null, 2, null);
        }
        if (minValue != null) {
            long finalValue = minValue;
            this.validateBound(minValue, "<", message);
        }
        if (maxValue != null) {
            this.validateBound(maxValue, ">", message);
        }
    }

    private final void generateEmail() {
        KSAnnotation email = this.prop.annotation((KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Email.class));
        if (email == null) {
            return;
        }
        if (!this.isSimpleType(Reflection.getOrCreateKotlinClass(String.class))) {
            throw new MetaException("Illegal property \"" + this.prop + "\", it's decorated by the annotation @" + org.babyfish.jimmer.ksp.UtilsKt.getFullName(email) + " but its type is not string", null, 2, null);
        }
        Object[] objectArray = new Object[]{"__email_pattern", this.prop.getName()};
        this.validate("!%L.matcher(%L).matches()", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(email, "message"), (Function0<String>)((Function0)generateEmail.1.INSTANCE));
    }

    private final void generatePattern() {
        List<KSAnnotation> patterns = this.prop.annotations((KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Pattern.class));
        if (patterns.isEmpty()) {
            return;
        }
        if (!this.isSimpleType(Reflection.getOrCreateKotlinClass(String.class))) {
            throw new MetaException("Illegal property \"" + this.prop + "\", it's decorated by the annotation @" + org.babyfish.jimmer.ksp.UtilsKt.getFullName(patterns.get(0)) + " but its type is not string", null, 2, null);
        }
        int n = patterns.size();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = new Object[]{UtilsKt.regexpPatternFieldName(this.prop, i), this.prop.getName()};
            this.validate("!%L.matcher(%L).matches()", objectArray, (String)org.babyfish.jimmer.ksp.UtilsKt.get(patterns.get(i), "message"), (Function0<String>)((Function0)new Function0<String>(patterns, i){
                final /* synthetic */ List<KSAnnotation> $patterns;
                final /* synthetic */ int $i;
                {
                    this.$patterns = $patterns;
                    this.$i = $i;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("it does not match the regexp '");
                    T t = org.babyfish.jimmer.ksp.UtilsKt.get(this.$patterns.get(this.$i), "regexp");
                    Intrinsics.checkNotNull(t);
                    return stringBuilder.append(StringsKt.replace$default((String)((String)t), (String)"\\", (String)"\\\\", (boolean)false, (int)4, null)).append('\'').toString();
                }
            }));
        }
    }

    private final void generateConstraints() {
        for (Map.Entry<ClassName, String> e : this.prop.getValidationMessages().entrySet()) {
            Object[] objectArray = new Object[]{UtilsKt.validatorFieldName(this.prop, e.getKey()), this.prop.getName()};
            this.parent.addStatement("%L.validate(%L)", objectArray);
        }
    }

    private final void validate(String condition, Object[] args, String errorMessage, Function0<String> defaultMessageSupplier) {
        String errorMessage2 = errorMessage;
        if (!this.prop.isNullable() || org.babyfish.jimmer.ksp.UtilsKt.isBuiltInType(ImmutableProp.typeName$default(this.prop, false, null, 3, null), false)) {
            this.parent.beginControlFlow("if (" + condition + ')', Arrays.copyOf(args, args.length));
        } else {
            this.parent.beginControlFlow("if (" + this.prop.getName() + " != null && " + condition + ')', Arrays.copyOf(args, args.length));
        }
        if (errorMessage2 == null || ((CharSequence)errorMessage2).length() == 0 || StringsKt.startsWith$default((String)errorMessage2, (String)"{javax.validation.constraints.", (boolean)false, (int)2, null)) {
            CodeBlock.Builder builder;
            CodeBlock.Builder $this$validate_u24lambda_u2d0 = builder = this.parent;
            boolean bl = false;
            Object[] objectArray = new Object[]{Reflection.getOrCreateKotlinClass(ValidationException.class)};
            $this$validate_u24lambda_u2d0.add("throw %T(\n", objectArray);
            $this$validate_u24lambda_u2d0.indent();
            objectArray = new Object[]{"Illegal value'"};
            $this$validate_u24lambda_u2d0.add("%S", objectArray);
            $this$validate_u24lambda_u2d0.add(" +\n", new Object[0]);
            objectArray = new Object[]{this.prop.getName()};
            $this$validate_u24lambda_u2d0.add("%L", objectArray);
            $this$validate_u24lambda_u2d0.add(" +\n", new Object[0]);
            objectArray = new Object[]{"'for property '" + this.prop + "', "};
            $this$validate_u24lambda_u2d0.add("%S", objectArray);
            $this$validate_u24lambda_u2d0.add(" +\n", new Object[0]);
            objectArray = new Object[]{defaultMessageSupplier.invoke()};
            $this$validate_u24lambda_u2d0.add("%S", objectArray);
            $this$validate_u24lambda_u2d0.unindent();
            $this$validate_u24lambda_u2d0.addStatement(")", new Object[0]);
        }
        this.parent.endControlFlow();
    }

    private final boolean isSimpleType(KClass<?> type) {
        ClassName className2;
        TypeName typeName = ImmutableProp.typeName$default(this.prop, false, null, 3, null);
        if (typeName instanceof ClassName) {
            className2 = (ClassName)typeName;
        } else if (typeName instanceof ParameterizedTypeName) {
            className2 = ((ParameterizedTypeName)typeName).getRawType();
        } else {
            return false;
        }
        ClassName it = className2;
        boolean bl = false;
        TypeName className3 = it.isNullable() ? TypeName.copy$default((TypeName)((TypeName)it), (boolean)false, null, (int)2, null) : (TypeName)it;
        return Intrinsics.areEqual((Object)className3, (Object)ClassNames.get(type));
    }

    private final void validateBound(long bound, String cmp, String message) {
        Object[] objectArray;
        long l;
        String bigNumLiteral = Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getBIG_DECIMAL_CLASS_NAME()) ? ((l = bound) == 0L ? "%T.ZERO" : (l == 1L ? "%T.ONE" : (l == 2L ? "%T.TWO" : (l == 10L ? "%T.TEN" : "%T.valueOf(" + bound + ')')))) : (Intrinsics.areEqual((Object)ImmutableProp.typeName$default(this.prop, false, false, 1, null), (Object)ConstantsKt.getBIG_INTEGER_CLASS_NAME()) ? ((l = bound) == -1L ? "%T.NEGATIVE_ONE" : (l == 0L ? "%T.ZERO" : (l == 1L ? "%T.ONE" : (l == 2L ? "%T.TWO" : (l == 10L ? "%T.TEN" : "%T.valueOf(" + bound + ')'))))) : null);
        String string = bigNumLiteral != null ? "%L.compareTo(" + bigNumLiteral + ") %L 0" : "%L %L %L";
        if (bigNumLiteral != null) {
            Object[] objectArray2 = new Object[]{this.prop.getName(), ImmutableProp.typeName$default(this.prop, false, false, 1, null), cmp};
            objectArray = objectArray2;
        } else {
            Object[] objectArray3 = new Object[]{this.prop.getName(), cmp, bound};
            objectArray = objectArray3;
        }
        this.validate(string, objectArray, message, (Function0<String>)((Function0)new Function0<String>(cmp, bound){
            final /* synthetic */ String $cmp;
            final /* synthetic */ long $bound;
            {
                this.$cmp = $cmp;
                this.$bound = $bound;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "it cannot be " + (Intrinsics.areEqual((Object)this.$cmp, (Object)"<") ? "less than" : "greater than") + ' ' + this.$bound;
            }
        }));
    }
}

