/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.ksp.generator;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.LambdaTypeName;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Suppress;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.babyfish.jimmer.ksp.generator.ConstantsKt;
import org.babyfish.jimmer.ksp.meta.Context;
import org.babyfish.jimmer.ksp.meta.ImmutableProp;
import org.babyfish.jimmer.ksp.meta.ImmutableType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eJ\u001c\u0010\u000f\u001a\u00020\f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J,\u0010\u0015\u001a\u00020\f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/babyfish/jimmer/ksp/generator/TableGenerator;", "", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "ctx", "Lorg/babyfish/jimmer/ksp/meta/Context;", "file", "Lcom/google/devtools/ksp/symbol/KSFile;", "modelClassDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "(Lcom/google/devtools/ksp/processing/CodeGenerator;Lorg/babyfish/jimmer/ksp/meta/Context;Lcom/google/devtools/ksp/symbol/KSFile;Lcom/google/devtools/ksp/symbol/KSClassDeclaration;)V", "generate", "", "allFiles", "", "addFetchByFun", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "type", "Lorg/babyfish/jimmer/ksp/meta/ImmutableType;", "nullable", "", "addProp", "prop", "Lorg/babyfish/jimmer/ksp/meta/ImmutableProp;", "nonNullTable", "outerJoin", "jimmer-ksp"})
public final class TableGenerator {
    @NotNull
    private final CodeGenerator codeGenerator;
    @NotNull
    private final Context ctx;
    @NotNull
    private final KSFile file;
    @NotNull
    private final KSClassDeclaration modelClassDeclaration;

    public TableGenerator(@NotNull CodeGenerator codeGenerator, @NotNull Context ctx, @NotNull KSFile file, @NotNull KSClassDeclaration modelClassDeclaration) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)modelClassDeclaration, (String)"modelClassDeclaration");
        this.codeGenerator = codeGenerator;
        this.ctx = ctx;
        this.file = file;
        this.modelClassDeclaration = modelClassDeclaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void generate(@NotNull List<? extends KSFile> allFiles) {
        String string;
        Intrinsics.checkNotNullParameter(allFiles, (String)"allFiles");
        String it = this.file.getFileName();
        boolean bl = false;
        int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)it, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (lastDotIndex == -1) {
            string = it + "Table";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = it.substring(0, lastDotIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = stringBuilder.append(string2).append("Table").toString();
        }
        String draftFileName = string;
        Collection $this$toTypedArray$iv = allFiles;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        KSFile[] kSFileArray = thisCollection$iv.toArray(new KSFile[0]);
        Intrinsics.checkNotNull((Object)kSFileArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Object object = kSFileArray;
        object = CodeGenerator.createNewFile$default((CodeGenerator)this.codeGenerator, (Dependencies)new Dependencies(false, Arrays.copyOf(object, ((KSFile[])object).length)), (String)this.file.getPackageName().asString(), (String)draftFileName, null, (int)8, null);
        Throwable throwable = null;
        try {
            void $this$generate_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1;
            FileSpec.Builder builder;
            OutputStream it2 = (OutputStream)object;
            boolean bl2 = false;
            FileSpec.Builder $this$generate_u24lambda_u2d3_u24lambda_u2d2 = builder = FileSpec.Companion.builder(this.file.getPackageName().asString(), draftFileName);
            boolean bl3 = false;
            $this$generate_u24lambda_u2d3_u24lambda_u2d2.indent("    ");
            AnnotationSpec.Builder builder2 = AnnotationSpec.Companion.builder(Reflection.getOrCreateKotlinClass(Suppress.class));
            AnnotationSpec.Builder builder3 = builder2;
            FileSpec.Builder builder4 = $this$generate_u24lambda_u2d3_u24lambda_u2d2;
            boolean bl4 = false;
            $this$generate_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.addMember("\"RedundantVisibilityModifier\"", new Object[0]);
            $this$generate_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.addMember("\"Unused\"", new Object[0]);
            builder4.addAnnotation(builder2.build());
            ImmutableType type = this.ctx.typeOf(this.modelClassDeclaration);
            for (ImmutableProp prop : type.getProperties().values()) {
                this.addProp($this$generate_u24lambda_u2d3_u24lambda_u2d2, type, prop, false, false);
                this.addProp($this$generate_u24lambda_u2d3_u24lambda_u2d2, type, prop, true, false);
                this.addProp($this$generate_u24lambda_u2d3_u24lambda_u2d2, type, prop, false, true);
                this.addProp($this$generate_u24lambda_u2d3_u24lambda_u2d2, type, prop, true, true);
            }
            this.addFetchByFun($this$generate_u24lambda_u2d3_u24lambda_u2d2, type, false);
            this.addFetchByFun($this$generate_u24lambda_u2d3_u24lambda_u2d2, type, true);
            FileSpec fileSpec = builder.build();
            OutputStreamWriter writer = new OutputStreamWriter(it2, Charsets.UTF_8);
            fileSpec.writeTo((Appendable)writer);
            writer.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final void addProp(FileSpec.Builder $this$addProp, ImmutableType type, ImmutableProp prop, boolean nonNullTable, boolean outerJoin) {
        if (prop.isTransient()) {
            return;
        }
        if (outerJoin && !prop.isAssociation()) {
            return;
        }
        if (nonNullTable && (prop.isAssociation() && outerJoin || !prop.isAssociation() && prop.isNullable())) {
            return;
        }
        TypeName[] typeNameArray = new TypeName[]{(TypeName)type.getClassName()};
        ParameterizedTypeName receiverClassName = ParameterizedTypeName.Companion.get(prop.isList() ? (outerJoin ? ConstantsKt.getK_TABLE_EX_CLASS_NAME() : (nonNullTable ? ConstantsKt.getK_NON_NULL_TABLE_EX_CLASS_NAME() : (prop.isAssociation() ? ConstantsKt.getK_NULLABLE_TABLE_EX_CLASS_NAME() : ConstantsKt.getK_TABLE_CLASS_NAME()))) : (outerJoin ? ConstantsKt.getK_TABLE_CLASS_NAME() : (nonNullTable ? ConstantsKt.getK_NON_NULL_TABLE_CLASS_NAME() : (prop.isAssociation() ? ConstantsKt.getK_NULLABLE_TABLE_CLASS_NAME() : ConstantsKt.getK_TABLE_CLASS_NAME()))), typeNameArray);
        String propName = outerJoin ? prop.getName() + '?' : prop.getName();
        String innerFunName = outerJoin ? "outerJoin" : (prop.isAssociation() ? "join" : "get");
        Object[] objectArray = new TypeName[]{(TypeName)ImmutableProp.targetTypeName$default(prop, false, false, 1, null)};
        ParameterizedTypeName returnClassName = ParameterizedTypeName.Companion.get(prop.isList() ? (nonNullTable ? ConstantsKt.getK_NON_NULL_TABLE_EX_CLASS_NAME() : ConstantsKt.getK_NULLABLE_TABLE_EX_CLASS_NAME()) : (prop.isAssociation() ? (nonNullTable ? ConstantsKt.getK_NON_NULL_TABLE_CLASS_NAME() : ConstantsKt.getK_NULLABLE_TABLE_CLASS_NAME()) : (nonNullTable ? ConstantsKt.getK_NON_NULL_PROP_EXPRESSION() : ConstantsKt.getK_NULLABLE_PROP_EXPRESSION())), (TypeName[])objectArray);
        objectArray = new Object[]{innerFunName, prop.getName()};
        $this$addProp.addProperty(PropertySpec.Companion.builder(propName, (TypeName)returnClassName, new KModifier[0]).receiver((TypeName)receiverClassName).getter(FunSpec.Companion.getterBuilder().addCode("return %L(%S)", objectArray).build()).build());
    }

    private final void addFetchByFun(FileSpec.Builder $this$addFetchByFun, ImmutableType type, boolean nullable) {
        Object[] objectArray = new TypeName[]{(TypeName)type.getClassName()};
        FunSpec.Builder builder = FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Companion.builder("fetchBy"), (TypeName)((TypeName)ParameterizedTypeName.Companion.get(nullable ? ConstantsKt.getK_NULLABLE_TABLE_CLASS_NAME() : ConstantsKt.getK_NON_NULL_TABLE_CLASS_NAME(), (TypeName[])objectArray)), null, (int)2, null).addParameter("block", (TypeName)LambdaTypeName.Companion.get((TypeName)type.getFetcherDslClassName(), CollectionsKt.emptyList(), (TypeName)TypeNames.UNIT), new KModifier[0]);
        objectArray = new TypeName[]{TypeName.copy$default((TypeName)((TypeName)type.getClassName()), (boolean)nullable, null, (int)2, null)};
        FunSpec.Builder builder2 = FunSpec.Builder.returns$default((FunSpec.Builder)builder, (TypeName)((TypeName)ParameterizedTypeName.Companion.get(ConstantsKt.getSELECTION_CLASS_NAME(), (TypeName[])objectArray)), null, (int)2, null);
        objectArray = new Object[]{ConstantsKt.getNEW_FETCHER_FUN_CLASS_NAME(), type.getClassName()};
        $this$addFetchByFun.addFunction(builder2.addCode("return fetch(%T(%T::class).by(block))", objectArray).build());
    }
}

