/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.dto.compiler.AbstractProp;
import org.babyfish.jimmer.dto.compiler.Anno;
import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoPropImpl;
import org.babyfish.jimmer.dto.compiler.DtoTypeModifier;
import org.babyfish.jimmer.dto.compiler.UserProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;
import org.jetbrains.annotations.Nullable;

public class DtoType<T extends BaseType, P extends BaseProp> {
    private final T baseType;
    private final String packageName;
    private final List<Anno> annotations;
    private final Set<DtoTypeModifier> modifiers;
    @Nullable
    private final String name;
    @Nullable
    private final String dtoFilePath;
    @Nullable
    private final String doc;
    private List<AbstractProp> props;
    private List<DtoProp<T, P>> dtoProps;
    private List<UserProp> userProps;
    private List<DtoProp<T, P>> hiddenFlatProps;

    DtoType(T baseType, @Nullable String packageName, List<Anno> annotations, Set<DtoTypeModifier> modifiers, @Nullable String name, @Nullable String dtoFilePath, @Nullable String doc) {
        this.baseType = baseType;
        this.packageName = packageName != null ? packageName : DtoType.defaultPackageName(baseType.getPackageName());
        this.annotations = annotations;
        this.modifiers = modifiers;
        this.name = name;
        this.dtoFilePath = dtoFilePath;
        this.doc = doc;
    }

    public T getBaseType() {
        return this.baseType;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Set<DtoTypeModifier> getModifiers() {
        return this.modifiers;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDtoFilePath() {
        return this.dtoFilePath;
    }

    public List<AbstractProp> getProps() {
        return this.props;
    }

    public List<DtoProp<T, P>> getDtoProps() {
        List<DtoProp<T, P>> list = this.dtoProps;
        if (list == null) {
            list = new ArrayList<DtoProp<T, P>>();
            for (AbstractProp prop : this.props) {
                if (!(prop instanceof DtoProp)) continue;
                list.add((DtoProp)prop);
            }
            this.dtoProps = list;
        }
        return list;
    }

    public List<UserProp> getUserProps() {
        List<UserProp> list = this.userProps;
        if (list == null) {
            list = new ArrayList<UserProp>();
            for (AbstractProp prop : this.props) {
                if (!(prop instanceof UserProp)) continue;
                list.add((UserProp)prop);
            }
            this.userProps = list;
        }
        return list;
    }

    public List<DtoProp<T, P>> getHiddenFlatProps() {
        List<DtoProp<T, P>> hfps = this.hiddenFlatProps;
        if (hfps == null) {
            FlatDtoBuilder<T, P> builder = new FlatDtoBuilder<T, P>(this.packageName, this.modifiers, null);
            for (DtoProp<T, P> prop : this.getDtoProps()) {
                if (prop.getNextProp() == null) continue;
                builder.add(prop);
            }
            this.hiddenFlatProps = hfps = builder.build().getDtoProps();
        }
        return hfps;
    }

    public List<Anno> getAnnotations() {
        return this.annotations;
    }

    public String getDoc() {
        return this.doc;
    }

    void setProps(List<AbstractProp> props) {
        if (props == null) {
            throw new IllegalArgumentException("`props` cannot be null");
        }
        if (this.props != null) {
            throw new IllegalArgumentException("`props` has already been set");
        }
        this.props = props;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.doc != null) {
            builder.append("@doc(").append(this.doc.replace("\n", "\\n")).append(')');
        }
        for (Anno anno : this.annotations) {
            builder.append(anno).append(' ');
        }
        for (DtoTypeModifier modifier : this.modifiers) {
            builder.append(modifier.name().toLowerCase()).append(' ');
        }
        if (this.name != null) {
            builder.append(this.name).append(' ');
        }
        builder.append('{');
        boolean addComma = false;
        for (AbstractProp prop : this.props) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            builder.append(prop);
        }
        builder.append('}');
        return builder.toString();
    }

    private static String defaultPackageName(String entityPackageName) {
        if (entityPackageName == null || entityPackageName.isEmpty()) {
            return "dto";
        }
        return entityPackageName + ".dto";
    }

    private class FlatDtoBuilder<T extends BaseType, P extends BaseProp> {
        private final String packageName;
        private final Set<DtoTypeModifier> modifiers;
        private final DtoProp<T, P> prop;
        private final Map<String, Object> childNodes = new LinkedHashMap<String, Object>();

        FlatDtoBuilder(String packageName, Set<DtoTypeModifier> modifiers, DtoProp<T, P> prop) {
            this.packageName = packageName;
            this.modifiers = modifiers;
            this.prop = prop;
        }

        public void add(DtoProp<T, P> prop) {
            String baseName = prop.getBaseProp().getName();
            if (prop.getNextProp() == null) {
                this.childNodes.put(baseName, prop);
            } else {
                FlatDtoBuilder<T, P> child = (FlatDtoBuilder<T, P>)this.childNodes.get(baseName);
                if (child == null) {
                    child = new FlatDtoBuilder<T, P>(this.packageName, this.modifiers, prop);
                    this.childNodes.put(baseName, child);
                }
                child.add(prop.getNextProp());
            }
        }

        public DtoType<T, P> build() {
            List<AbstractProp> props;
            if (this.childNodes.isEmpty()) {
                props = Collections.emptyList();
            } else {
                props = new ArrayList();
                for (Object child : this.childNodes.values()) {
                    if (child instanceof DtoProp) {
                        props.add((DtoProp)child);
                        continue;
                    }
                    FlatDtoBuilder builder = (FlatDtoBuilder)child;
                    DtoPropImpl<T, P> prop = new DtoPropImpl<T, P>(builder.prop, builder.build());
                    props.add(prop);
                }
                props = Collections.unmodifiableList(props);
            }
            DtoType dtoType = new DtoType(null, this.packageName, DtoType.this.annotations, this.modifiers, null, null, null);
            dtoType.setProps(props);
            return dtoType;
        }
    }
}

