/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;
import org.jetbrains.annotations.Nullable;

class RecursiveDtoProp<T extends BaseType, P extends BaseProp>
implements DtoProp<T, P> {
    private final P baseProp;
    private final String alias;
    private final DtoType<T, P> targetType;

    RecursiveDtoProp(P baseProp, String alias, DtoType<T, P> selfType) {
        this.baseProp = baseProp;
        this.alias = alias;
        this.targetType = selfType;
    }

    @Override
    public P getBaseProp() {
        return this.baseProp;
    }

    @Override
    public String getBasePath() {
        return this.baseProp.getName();
    }

    @Override
    public int getBaseLine() {
        return 0;
    }

    @Override
    public String getName() {
        return this.alias != null ? this.alias : this.baseProp.getName();
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isIdOnly() {
        return false;
    }

    @Override
    public boolean isFlat() {
        return false;
    }

    @Override
    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @Override
    public int getAliasLine() {
        return 0;
    }

    @Override
    @Nullable
    public String getFuncName() {
        return null;
    }

    @Override
    @Nullable
    public DtoType<T, P> getTargetType() {
        return this.targetType;
    }

    @Override
    public boolean isRecursive() {
        return true;
    }

    @Override
    public boolean isNewTarget() {
        return false;
    }

    @Override
    @Nullable
    public DtoProp<T, P> getNextProp() {
        return null;
    }

    @Override
    public DtoProp<T, P> toTailProp() {
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("@optional ").append(this.baseProp.getName());
        if (this.alias != null && !this.alias.equals(this.getBaseProp().getName())) {
            builder.append(" as ").append(this.alias);
        }
        builder.append(": ...");
        return builder.toString();
    }
}

