/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.Objects;
import org.babyfish.jimmer.dto.compiler.AbstractProp;
import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.UserProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;
import org.jetbrains.annotations.Nullable;

class DtoPropImpl<T extends BaseType, P extends BaseProp>
implements DtoProp<T, P> {
    private final P baseProp;
    @Nullable
    private final DtoProp<T, P> nextProp;
    private final int baseLine;
    @Nullable
    private final String alias;
    private final int aliasLine;
    private final DtoType<T, P> targetType;
    private final boolean optional;
    private final String funcName;
    private final boolean recursive;
    private final String basePath;
    private final DtoProp<T, P> tail;

    DtoPropImpl(P baseProp, int baseLine, @Nullable String alias, int aliasLine, @Nullable DtoType<T, P> targetType, boolean optional, String funcName, boolean recursive) {
        this.baseProp = baseProp;
        this.nextProp = null;
        this.baseLine = baseLine;
        this.alias = alias;
        this.aliasLine = aliasLine;
        this.targetType = targetType;
        this.optional = optional;
        this.funcName = funcName;
        this.recursive = recursive;
        this.basePath = baseProp.getName();
        this.tail = this;
    }

    DtoPropImpl(DtoProp<T, P> head, DtoProp<T, P> next) {
        this.baseProp = head.getBaseProp();
        this.nextProp = next;
        this.baseLine = next.getBaseLine();
        this.alias = next.getAlias();
        this.aliasLine = next.getAliasLine();
        this.targetType = next.getTargetType();
        this.optional = head.isNullable() || next.isNullable();
        this.funcName = next.getFuncName();
        this.recursive = false;
        StringBuilder builder = new StringBuilder(this.baseProp.getName());
        DtoProp<T, P> tail = this;
        for (DtoProp<T, P> n = next; n != null; n = n.getNextProp()) {
            builder.append('.').append(n.getBaseProp().getName());
            tail = n;
        }
        this.basePath = builder.toString();
        this.tail = tail;
    }

    DtoPropImpl(DtoProp<T, P> original, DtoType<T, P> targetType) {
        this.baseProp = original.getBaseProp();
        this.nextProp = null;
        this.baseLine = original.getBaseLine();
        this.alias = this.baseProp.getName();
        this.aliasLine = original.getAliasLine();
        this.targetType = targetType;
        this.optional = false;
        this.funcName = "flat";
        this.recursive = false;
        this.basePath = this.baseProp.getName();
        this.tail = this;
    }

    @Override
    public P getBaseProp() {
        return this.baseProp;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    @Nullable
    public DtoProp<T, P> getNextProp() {
        return this.nextProp;
    }

    @Override
    public DtoProp<T, P> toTailProp() {
        return this.tail;
    }

    @Override
    public int getBaseLine() {
        return this.baseLine;
    }

    @Override
    public String getName() {
        return this.alias != null ? this.alias : this.baseProp.getName();
    }

    @Override
    public int getAliasLine() {
        return this.aliasLine;
    }

    @Override
    public boolean isNullable() {
        return this.optional || this.baseProp.isNullable();
    }

    @Override
    public boolean isIdOnly() {
        return "id".equals(this.funcName);
    }

    @Override
    public boolean isFlat() {
        return "flat".equals(this.funcName);
    }

    @Override
    @Nullable
    public String getFuncName() {
        return this.funcName;
    }

    @Override
    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @Override
    @Nullable
    public DtoType<T, P> getTargetType() {
        return this.targetType;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public boolean isNewTarget() {
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.optional) {
            builder.append("@optional ");
        }
        if (this.funcName != null) {
            builder.append(this.funcName).append('(').append(this.basePath).append(')');
        } else {
            builder.append(this.basePath);
        }
        if (this.alias != null && !this.alias.equals(this.tail.getBaseProp().getName())) {
            builder.append(" as ").append(this.alias);
        }
        if (this.targetType != null) {
            builder.append(": ");
            builder.append(this.targetType);
        }
        if (this.recursive) {
            builder.append('*');
        }
        return builder.toString();
    }

    static boolean canMerge(AbstractProp p1, AbstractProp p2) {
        if (p1 instanceof DtoProp && p2 instanceof DtoProp) {
            return DtoPropImpl.canMergeDtoProp((DtoProp)p1, (DtoProp)p2);
        }
        if (p1 instanceof UserProp && p2 instanceof UserProp) {
            return DtoPropImpl.canMergeUerProp((UserProp)p1, (UserProp)p2);
        }
        return false;
    }

    private static boolean canMergeDtoProp(DtoProp<?, ?> p1, DtoProp<?, ?> p2) {
        if (p1.isNullable() != p2.isNullable()) {
            return false;
        }
        if (!p1.getBasePath().equals(p2.getBaseProp())) {
            return false;
        }
        if (!Objects.equals(p1.getFuncName(), p2.getFuncName())) {
            return false;
        }
        return p1.getTargetType() == null;
    }

    private static boolean canMergeUerProp(UserProp p1, UserProp p2) {
        return p1.equals(p2);
    }
}

