/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.Token;
import org.babyfish.jimmer.dto.compiler.DtoAstException;
import org.babyfish.jimmer.dto.compiler.DtoCompiler;
import org.babyfish.jimmer.dto.compiler.DtoParser;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.DtoTypeBuilder;
import org.babyfish.jimmer.dto.compiler.DtoTypeModifier;
import org.babyfish.jimmer.dto.compiler.Importing;
import org.babyfish.jimmer.dto.compiler.TypeRef;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;

class CompilerContext<T extends BaseType, P extends BaseProp> {
    private final DtoCompiler<T, P> compiler;
    private final Importing importing;
    private final boolean hasKey;
    private final Map<String, DtoTypeBuilder<T, P>> typeBuilderMap = new LinkedHashMap<String, DtoTypeBuilder<T, P>>();

    public CompilerContext(DtoCompiler<T, P> compiler) {
        this.compiler = compiler;
        this.importing = new Importing(this);
        boolean hasKey = false;
        for (BaseProp baseProp : compiler.getProps(compiler.getBaseType()).values()) {
            if (!baseProp.isKey()) continue;
            hasKey = true;
            break;
        }
        this.hasKey = hasKey;
    }

    public DtoTypeBuilder<T, P> get(String name) {
        return this.typeBuilderMap.get(name);
    }

    public void importStatement(DtoParser.ImportStatementContext statement) {
        this.importing.add(statement);
    }

    public DtoTypeBuilder<T, P> add(DtoParser.DtoTypeContext type) {
        String name = type.name.getText();
        if (this.typeBuilderMap.containsKey(name)) {
            throw this.exception(type.name.getLine(), "Duplicated dto type name \"" + name + "\"");
        }
        EnumSet<DtoTypeModifier> modifiers = EnumSet.noneOf(DtoTypeModifier.class);
        for (Token token : type.modifiers) {
            DtoTypeModifier dtoTypeModifier;
            switch (token.getText()) {
                case "input": {
                    dtoTypeModifier = DtoTypeModifier.INPUT;
                    break;
                }
                case "abstract": {
                    dtoTypeModifier = DtoTypeModifier.ABSTRACT;
                    break;
                }
                default: {
                    throw this.exception(token.getLine(), "If the modifier of dto type is specified, it must be 'input' or 'abstract'");
                }
            }
            if (modifiers.add(dtoTypeModifier)) continue;
            throw this.exception(token.getLine(), "Duplicated modifier \"" + token.getText() + "\"");
        }
        LinkedHashSet<String> superSet = new LinkedHashSet<String>();
        for (Token superName : type.superNames) {
            if (superSet.add(superName.getText())) continue;
            throw this.exception(superName.getLine(), "Duplicated super dto name \"" + superName.getText() + "\"");
        }
        DtoTypeBuilder<T, Object> dtoTypeBuilder = new DtoTypeBuilder<T, Object>(this.compiler.getBaseType(), type.body, type.name, modifiers, type.superNames, null, null, this);
        this.typeBuilderMap.put(name, dtoTypeBuilder);
        return dtoTypeBuilder;
    }

    public List<DtoType<T, P>> getDtoTypes() {
        ArrayList<DtoType<T, P>> types = new ArrayList<DtoType<T, P>>(this.typeBuilderMap.size());
        for (DtoTypeBuilder<T, P> builder : this.typeBuilderMap.values()) {
            DtoType<T, P> type = builder.build();
            if (builder.isAbstract()) continue;
            types.add(type);
        }
        return types;
    }

    public Map<String, P> getProps(T baseType) {
        return this.compiler.getProps(baseType);
    }

    public Map<String, P> getDeclaredProps(T baseType) {
        return this.compiler.getDeclaredProps(baseType);
    }

    public boolean isImplicit(P baseProp) {
        return baseProp.isId() && this.hasKey;
    }

    public T getTargetType(P baseProp) {
        return this.compiler.getTargetType(baseProp);
    }

    public String getDtoFilePath() {
        return this.compiler.getDtoFilePath();
    }

    public T getBaseType() {
        return this.compiler.getBaseType();
    }

    public TypeRef resolve(DtoParser.TypeRefContext ctx) {
        return this.importing.resolve(ctx);
    }

    public String resolve(DtoParser.QualifiedNameContext ctx) {
        return this.importing.resolve(ctx);
    }

    public String resolve(String qualifiedName, int qualifiedNameLine) {
        return this.importing.resolve(qualifiedName, qualifiedNameLine);
    }

    public DtoAstException exception(int line, String message) {
        return this.compiler.exception(line, message);
    }
}

