/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.babyfish.jimmer.dto.compiler.OsFile;

public final class DtoFile {
    private final OsFile osFile;
    private final String projectDir;
    private final String dtoDir;
    private final String packageName;
    private final String name;
    private final String path;

    public DtoFile(OsFile osFile, String projectDir, String dtoDir, List<String> packagePaths, String name) {
        this.osFile = osFile;
        this.projectDir = projectDir;
        this.dtoDir = dtoDir;
        this.packageName = String.join((CharSequence)".", packagePaths);
        this.name = name;
        this.path = '<' + projectDir + '>' + '/' + dtoDir + (packagePaths.isEmpty() ? "" : '/' + String.join((CharSequence)"/", packagePaths)) + '/' + name;
    }

    public OsFile getOsFile() {
        return this.osFile;
    }

    public String getAbsolutePath() {
        return this.osFile.getAbsolutePath();
    }

    public Reader openReader() throws IOException {
        return this.osFile.openReader();
    }

    public String getProjectDir() {
        return this.projectDir;
    }

    public String getDtoDir() {
        return this.dtoDir;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DtoFile dtoFile = (DtoFile)o;
        return this.path.equals(dtoFile.path);
    }

    public String toString() {
        return this.path;
    }
}

