/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class TypeRef {
    public static final String TN_BOOLEAN = "Boolean";
    public static final String TN_CHAR = "Char";
    public static final String TN_BYTE = "Byte";
    public static final String TN_SHORT = "Short";
    public static final String TN_INT = "Int";
    public static final String TN_LONG = "Long";
    public static final String TN_FLOAT = "Float";
    public static final String TN_DOUBLE = "Double";
    public static final String TN_ANY = "Any";
    public static final String TN_STRING = "String";
    public static final String TN_ARRAY = "Array";
    public static final String TN_ITERABLE = "Iterable";
    public static final String TN_MUTABLE_ITERABLE = "MutableIterable";
    public static final String TN_COLLECTION = "Collection";
    public static final String TN_MUTABLE_COLLECTION = "MutableCollection";
    public static final String TN_LIST = "List";
    public static final String TN_MUTABLE_LIST = "MutableList";
    public static final String TN_SET = "Set";
    public static final String TN_MUTABLE_SET = "MutableSet";
    public static final String TN_MAP = "Map";
    public static final String TN_MUTABLE_MAP = "MutableMap";
    public static final Set<String> TNS_WITH_DEFAULT_VALUE;
    private final String typeName;
    private final List<Argument> arguments;
    private final boolean isNullable;

    public TypeRef(String typeName, List<Argument> arguments, boolean isNullable) {
        this.typeName = typeName;
        this.arguments = arguments != null && !arguments.isEmpty() ? Collections.unmodifiableList(arguments) : Collections.emptyList();
        this.isNullable = isNullable;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeRef typeRef = (TypeRef)o;
        return this.isNullable == typeRef.isNullable && Objects.equals(this.typeName, typeRef.typeName) && Objects.equals(this.arguments, typeRef.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.arguments, this.isNullable);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.typeName);
        if (!this.arguments.isEmpty()) {
            builder.append('<');
            boolean addComma = false;
            for (Argument argument : this.arguments) {
                if (addComma) {
                    builder.append(", ");
                } else {
                    addComma = true;
                }
                builder.append(argument);
            }
            builder.append('>');
        }
        if (this.isNullable) {
            builder.append("?");
        }
        return builder.toString();
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(TN_BOOLEAN);
        set.add(TN_CHAR);
        set.add(TN_BYTE);
        set.add(TN_SHORT);
        set.add(TN_INT);
        set.add(TN_LONG);
        set.add(TN_FLOAT);
        set.add(TN_DOUBLE);
        set.add(TN_ANY);
        set.add(TN_STRING);
        set.add(TN_ARRAY);
        set.add(TN_ITERABLE);
        set.add(TN_MUTABLE_ITERABLE);
        set.add(TN_COLLECTION);
        set.add(TN_MUTABLE_COLLECTION);
        set.add(TN_LIST);
        set.add(TN_MUTABLE_LIST);
        set.add(TN_SET);
        set.add(TN_MUTABLE_SET);
        set.add(TN_MAP);
        set.add(TN_MUTABLE_MAP);
        TNS_WITH_DEFAULT_VALUE = Collections.unmodifiableSet(set);
    }

    public static class Argument {
        private final TypeRef typeRef;
        private final boolean in;
        private final boolean out;

        public Argument(TypeRef typeRef, boolean in, boolean out) {
            this.typeRef = typeRef;
            this.in = in;
            this.out = out;
        }

        @Nullable
        public TypeRef getTypeRef() {
            return this.typeRef;
        }

        public boolean isIn() {
            return this.in;
        }

        public boolean isOut() {
            return this.out;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Argument argument = (Argument)o;
            return this.in == argument.in && this.out == argument.out && Objects.equals(this.typeRef, argument.typeRef);
        }

        public int hashCode() {
            return Objects.hash(this.typeRef, this.in, this.out);
        }

        public String toString() {
            String typeString;
            String string = typeString = this.typeRef != null ? this.typeRef.toString() : "*";
            if (this.in) {
                return "in " + typeString;
            }
            if (this.out) {
                return "out " + typeString;
            }
            return typeString;
        }
    }
}

