/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.Token;
import org.babyfish.jimmer.dto.compiler.DtoAstException;
import org.babyfish.jimmer.dto.compiler.DtoCompiler;
import org.babyfish.jimmer.dto.compiler.DtoParser;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.DtoTypeBuilder;
import org.babyfish.jimmer.dto.compiler.DtoTypeModifier;
import org.babyfish.jimmer.dto.compiler.Importing;
import org.babyfish.jimmer.dto.compiler.TypeRef;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;

class CompilerContext<T extends BaseType, P extends BaseProp> {
    private final DtoCompiler<T, P> compiler;
    private final Importing importing;
    private final Map<String, DtoTypeBuilder<T, P>> typeBuilderMap = new LinkedHashMap<String, DtoTypeBuilder<T, P>>();

    public CompilerContext(DtoCompiler<T, P> compiler) {
        this.compiler = compiler;
        this.importing = new Importing(this);
    }

    public DtoTypeBuilder<T, P> get(String name) {
        return this.typeBuilderMap.get(name);
    }

    public void importStatement(DtoParser.ImportStatementContext statement) {
        this.importing.add(statement);
    }

    public DtoTypeBuilder<T, P> add(DtoParser.DtoTypeContext type) {
        String name = type.name.getText();
        if (this.typeBuilderMap.containsKey(name)) {
            throw this.exception(type.name.getLine(), "Duplicated dto type name \"" + name + "\"");
        }
        EnumSet<DtoTypeModifier> modifiers = EnumSet.noneOf(DtoTypeModifier.class);
        for (Token modifier : type.modifiers) {
            DtoTypeModifier dtoTypeModifier;
            switch (modifier.getText()) {
                case "input": {
                    dtoTypeModifier = DtoTypeModifier.INPUT;
                    break;
                }
                case "specification": {
                    dtoTypeModifier = DtoTypeModifier.SPECIFICATION;
                    break;
                }
                case "abstract": {
                    dtoTypeModifier = DtoTypeModifier.ABSTRACT;
                    break;
                }
                case "unsafe": {
                    dtoTypeModifier = DtoTypeModifier.UNSAFE;
                    break;
                }
                case "dynamic": {
                    dtoTypeModifier = DtoTypeModifier.DYNAMIC;
                    break;
                }
                default: {
                    throw this.exception(modifier.getLine(), "If the modifier of dto type is specified, it must be 'input', 'specification', 'abstract', 'unsafe' or 'dynamic'");
                }
            }
            if (modifiers.add(dtoTypeModifier)) continue;
            throw this.exception(modifier.getLine(), "Duplicated modifier \"" + modifier.getText() + "\"");
        }
        if (modifiers.contains((Object)DtoTypeModifier.INPUT) && modifiers.contains((Object)DtoTypeModifier.SPECIFICATION)) {
            throw this.exception(type.name.getLine(), "If modifiers 'input' and 'specification' cannot appear at the same time");
        }
        if (modifiers.contains((Object)DtoTypeModifier.UNSAFE) && !modifiers.contains((Object)DtoTypeModifier.INPUT)) {
            throw this.exception(type.name.getLine(), "If modifiers 'unsafe' can only be used for input");
        }
        if (modifiers.contains((Object)DtoTypeModifier.DYNAMIC) && !modifiers.contains((Object)DtoTypeModifier.INPUT)) {
            throw this.exception(type.name.getLine(), "If modifiers 'dynamic' can only be used for input");
        }
        LinkedHashSet superSet = new LinkedHashSet();
        DtoTypeBuilder<T, Object> typeBuilder = new DtoTypeBuilder<T, Object>(null, this.compiler.getBaseType(), type.body, type.name, type.annotations, modifiers, null, null, this);
        this.typeBuilderMap.put(name, typeBuilder);
        return typeBuilder;
    }

    public List<DtoType<T, P>> getDtoTypes() {
        ArrayList<DtoType<T, P>> types = new ArrayList<DtoType<T, P>>(this.typeBuilderMap.size());
        for (DtoTypeBuilder<T, P> builder : this.typeBuilderMap.values()) {
            DtoType<T, P> type = builder.build();
            if (builder.isAbstract()) continue;
            types.add(type);
        }
        return types;
    }

    public Map<String, P> getProps(T baseType) {
        return this.compiler.getProps(baseType);
    }

    public Map<String, P> getDeclaredProps(T baseType) {
        return this.compiler.getDeclaredProps(baseType);
    }

    public boolean isImplicitId(P baseProp, Set<DtoTypeModifier> modifiers) {
        if (modifiers.contains((Object)DtoTypeModifier.INPUT) || modifiers.contains((Object)DtoTypeModifier.SPECIFICATION)) {
            return baseProp.isId() && this.compiler.isGeneratedValue(baseProp);
        }
        return false;
    }

    public T getTargetType(P baseProp) {
        return this.compiler.getTargetType(baseProp);
    }

    public boolean isSameType(P baseProp1, P baseProp2) {
        return this.compiler.isSameType(baseProp1, baseProp2);
    }

    public boolean isStringProp(P baseProp) {
        return this.compiler.isStringProp(baseProp);
    }

    public String getDtoFilePath() {
        return this.compiler.getDtoFilePath();
    }

    public String getTargetPackageName() {
        return this.compiler.getTargetPackageName();
    }

    public T getBaseType() {
        return this.compiler.getBaseType();
    }

    public Collection<T> getSuperTypes(T baseType) {
        return this.compiler.getSuperTypes(baseType);
    }

    public List<String> getEnumConstants(P baseProp) {
        return this.compiler.getEnumConstants(baseProp);
    }

    public TypeRef resolve(DtoParser.TypeRefContext ctx) {
        return this.importing.resolve(ctx);
    }

    public String resolve(DtoParser.QualifiedNameContext ctx) {
        return this.importing.resolve(ctx);
    }

    public String resolve(String qualifiedName, int qualifiedNameLine) {
        return this.importing.resolve(qualifiedName, qualifiedNameLine);
    }

    public DtoAstException exception(int line, String message) {
        return this.compiler.exception(line, message);
    }
}

