/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public final class DtoFile {
    private final String dtoDir;
    private final String packageName;
    private final String path;
    private final File file;

    public DtoFile(String dtoDir, List<String> paths, File file) {
        this.dtoDir = dtoDir;
        this.packageName = paths.stream().collect(Collectors.joining("."));
        this.path = dtoDir + (paths.isEmpty() ? "" : '/' + paths.stream().collect(Collectors.joining("/"))) + '/' + file.getName();
        this.file = file;
    }

    public String getDtoDir() {
        return this.dtoDir;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DtoFile dtoFile = (DtoFile)o;
        return this.path.equals(dtoFile.path);
    }

    public String toString() {
        return this.path;
    }
}

