/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.babyfish.jimmer.dto.compiler.CompilerContext;
import org.babyfish.jimmer.dto.compiler.DtoAstException;
import org.babyfish.jimmer.dto.compiler.DtoFile;
import org.babyfish.jimmer.dto.compiler.DtoLexer;
import org.babyfish.jimmer.dto.compiler.DtoParser;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;

public abstract class DtoCompiler<T extends BaseType, P extends BaseProp> {
    private final String dtoFilePath;
    private T baseType;
    private DtoParser.DtoContext ast;
    private String sourceTypeName;
    private String targetPackageName;

    protected DtoCompiler(T baseType, String dtoFilePath) {
        this.baseType = baseType;
        this.dtoFilePath = dtoFilePath;
    }

    protected DtoCompiler(DtoFile dtoFile) throws IOException {
        this.dtoFilePath = dtoFile.getPath();
        try (FileReader reader = new FileReader(dtoFile.getFile());){
            DtoLexer lexer = new DtoLexer((CharStream)new ANTLRInputStream((Reader)reader));
            DtoParser parser = new DtoParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            DtoErrorListener listener = new DtoErrorListener();
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)listener);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)listener);
            this.ast = parser.dto();
            DtoParser.ExportStatementContext export = this.ast.exportStatement();
            String sourceTypeName = null;
            String targetPackageName = null;
            if (export != null) {
                int lastIndex;
                List<Token> typeParts = export.typeParts;
                sourceTypeName = typeParts.size() == 1 ? dtoFile.getPackageName() + '.' + typeParts.get(0).getText() : typeParts.stream().map(Token::getText).collect(Collectors.joining("."));
                List<Token> packageParts = export.packageParts;
                targetPackageName = packageParts.isEmpty() ? ((lastIndex = sourceTypeName.lastIndexOf(46)) != -1 ? sourceTypeName.substring(0, lastIndex) + ".dto" : "") : packageParts.stream().map(Token::getText).collect(Collectors.joining("."));
            }
            if (sourceTypeName == null) {
                String name = dtoFile.getFile().getName();
                sourceTypeName = dtoFile.getPackageName() + '.' + name.substring(0, name.length() - 4);
            }
            this.sourceTypeName = sourceTypeName;
            this.targetPackageName = targetPackageName;
        }
    }

    public T getBaseType() {
        return this.baseType;
    }

    public String getDtoFilePath() {
        return this.dtoFilePath;
    }

    public String getSourceTypeName() {
        return this.sourceTypeName;
    }

    public String getTargetPackageName() {
        return this.targetPackageName;
    }

    public List<DtoType<T, P>> compile(T baseType) {
        this.baseType = baseType;
        CompilerContext ctx = new CompilerContext(this);
        for (DtoParser.ImportStatementContext importStatement : this.ast.importStatements) {
            ctx.importStatement(importStatement);
        }
        for (DtoParser.DtoTypeContext dtoType : this.ast.dtoTypes) {
            ctx.add(dtoType);
        }
        return ctx.getDtoTypes();
    }

    public List<DtoType<T, P>> compile(String code) {
        DtoLexer lexer = new DtoLexer((CharStream)new ANTLRInputStream(code));
        DtoParser parser = new DtoParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        DtoErrorListener listener = new DtoErrorListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        return this.parse(parser);
    }

    public List<DtoType<T, P>> compile(Reader reader) throws IOException {
        DtoLexer lexer = new DtoLexer((CharStream)new ANTLRInputStream(reader));
        DtoParser parser = new DtoParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        DtoErrorListener listener = new DtoErrorListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        return this.parse(parser);
    }

    public List<DtoType<T, P>> compile(InputStream input) throws IOException {
        DtoLexer lexer = new DtoLexer((CharStream)new ANTLRInputStream(input));
        DtoParser parser = new DtoParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        DtoErrorListener listener = new DtoErrorListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        return this.parse(parser);
    }

    private List<DtoType<T, P>> parse(DtoParser parser) {
        CompilerContext ctx = new CompilerContext(this);
        DtoParser.DtoContext dto = parser.dto();
        for (DtoParser.ImportStatementContext importStatement : dto.importStatements) {
            ctx.importStatement(importStatement);
        }
        for (DtoParser.DtoTypeContext dtoType : dto.dtoTypes) {
            ctx.add(dtoType);
        }
        return ctx.getDtoTypes();
    }

    protected abstract Collection<T> getSuperTypes(T var1);

    protected abstract Map<String, P> getDeclaredProps(T var1);

    protected abstract Map<String, P> getProps(T var1);

    protected abstract T getTargetType(P var1);

    protected abstract boolean isGeneratedValue(P var1);

    protected abstract List<String> getEnumConstants(P var1);

    protected abstract boolean isStringProp(P var1);

    protected abstract boolean isSameType(P var1, P var2);

    DtoAstException exception(int line, String message) {
        return new DtoAstException(this.dtoFilePath, line, message);
    }

    private class DtoErrorListener
    extends BaseErrorListener {
        private DtoErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
            throw DtoCompiler.this.exception(line, msg);
        }
    }
}

