/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.Token;
import org.babyfish.jimmer.dto.compiler.AbstractPropBuilder;
import org.babyfish.jimmer.dto.compiler.Anno;
import org.babyfish.jimmer.dto.compiler.AnnoParser;
import org.babyfish.jimmer.dto.compiler.CompilerContext;
import org.babyfish.jimmer.dto.compiler.DtoParser;
import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoPropImpl;
import org.babyfish.jimmer.dto.compiler.DtoPropImplementor;
import org.babyfish.jimmer.dto.compiler.DtoTypeBuilder;
import org.babyfish.jimmer.dto.compiler.DtoTypeModifier;
import org.babyfish.jimmer.dto.compiler.EnumType;
import org.babyfish.jimmer.dto.compiler.Mandatory;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DtoPropBuilder<T extends BaseType, P extends BaseProp>
implements DtoPropImplementor,
AbstractPropBuilder {
    private final DtoTypeBuilder<T, P> parent;
    @NotNull
    private final P baseProp;
    private final int baseLine;
    private final String alias;
    private final int aliasLine;
    private final List<Anno> annotations;
    private final Mandatory mandatory;
    private final String funcName;
    private final DtoTypeBuilder<T, P> targetTypeBuilder;
    private final EnumType enumType;
    private final boolean recursive;

    DtoPropBuilder(DtoTypeBuilder<T, P> parent, P baseProp, int line, Mandatory mandatory) {
        this.parent = Objects.requireNonNull(parent, "parent cannot be null");
        this.baseProp = (BaseProp)Objects.requireNonNull(baseProp, "baseProp cannot be null");
        this.aliasLine = line;
        this.alias = parent.currentAliasGroup() != null ? parent.currentAliasGroup().alias(baseProp.getName(), 0) : baseProp.getName();
        this.baseLine = line;
        this.annotations = Collections.emptyList();
        this.mandatory = mandatory == Mandatory.DEFAULT && parent.ctx.isImplicitId(baseProp, parent.modifiers) ? Mandatory.OPTIONAL : mandatory;
        this.funcName = null;
        this.targetTypeBuilder = null;
        this.enumType = null;
        this.recursive = false;
    }

    DtoPropBuilder(DtoTypeBuilder<T, P> parent, DtoParser.PositivePropContext prop) {
        String alias;
        List annotations;
        this.parent = Objects.requireNonNull(parent, "parent cannot be null");
        this.baseLine = prop.prop.getLine();
        int n = this.aliasLine = prop.alias != null ? prop.alias.getLine() : prop.prop.getLine();
        if (prop.annotations.isEmpty()) {
            annotations = Collections.emptyList();
        } else {
            AnnoParser parser = new AnnoParser(parent.ctx);
            annotations = new ArrayList(prop.annotations.size());
            for (DtoParser.AnnotationContext anno : prop.annotations) {
                annotations.add(parser.parse(anno));
            }
            annotations = Collections.unmodifiableList(annotations);
        }
        this.annotations = annotations;
        CompilerContext ctx = parent.ctx;
        P baseProp = DtoPropBuilder.getBaseProp(parent, prop.prop);
        this.baseProp = baseProp;
        String funcName = null;
        if (prop.func != null) {
            if (parent.currentAliasGroup() != null) {
                throw ctx.exception(prop.func.getLine(), "Function invocation is forbidden in alias group");
            }
            switch (funcName = prop.func.getText()) {
                case "id": {
                    if (!baseProp.isAssociation(true)) {
                        throw ctx.exception(prop.func.getLine(), "Cannot call the function \"id\" because the current prop \"" + baseProp + "\" is not entity level association property");
                    }
                    funcName = "id";
                    break;
                }
                case "flat": {
                    if (!baseProp.isAssociation(false)) {
                        throw ctx.exception(prop.func.getLine(), "Cannot call the function \"flat\" because the current prop \"" + baseProp + "\" is not association");
                    }
                    if (!baseProp.isList()) break;
                    throw ctx.exception(prop.func.getLine(), "Cannot call the function \"flat\" because the current prop \"" + baseProp + "\" is list");
                }
                default: {
                    throw ctx.exception(prop.func.getLine(), "The function name must be \"id\" or \"flat\"");
                }
            }
        }
        this.funcName = funcName;
        if (prop.alias != null) {
            if (parent.currentAliasGroup() != null) {
                throw ctx.exception(prop.alias.getLine(), "The alias cannot be specified in alias group");
            }
            if ("flat".equals(funcName)) {
                throw ctx.exception(prop.alias.getLine(), "The alias cannot be specified when the function `flat` is used");
            }
            alias = prop.alias.getText();
        } else if (parent.currentAliasGroup() != null) {
            alias = parent.currentAliasGroup().alias(prop.prop);
        } else if ("id".equals(funcName)) {
            if (baseProp.getName().equals("s")) {
                throw ctx.exception(prop.prop.getLine(), "The alias must be specified for the property with `id` function when the base property name ends with 's'");
            }
            alias = baseProp.getName() + "Id";
        } else {
            alias = "flat".equals(funcName) ? null : baseProp.getName();
        }
        if (prop.optional != null) {
            if ("flat".equals(funcName)) {
                throw ctx.exception(prop.optional.getLine(), "Illegal optional modifier '?', it is not allowed for the function `flat`");
            }
            if (baseProp.isNullable()) {
                throw ctx.exception(prop.optional.getLine(), "Illegal optional modifier '?' because the base property is already nullable");
            }
            DtoPropBuilder<T, P> nullableFlatParent = this.getNullableFlatParent();
            if (nullableFlatParent != null) {
                throw ctx.exception(prop.optional.getLine(), "Illegal optional modifier '?' because the flat parent property \"" + nullableFlatParent.baseProp + "\" is already nullable");
            }
        }
        if (prop.required != null) {
            if ("flat".equals(funcName)) {
                throw ctx.exception(prop.required.getLine(), "Illegal required modifier '!', it is not allowed for the function `flat`");
            }
            if (baseProp.isId()) {
                if (!parent.modifiers.contains((Object)DtoTypeModifier.INPUT) && !parent.modifiers.contains((Object)DtoTypeModifier.INPUT_ONLY)) {
                    throw ctx.exception(prop.required.getLine(), "Illegal required modifier '!' for id property, it can only be used in input/input-only type");
                }
            } else {
                if (!parent.modifiers.contains((Object)DtoTypeModifier.INPUT_ONLY)) {
                    throw ctx.exception(prop.required.getLine(), "Illegal required modifier '!' for non-id property, it can only be used in input-only type");
                }
                if (!baseProp.isNullable() && this.getNullableFlatParent() == null) {
                    throw ctx.exception(prop.required.getLine(), "Illegal required modifier '!' because the base property is already nonnull");
                }
            }
        }
        if (prop.recursive != null) {
            if (!baseProp.isRecursive()) {
                throw ctx.exception(prop.recursive.getLine(), "Illegal symbol \"" + prop.recursive.getText() + "\", the property \"" + baseProp.getName() + "\" is not recursive");
            }
            if ("flat".equals(funcName)) {
                throw ctx.exception(prop.recursive.getLine(), "Illegal symbol \"" + prop.recursive.getText() + "\", the flat property \"" + baseProp.getName() + "\" cannot not recursive");
            }
            if (prop.required != null) {
                throw ctx.exception(prop.recursive.getLine(), "Illegal symbol \"" + prop.recursive.getText() + "\", the required property \"" + baseProp.getName() + "\" cannot not recursive");
            }
        }
        DtoTypeBuilder targetTypeBuilder = null;
        DtoParser.DtoBodyContext dtoBody = prop.dtoBody();
        if (dtoBody != null) {
            if (!baseProp.isAssociation(false)) {
                throw ctx.exception(dtoBody.start.getLine(), "Illegal property \"" + baseProp.getName() + "\", child body cannot be specified by it is not association");
            }
            if ("id".equals(funcName)) {
                throw ctx.exception(dtoBody.start.getLine(), "Illegal property \"" + baseProp.getName() + "\", child body cannot be specified by it is id view property");
            }
            targetTypeBuilder = new DtoTypeBuilder(this, ctx.getTargetType(baseProp), dtoBody, null, prop.annotations, parent.modifiers.contains((Object)DtoTypeModifier.INPUT) ? Collections.singleton(DtoTypeModifier.INPUT) : (parent.modifiers.contains((Object)DtoTypeModifier.INPUT_ONLY) ? Collections.singleton(DtoTypeModifier.INPUT_ONLY) : Collections.emptySet()), Collections.emptyList(), prop.recursive != null ? baseProp : null, prop.recursive != null ? alias : null, ctx);
        } else if (baseProp.isAssociation(false) && !"id".equals(funcName)) {
            throw ctx.exception(prop.stop.getLine(), "Illegal property \"" + baseProp.getName() + "\", the child body is required");
        }
        DtoParser.EnumBodyContext enumBody = prop.enumBody();
        if (enumBody != null) {
            List<String> constants = ctx.getEnumConstants(baseProp);
            if (constants == null || constants.isEmpty()) {
                throw ctx.exception(enumBody.start.getLine(), "Illegal property \"" + baseProp.getName() + "\", enum body cannot be specified by it is not enum property");
            }
            this.enumType = EnumType.of(ctx, constants, enumBody);
        } else {
            this.enumType = null;
        }
        this.alias = alias;
        this.mandatory = prop.required != null ? Mandatory.REQUIRED : (prop.optional != null || prop.recursive != null || ctx.isImplicitId(baseProp, parent.modifiers) ? Mandatory.OPTIONAL : Mandatory.DEFAULT);
        this.targetTypeBuilder = targetTypeBuilder;
        this.recursive = prop.recursive != null;
    }

    public DtoTypeBuilder<T, P> getParent() {
        return this.parent;
    }

    public P getBaseProp() {
        return this.baseProp;
    }

    @Override
    public int getBaseLine() {
        return this.baseLine;
    }

    @Override
    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @Override
    public int getAliasLine() {
        return this.aliasLine;
    }

    @Override
    @Nullable
    public String getFuncName() {
        return this.funcName;
    }

    @Override
    public Mandatory getMandatory() {
        return this.mandatory;
    }

    @Override
    public List<Anno> getAnnotations() {
        return this.annotations;
    }

    public DtoTypeBuilder<T, P> getTargetBuilder() {
        return this.targetTypeBuilder;
    }

    private static <T extends BaseType, P extends BaseProp> P getBaseProp(DtoTypeBuilder<T, P> parent, Token token) {
        Object baseType = parent.baseType;
        Object recursiveBaseProp = parent.recursiveBaseProp;
        CompilerContext ctx = parent.ctx;
        if (recursiveBaseProp != null && token.getText().equals(recursiveBaseProp.getName())) {
            throw ctx.exception(token.getLine(), "The property \"" + token.getText() + "\" cannot be specified because it is implicit recursive association");
        }
        String baseName = token.getText();
        BaseProp baseProp = (BaseProp)ctx.getProps(baseType).get(baseName);
        if (baseProp == null) {
            throw ctx.exception(token.getLine(), "There is no property \"" + baseName + "\" in \"" + baseType.getQualifiedName() + "\" or its super types");
        }
        boolean isInput = parent.modifiers.contains((Object)DtoTypeModifier.INPUT);
        if (baseProp.isFormula() && isInput) {
            throw ctx.exception(token.getLine(), "The property \"" + baseProp.getName() + "\" cannot be declared in input dto because it is formula");
        }
        if (baseProp.getManyToManyViewBaseProp() != null && isInput) {
            throw ctx.exception(token.getLine(), "The property \"" + baseProp.getName() + "\" cannot be declared in input dto because it is many-to-many-view");
        }
        if (baseProp.isTransient()) {
            if (isInput) {
                throw ctx.exception(token.getLine(), "The property \"" + baseProp.getName() + "\" cannot be declared in input dto because it is transient");
            }
            if (!baseProp.hasTransientResolver()) {
                throw ctx.exception(token.getLine(), "The property \"" + baseProp.getName() + "\" cannot be declared in dto because it is transient but has no transient resolver");
            }
        }
        return (P)baseProp;
    }

    private DtoPropBuilder<T, P> getNullableFlatParent() {
        DtoPropBuilder parentProp = this.parent.parentProp;
        while (parentProp != null) {
            if (parentProp.getBaseProp().isNullable() && "flat".equals(parentProp.funcName)) {
                return parentProp;
            }
            parentProp = parentProp.parent.parentProp;
        }
        return null;
    }

    @Override
    public DtoProp<T, P> build() {
        return new DtoPropImpl<T, P>(this.baseProp, this.baseLine, this.alias, this.aliasLine, this.annotations, this.targetTypeBuilder != null ? this.targetTypeBuilder.build() : null, this.enumType, this.mandatory, this.funcName, this.recursive);
    }
}

