/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.babyfish.jimmer.dto.compiler.CompilerContext;
import org.babyfish.jimmer.dto.compiler.DtoAstException;
import org.babyfish.jimmer.dto.compiler.DtoFile;
import org.babyfish.jimmer.dto.compiler.DtoLexer;
import org.babyfish.jimmer.dto.compiler.DtoModifier;
import org.babyfish.jimmer.dto.compiler.DtoParser;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;

public abstract class DtoCompiler<T extends BaseType, P extends BaseProp> {
    private final DtoFile dtoFile;
    private T baseType;
    private final DtoParser.DtoContext ast;
    private final String sourceTypeName;
    private final String targetPackageName;

    protected DtoCompiler(DtoFile dtoFile) throws IOException {
        this.dtoFile = dtoFile;
        try (Reader reader = dtoFile.openReader();){
            DtoLexer lexer = new DtoLexer((CharStream)new ANTLRInputStream(reader));
            DtoParser parser = new DtoParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            DtoErrorListener listener = new DtoErrorListener();
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)listener);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)listener);
            this.ast = parser.dto();
            DtoParser.ExportStatementContext export = this.ast.exportStatement();
            String sourceTypeName = null;
            String targetPackageName = null;
            if (export != null) {
                int lastIndex;
                List<Token> typeParts = export.typeParts;
                sourceTypeName = typeParts.size() == 1 ? dtoFile.getPackageName() + '.' + typeParts.get(0).getText() : typeParts.stream().map(Token::getText).collect(Collectors.joining("."));
                List<Token> packageParts = export.packageParts;
                targetPackageName = packageParts.isEmpty() ? ((lastIndex = sourceTypeName.lastIndexOf(46)) != -1 ? sourceTypeName.substring(0, lastIndex) + ".dto" : "") : packageParts.stream().map(Token::getText).collect(Collectors.joining("."));
            }
            if (sourceTypeName == null) {
                String name = dtoFile.getName();
                sourceTypeName = dtoFile.getPackageName() + '.' + name.substring(0, name.length() - 4);
            }
            this.sourceTypeName = sourceTypeName;
            this.targetPackageName = targetPackageName;
        }
    }

    public T getBaseType() {
        if (this.baseType == null) {
            throw new IllegalStateException("baseType has not be set");
        }
        return this.baseType;
    }

    public DtoFile getDtoFile() {
        return this.dtoFile;
    }

    public String getSourceTypeName() {
        return this.sourceTypeName;
    }

    public String getTargetPackageName() {
        return this.targetPackageName;
    }

    public List<DtoType<T, P>> compile(T baseType) {
        this.baseType = baseType;
        CompilerContext ctx = new CompilerContext(this);
        for (DtoParser.ImportStatementContext importStatement : this.ast.importStatements) {
            ctx.importStatement(importStatement);
        }
        for (DtoParser.DtoTypeContext dtoType : this.ast.dtoTypes) {
            ctx.add(dtoType);
        }
        return ctx.getDtoTypes();
    }

    protected abstract Collection<T> getSuperTypes(T var1);

    protected abstract Map<String, P> getDeclaredProps(T var1);

    protected abstract Map<String, P> getProps(T var1);

    protected abstract T getTargetType(P var1);

    protected abstract boolean isGeneratedValue(P var1);

    protected abstract List<String> getEnumConstants(P var1);

    protected abstract boolean isStringProp(P var1);

    protected abstract boolean isSameType(P var1, P var2);

    protected abstract Integer getGenericTypeCount(String var1);

    DtoAstException exception(int line, int col, String message) {
        return new DtoAstException(this.dtoFile, line, col, message);
    }

    public DtoModifier getDefaultNullableInputModifier() {
        return DtoModifier.STATIC;
    }

    private class DtoErrorListener
    extends BaseErrorListener {
        private DtoErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
            throw DtoCompiler.this.exception(line, charPositionInLine, msg);
        }
    }
}

