/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.antlr.v4.runtime.Token;
import org.babyfish.jimmer.dto.compiler.CompilerContext;
import org.babyfish.jimmer.dto.compiler.DtoParser;

public class EnumType {
    private final boolean isNumeric;
    private final Map<String, String> valueMap;
    private final Map<String, String> constantMap;

    private EnumType(boolean isNumeric, Map<String, String> valueMap, Map<String, String> constantMap) {
        this.isNumeric = isNumeric;
        this.valueMap = valueMap;
        this.constantMap = constantMap;
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public Map<String, String> getValueMap() {
        return this.valueMap;
    }

    public Map<String, String> getConstantMap() {
        return this.constantMap;
    }

    public static EnumType of(CompilerContext<?, ?> ctx, Collection<String> constants, DtoParser.EnumBodyContext enumBody) {
        Boolean isNumeric = null;
        HashSet<String> constantSet = new HashSet<String>(constants);
        LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>((enumBody.mappings.size() * 4 + 2) / 3);
        LinkedHashMap<String, String> constantMap = new LinkedHashMap<String, String>((enumBody.mappings.size() * 4 + 2) / 3);
        for (DtoParser.EnumMappingContext mapping : enumBody.mappings) {
            String constant = mapping.constant.getText();
            if (!constantSet.remove(constant)) {
                if (valueMap.containsKey(constant)) {
                    throw ctx.exception(mapping.constant.getLine(), mapping.constant.getCharPositionInLine(), "Duplicated enum constant: \"" + constant + "\"");
                }
                throw ctx.exception(mapping.constant.getLine(), mapping.constant.getCharPositionInLine(), "Illegal enum constant: \"" + constant + "\"");
            }
            Token valueToken = mapping.value;
            if (isNumeric != null && isNumeric != (valueToken.getType() == 44)) {
                throw ctx.exception(mapping.constant.getLine(), mapping.constant.getCharPositionInLine(), "Illegal value of enum constant: \"" + constant + "\", integer value and string value cannot be mixed");
            }
            isNumeric = valueToken.getType() == 44;
            valueMap.put(constant, valueToken.getText());
            String conflictConstant = constantMap.put(valueToken.getText(), constant);
            if (conflictConstant == null) continue;
            throw ctx.exception(mapping.constant.getLine(), mapping.constant.getCharPositionInLine(), "Illegal enum constant: \"" + constant + "\", its value is same with the value of \"" + conflictConstant + "\"");
        }
        if (!constantSet.isEmpty()) {
            throw ctx.exception(enumBody.start.getLine(), enumBody.start.getCharPositionInLine(), "The mapping(s) for " + constantSet + " is(are) not defined");
        }
        assert (isNumeric != null);
        return new EnumType(isNumeric, valueMap, constantMap);
    }
}

