/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.Token;
import org.babyfish.jimmer.dto.compiler.AbstractProp;
import org.babyfish.jimmer.dto.compiler.AbstractPropBuilder;
import org.babyfish.jimmer.dto.compiler.AliasPattern;
import org.babyfish.jimmer.dto.compiler.Anno;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.TypeRef;
import org.jetbrains.annotations.Nullable;

public class UserProp
implements AbstractProp,
AbstractPropBuilder {
    private final String alias;
    private final int line;
    private final int col;
    private final TypeRef typeRef;
    private final List<Anno> annotations;
    @Nullable
    private final String doc;

    public UserProp(Token alias, TypeRef typeRef, List<Anno> annotations, String doc) {
        this.alias = alias.getText();
        this.line = alias.getLine();
        this.col = alias.getCharPositionInLine();
        this.typeRef = typeRef;
        this.annotations = annotations;
        this.doc = doc;
    }

    @Override
    public String getName() {
        return this.alias;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public boolean isNullable() {
        return this.typeRef.isNullable();
    }

    @Override
    public int getAliasLine() {
        return this.line;
    }

    @Override
    public int getAliasColumn() {
        return this.col;
    }

    public TypeRef getTypeRef() {
        return this.typeRef;
    }

    @Override
    public List<Anno> getAnnotations() {
        return this.annotations;
    }

    @Override
    @Nullable
    public String getDoc() {
        return this.doc;
    }

    @Override
    public AliasPattern getAliasPattern() {
        return null;
    }

    @Override
    public UserProp build(DtoType<?, ?> type) {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserProp userProp = (UserProp)o;
        return this.line == userProp.line && Objects.equals(this.alias, userProp.alias) && Objects.equals(this.typeRef, userProp.typeRef);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.line, this.typeRef);
    }

    public String toString() {
        if (this.annotations.isEmpty()) {
            return this.alias + ": " + this.typeRef;
        }
        StringBuilder builder = new StringBuilder();
        for (Anno anno : this.annotations) {
            builder.append(anno);
        }
        builder.append(' ').append("alias").append(": ").append(this.typeRef);
        return builder.toString();
    }
}

