/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.babyfish.jimmer.dto.compiler.CompilerContext;
import org.babyfish.jimmer.dto.compiler.DtoAstException;
import org.babyfish.jimmer.dto.compiler.DtoLexer;
import org.babyfish.jimmer.dto.compiler.DtoParser;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;

public abstract class DtoCompiler<T extends BaseType, P extends BaseProp> {
    private final T baseType;
    private final String dtoFilePath;

    protected DtoCompiler(T baseType, String dtoFilePath) {
        this.baseType = baseType;
        this.dtoFilePath = dtoFilePath;
    }

    public T getBaseType() {
        return this.baseType;
    }

    public String getDtoFilePath() {
        return this.dtoFilePath;
    }

    public List<DtoType<T, P>> compile(String code) {
        DtoLexer lexer = new DtoLexer((CharStream)new ANTLRInputStream(code));
        DtoParser parser = new DtoParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        DtoErrorListener listener = new DtoErrorListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        return this.parse(parser);
    }

    public List<DtoType<T, P>> compile(Reader reader) throws IOException {
        DtoLexer lexer = new DtoLexer((CharStream)new ANTLRInputStream(reader));
        DtoParser parser = new DtoParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        DtoErrorListener listener = new DtoErrorListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        return this.parse(parser);
    }

    public List<DtoType<T, P>> compile(InputStream input) throws IOException {
        DtoLexer lexer = new DtoLexer((CharStream)new ANTLRInputStream(input));
        DtoParser parser = new DtoParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        DtoErrorListener listener = new DtoErrorListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        return this.parse(parser);
    }

    private List<DtoType<T, P>> parse(DtoParser parser) {
        CompilerContext ctx = new CompilerContext(this);
        DtoParser.DtoContext dto = parser.dto();
        for (DtoParser.ImportStatementContext importStatement : dto.importStatements) {
            ctx.importStatement(importStatement);
        }
        for (DtoParser.DtoTypeContext dtoType : dto.dtoTypes) {
            ctx.add(dtoType);
        }
        return ctx.getDtoTypes();
    }

    protected abstract Collection<T> getSuperTypes(T var1);

    protected abstract Map<String, P> getDeclaredProps(T var1);

    protected abstract Map<String, P> getProps(T var1);

    protected abstract T getTargetType(P var1);

    protected abstract boolean isGeneratedValue(P var1);

    DtoAstException exception(int line, String message) {
        return new DtoAstException(this.dtoFilePath, line, message);
    }

    private class DtoErrorListener
    extends BaseErrorListener {
        private DtoErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
            throw DtoCompiler.this.exception(line, msg);
        }
    }
}

