/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.babyfish.jimmer.dto.compiler.AbstractProp;
import org.babyfish.jimmer.dto.compiler.AbstractPropBuilder;
import org.babyfish.jimmer.dto.compiler.AliasPattern;
import org.babyfish.jimmer.dto.compiler.Anno;
import org.babyfish.jimmer.dto.compiler.AnnoParser;
import org.babyfish.jimmer.dto.compiler.CompilerContext;
import org.babyfish.jimmer.dto.compiler.Constants;
import org.babyfish.jimmer.dto.compiler.DtoParser;
import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoPropBuilder;
import org.babyfish.jimmer.dto.compiler.DtoPropImpl;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.DtoTypeModifier;
import org.babyfish.jimmer.dto.compiler.Mandatory;
import org.babyfish.jimmer.dto.compiler.TypeRef;
import org.babyfish.jimmer.dto.compiler.UserProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;

class DtoTypeBuilder<T extends BaseType, P extends BaseProp> {
    final DtoPropBuilder<T, P> parentProp;
    final T baseType;
    final CompilerContext<T, P> ctx;
    final Token name;
    final Token bodyStart;
    final List<Anno> annotations;
    final List<TypeRef> superInterfaces;
    final String doc;
    final Set<DtoTypeModifier> modifiers;
    final Map<String, DtoPropBuilder<T, P>> autoPropMap;
    final Map<P, List<DtoPropBuilder<T, P>>> positivePropMap;
    final Map<String, AbstractPropBuilder> aliasPositivePropMap;
    final List<DtoPropBuilder<T, P>> flatPositiveProps;
    final Map<String, Boolean> negativePropAliasMap;
    final List<Token> negativePropAliasTokens;
    private DtoType<T, P> dtoType;
    private AliasPattern currentAliasGroup;
    private Map<String, AbstractProp> declaredProps;

    DtoTypeBuilder(DtoPropBuilder<T, P> parentProp, T baseType, DtoParser.DtoBodyContext body, Token name, String doc, Set<DtoTypeModifier> modifiers, List<DtoParser.AnnotationContext> annotations, List<DtoParser.TypeRefContext> superInterfaces, CompilerContext<T, P> ctx) {
        this.parentProp = parentProp;
        this.baseType = baseType;
        this.ctx = ctx;
        this.name = name;
        this.bodyStart = body.start;
        this.autoPropMap = new LinkedHashMap<String, DtoPropBuilder<T, P>>();
        this.positivePropMap = new LinkedHashMap<P, List<DtoPropBuilder<T, P>>>();
        this.aliasPositivePropMap = new LinkedHashMap<String, AbstractPropBuilder>();
        this.flatPositiveProps = new ArrayList<DtoPropBuilder<T, P>>();
        this.negativePropAliasMap = new LinkedHashMap<String, Boolean>();
        this.negativePropAliasTokens = new ArrayList<Token>();
        this.doc = doc;
        this.modifiers = Collections.unmodifiableSet(modifiers);
        if (annotations.isEmpty()) {
            this.annotations = Collections.emptyList();
        } else {
            List<Anno> parsedAnnotations = new ArrayList(annotations.size());
            AnnoParser parser = new AnnoParser(ctx);
            for (DtoParser.AnnotationContext annotation : annotations) {
                parsedAnnotations.add(parser.parse(annotation));
            }
            parsedAnnotations = Collections.unmodifiableList(parsedAnnotations);
            this.annotations = parsedAnnotations;
        }
        if (superInterfaces.isEmpty()) {
            this.superInterfaces = Collections.emptyList();
        } else {
            ArrayList<TypeRef> parsedSuperInterfaces = new ArrayList<TypeRef>(superInterfaces.size());
            LinkedHashSet<String> typeNames = new LinkedHashSet<String>((parsedSuperInterfaces.size() * 4 + 2) / 3);
            for (DtoParser.TypeRefContext superInterface : superInterfaces) {
                if (superInterface.optional != null) {
                    throw ctx.exception(superInterface.optional.getLine(), superInterface.optional.getCharPositionInLine(), "The super interface type cannot be nullable");
                }
                TypeRef superTypeRef = ctx.resolve(superInterface);
                if (superTypeRef.getTypeName().startsWith("org.babyfish.jimmer.")) {
                    throw ctx.exception(superInterface.stop.getLine(), superInterface.stop.getCharPositionInLine(), "Illegal super interface type \"" + superTypeRef.getTypeName() + "\", types under `org.babyfish.jimmer` are not allowed");
                }
                if (!typeNames.add(superTypeRef.getTypeName())) {
                    throw ctx.exception(superInterface.stop.getLine(), superInterface.stop.getCharPositionInLine(), "Duplicate super interface \"" + superTypeRef.getTypeName() + "\"");
                }
                parsedSuperInterfaces.add(superTypeRef);
            }
            this.superInterfaces = Collections.unmodifiableList(parsedSuperInterfaces);
        }
        for (DtoParser.ExplicitPropContext prop : body.explicitProps) {
            if (prop.micro() != null) {
                this.handleMicro(prop.micro());
                continue;
            }
            if (prop.aliasGroup() != null) {
                this.handleAliasGroup(prop.aliasGroup());
                continue;
            }
            if (prop.positiveProp() != null) {
                this.handlePositiveProp(prop.positiveProp());
                continue;
            }
            if (prop.negativeProp() != null) {
                this.handleNegativeProp(prop.negativeProp());
                continue;
            }
            this.handleUserProp(prop.userProp());
        }
    }

    private DtoTypeBuilder(DtoTypeBuilder<T, P> base, Set<DtoPropBuilder<T, P>> removedPropBuilders) {
        this.parentProp = base.parentProp;
        this.baseType = base.baseType;
        this.ctx = base.ctx;
        this.bodyStart = base.bodyStart;
        this.modifiers = base.modifiers;
        this.annotations = base.annotations;
        this.superInterfaces = base.superInterfaces;
        this.doc = base.doc;
        this.autoPropMap = base.autoPropMap;
        this.flatPositiveProps = base.flatPositiveProps;
        this.negativePropAliasMap = base.negativePropAliasMap;
        this.negativePropAliasTokens = base.negativePropAliasTokens;
        this.name = null;
        LinkedHashMap<P, List<DtoPropBuilder<T, P>>> positivePropMap = new LinkedHashMap<P, List<DtoPropBuilder<T, P>>>(base.positivePropMap);
        Iterator itr = positivePropMap.values().iterator();
        while (itr.hasNext()) {
            List list = (List)itr.next();
            list.removeAll(removedPropBuilders);
            if (!list.isEmpty()) continue;
            itr.remove();
        }
        this.positivePropMap = positivePropMap;
        LinkedHashMap<String, AbstractPropBuilder> aliasPositiveMap = new LinkedHashMap<String, AbstractPropBuilder>(base.aliasPositivePropMap);
        aliasPositiveMap.values().removeAll(removedPropBuilders);
        this.aliasPositivePropMap = aliasPositiveMap;
    }

    public boolean isAbstract() {
        return this.modifiers.contains((Object)DtoTypeModifier.ABSTRACT);
    }

    private void handleMicro(DtoParser.MicroContext micro) {
        Mandatory mandatory;
        boolean isAllReferences = micro.name.getText().equals("allReferences");
        if (!micro.name.getText().equals("allScalars") && !isAllReferences) {
            throw this.ctx.exception(micro.name.getLine(), micro.name.getCharPositionInLine(), "Illegal micro name \"" + micro.name.getText() + "\", it must be \"#allScalars\" or \"#allReferences\"");
        }
        if (!this.positivePropMap.isEmpty() || !this.negativePropAliasMap.isEmpty()) {
            throw this.ctx.exception(micro.name.getLine(), micro.name.getCharPositionInLine(), "`#" + micro.name + "` must be defined at the beginning");
        }
        if (micro.required != null) {
            mandatory = Mandatory.REQUIRED;
        } else if (micro.optional != null) {
            if (this.modifiers.contains((Object)DtoTypeModifier.SPECIFICATION)) {
                throw this.ctx.exception(micro.name.getLine(), micro.name.getCharPositionInLine(), "Unnecessary optional modifier '?', all properties of specification are automatically optional");
            }
            mandatory = Mandatory.OPTIONAL;
        } else {
            Mandatory mandatory2 = mandatory = this.modifiers.contains((Object)DtoTypeModifier.SPECIFICATION) ? Mandatory.OPTIONAL : Mandatory.DEFAULT;
        }
        if (micro.args.isEmpty()) {
            for (BaseProp baseProp : this.ctx.getProps(this.baseType).values()) {
                if (!(isAllReferences ? this.isAutoReference(baseProp) : this.isAutoScalar(baseProp))) continue;
                DtoPropBuilder propBuilder = new DtoPropBuilder(this, this.currentAliasGroup, baseProp, micro.start.getLine(), micro.start.getCharPositionInLine(), isAllReferences ? "id" : null, mandatory, null);
                this.autoPropMap.put(propBuilder.getAlias(), propBuilder);
            }
        } else {
            HashMap qualifiedNameTypeMap = new HashMap();
            HashMap<String, Set<T>> nameTypeMap = new HashMap<String, Set<T>>();
            this.collectSuperTypes(this.baseType, qualifiedNameTypeMap, nameTypeMap);
            LinkedHashSet<T> handledBaseTypes = new LinkedHashSet<T>();
            for (DtoParser.QualifiedNameContext qnCtx : micro.args) {
                Object baseType;
                String qualifiedName = qnCtx.parts.stream().map(Token::getText).collect(Collectors.joining("."));
                Object object = baseType = qualifiedName.equals("this") ? this.baseType : (BaseType)qualifiedNameTypeMap.get(qualifiedName);
                if (baseType == null) {
                    Set baseTypes = (Set)nameTypeMap.get(qualifiedName);
                    if (baseTypes != null) {
                        if (baseTypes.size() == 1) {
                            baseType = (BaseType)baseTypes.iterator().next();
                        } else {
                            throw this.ctx.exception(qnCtx.start.getLine(), qnCtx.start.getCharPositionInLine(), "Illegal type name \"" + qualifiedName + "\", it matches several types: " + baseTypes.stream().map(BaseType::getQualifiedName).collect(Collectors.joining(", ")));
                        }
                    }
                    if (baseType == null) {
                        if (qualifiedName.indexOf(46) == -1) {
                            String imported;
                            try {
                                imported = this.ctx.resolve(qnCtx);
                            }
                            catch (Throwable ex) {
                                imported = null;
                            }
                            if (imported != null) {
                                baseType = (BaseType)qualifiedNameTypeMap.get(imported);
                            }
                        }
                        if (baseType == null) {
                            throw this.ctx.exception(qnCtx.start.getLine(), qnCtx.start.getCharPositionInLine(), "Illegal type name \"" + qualifiedName + "\", it is not super type of \"" + this.baseType + "\"");
                        }
                    }
                }
                if (!handledBaseTypes.add(baseType)) {
                    throw this.ctx.exception(qnCtx.start.getLine(), qnCtx.start.getCharPositionInLine(), "Illegal type name \"" + qualifiedName + "\", it is not super type of \"" + baseType.getName() + "\"");
                }
                for (BaseProp baseProp : this.ctx.getDeclaredProps(baseType).values()) {
                    if (!(isAllReferences ? this.isAutoReference(baseProp) : this.isAutoScalar(baseProp)) || this.autoPropMap.containsKey(baseProp.getName())) continue;
                    DtoPropBuilder propBuilder = new DtoPropBuilder(this, this.currentAliasGroup, baseProp, qnCtx.stop.getLine(), qnCtx.stop.getCharPositionInLine(), isAllReferences ? "id" : null, mandatory, null);
                    this.autoPropMap.put(propBuilder.getAlias(), propBuilder);
                }
            }
        }
    }

    public AliasPattern currentAliasGroup() {
        return this.currentAliasGroup;
    }

    private void handlePositiveProp(DtoParser.PositivePropContext prop) {
        DtoPropBuilder builder = new DtoPropBuilder(this, this.currentAliasGroup, prop);
        for (BaseProp baseProp : builder.getBasePropMap().values()) {
            this.handlePositiveProp0(builder, baseProp);
        }
    }

    private void handlePositiveProp0(DtoPropBuilder<T, P> propBuilder, P baseProp) {
        List<DtoPropBuilder<T, P>> builders = this.positivePropMap.get(baseProp);
        if (builders == null) {
            builders = new ArrayList<DtoPropBuilder<T, P>>();
            this.positivePropMap.put(baseProp, builders);
        } else {
            String newFuncName;
            String oldFuncName;
            boolean valid = false;
            if (builders.size() < 2 && !Objects.equals(oldFuncName = builders.get(0).getFuncName(), newFuncName = propBuilder.getFuncName()) && Constants.QBE_FUNC_NAMES.contains(oldFuncName) && Constants.QBE_FUNC_NAMES.contains(newFuncName)) {
                valid = true;
            }
            if (!valid) {
                throw this.ctx.exception(propBuilder.getBaseLine(), propBuilder.getBaseColumn(), "Base property \"" + baseProp + "\" cannot be referenced too many times");
            }
        }
        builders.add(propBuilder);
        if (propBuilder.getAlias() != null) {
            AbstractPropBuilder conflictPropBuilder = this.aliasPositivePropMap.put(propBuilder.getAlias(), propBuilder);
            if (conflictPropBuilder != null && conflictPropBuilder != propBuilder) {
                throw this.ctx.exception(propBuilder.getAliasLine(), propBuilder.getAliasColumn(), "Duplicated property alias \"" + propBuilder.getAlias() + "\"");
            }
        } else {
            this.flatPositiveProps.add(propBuilder);
        }
    }

    private void handleNegativeProp(DtoParser.NegativePropContext prop) {
        if (this.negativePropAliasMap.put(prop.prop.getText(), false) != null) {
            throw this.ctx.exception(prop.prop.getLine(), prop.prop.getCharPositionInLine(), "Duplicate negative property alias \"" + prop.prop.getText() + "\"");
        }
        this.negativePropAliasTokens.add(prop.prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAliasGroup(DtoParser.AliasGroupContext group) {
        this.currentAliasGroup = new AliasPattern(this.ctx, group.pattern);
        try {
            for (DtoParser.AliasGroupPropContext prop : group.props) {
                if (prop.micro() != null) {
                    this.handleMicro(prop.micro());
                    continue;
                }
                this.handlePositiveProp(prop.positiveProp());
            }
        }
        finally {
            this.currentAliasGroup = null;
        }
    }

    private void handleUserProp(DtoParser.UserPropContext prop) {
        List<Anno> annotations;
        if (prop.annotations.isEmpty()) {
            annotations = Collections.emptyList();
        } else {
            annotations = new ArrayList(prop.annotations.size());
            AnnoParser annoParser = new AnnoParser(this.ctx);
            for (DtoParser.AnnotationContext anno : prop.annotations) {
                annotations.add(annoParser.parse(anno));
            }
            annotations = Collections.unmodifiableList(annotations);
        }
        TypeRef typeRef = this.ctx.resolve(prop.typeRef());
        if (!(typeRef.isNullable() || this.modifiers.contains((Object)DtoTypeModifier.SPECIFICATION) || TypeRef.TNS_WITH_DEFAULT_VALUE.contains(typeRef.getTypeName()))) {
            throw this.ctx.exception(prop.prop.getLine(), prop.prop.getCharPositionInLine(), "Illegal user defined property \"" + prop.prop.getText() + "\", it is not null but its default value cannot be determined, so it must be declared in dto type with the modifier 'specification'");
        }
        UserProp userProp = new UserProp(prop.prop, typeRef, annotations, prop.doc != null ? prop.doc.getText() : null);
        if (this.aliasPositivePropMap.put(userProp.getAlias(), userProp) != null) {
            throw this.ctx.exception(prop.prop.getLine(), prop.prop.getCharPositionInLine(), "Duplicated property alias \"" + prop.prop.getText() + "\"");
        }
    }

    private boolean isAutoScalar(P baseProp) {
        return !baseProp.isFormula() && !baseProp.isTransient() && baseProp.getIdViewBaseProp() == null && baseProp.getManyToManyViewBaseProp() == null && !baseProp.isList() && !baseProp.isAssociation(true);
    }

    private boolean isAutoReference(P baseProp) {
        return baseProp.isAssociation(true) && !baseProp.isList() && !baseProp.isTransient();
    }

    private void collectSuperTypes(T baseType, Map<String, T> qualifiedNameTypeMap, Map<String, Set<T>> nameTypeMap) {
        qualifiedNameTypeMap.put(baseType.getQualifiedName(), baseType);
        nameTypeMap.computeIfAbsent(baseType.getName(), it -> new LinkedHashSet()).add(baseType);
        for (BaseType superType : this.ctx.getSuperTypes(baseType)) {
            this.collectSuperTypes(superType, qualifiedNameTypeMap, nameTypeMap);
        }
    }

    DtoType<T, P> build() {
        if (this.dtoType != null) {
            return this.dtoType;
        }
        this.dtoType = new DtoType(this.baseType, this.ctx.getTargetPackageName(), this.modifiers, this.annotations, this.superInterfaces, this.name != null ? this.name.getText() : null, this.ctx.getDtoFile(), this.doc);
        Map<String, AbstractProp> propMap = this.resolveDeclaredProps();
        this.validateUnusedNegativePropTokens();
        ArrayList<AbstractProp> props = new ArrayList<AbstractProp>(propMap.size());
        for (AbstractProp prop : propMap.values()) {
            if (prop instanceof UserProp) continue;
            props.add(prop);
        }
        for (AbstractProp prop : propMap.values()) {
            if (!(prop instanceof UserProp)) continue;
            props.add(prop);
        }
        this.dtoType.setProps(Collections.unmodifiableList(props));
        return this.dtoType;
    }

    private Map<String, AbstractProp> resolveDeclaredProps() {
        if (this.declaredProps != null) {
            return this.declaredProps;
        }
        LinkedHashMap<String, AbstractProp> declaredPropMap = new LinkedHashMap<String, AbstractProp>();
        for (DtoPropBuilder<T, P> dtoPropBuilder : this.autoPropMap.values()) {
            if (this.isExcluded(dtoPropBuilder.getAlias()) || this.positivePropMap.containsKey(dtoPropBuilder.getBaseProp())) continue;
            this.addProps(dtoPropBuilder, declaredPropMap);
        }
        for (AbstractPropBuilder abstractPropBuilder : this.aliasPositivePropMap.values()) {
            if (this.isExcluded(abstractPropBuilder.getAlias()) || declaredPropMap.containsKey(abstractPropBuilder.getAlias())) continue;
            this.addProps(abstractPropBuilder, declaredPropMap);
        }
        for (DtoPropBuilder dtoPropBuilder : this.flatPositiveProps) {
            AbstractProp head = dtoPropBuilder.build((DtoType)this.dtoType);
            List<AbstractProp> deeperProps = dtoPropBuilder.getTargetBuilder().build().getProps();
            for (AbstractProp deeperProp : deeperProps) {
                if (deeperProp instanceof UserProp) {
                    UserProp userProp = (UserProp)deeperProp;
                    throw this.ctx.exception(userProp.getAliasLine(), userProp.getAliasColumn(), "User defined property cannot be declared under flat type");
                }
                DtoProp deeperDtoProp = (DtoProp)deeperProp;
                String alias = deeperDtoProp.getAlias();
                DtoPropImpl dtoProp = new DtoPropImpl(head, deeperDtoProp, null);
                if (this.isExcluded(alias) || declaredPropMap.put(alias, dtoProp) == null) continue;
                throw this.ctx.exception(dtoProp.getAliasLine(), dtoProp.getAliasColumn(), "Duplicated property alias \"" + alias + "\"");
            }
        }
        this.declaredProps = Collections.unmodifiableMap(declaredPropMap);
        return this.declaredProps;
    }

    private void addProps(AbstractPropBuilder propBuilder, Map<String, AbstractProp> outMap) {
        AbstractProp prop = propBuilder.build(this.dtoType);
        if (prop instanceof DtoProp && ((DtoProp)prop).isFlat()) {
            for (AbstractProp deeperProp : ((DtoProp)prop).getTargetType().getProps()) {
                DtoPropImpl flattedProp = new DtoPropImpl((DtoPropImpl)prop, (DtoPropImpl)deeperProp, propBuilder.getAliasPattern());
                if (outMap.put(flattedProp.getAlias(), flattedProp) == null) continue;
                throw this.ctx.exception(flattedProp.getAliasLine(), flattedProp.getAliasColumn(), "Duplicated property alias \"" + flattedProp.getAlias() + "\"");
            }
        } else if (outMap.put(prop.getAlias(), prop) != null) {
            throw this.ctx.exception(prop.getAliasLine(), prop.getAliasColumn(), "Duplicated property alias \"" + propBuilder.getAlias() + "\"");
        }
    }

    private boolean isExcluded(String alias) {
        if (!this.negativePropAliasMap.containsKey(alias)) {
            return false;
        }
        this.negativePropAliasMap.put(alias, true);
        return true;
    }

    private void validateUnusedNegativePropTokens() {
        for (Token token : this.negativePropAliasTokens) {
            if (this.negativePropAliasMap.get(token.getText()).booleanValue()) continue;
            throw this.ctx.exception(token.getLine(), token.getCharPositionInLine(), "There is no property alias \"" + token.getText() + "\" that is need to be removed");
        }
    }
}

