/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.babyfish.jimmer.dto.compiler.AbstractProp;
import org.babyfish.jimmer.dto.compiler.AbstractPropBuilder;
import org.babyfish.jimmer.dto.compiler.AliasPattern;
import org.babyfish.jimmer.dto.compiler.Anno;
import org.babyfish.jimmer.dto.compiler.AnnoParser;
import org.babyfish.jimmer.dto.compiler.CompilerContext;
import org.babyfish.jimmer.dto.compiler.DtoParser;
import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoPropBuilder;
import org.babyfish.jimmer.dto.compiler.DtoPropImpl;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.DtoTypeModifier;
import org.babyfish.jimmer.dto.compiler.Mandatory;
import org.babyfish.jimmer.dto.compiler.RecursiveDtoProp;
import org.babyfish.jimmer.dto.compiler.TypeRef;
import org.babyfish.jimmer.dto.compiler.UserProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;

class DtoTypeBuilder<T extends BaseType, P extends BaseProp> {
    final T baseType;
    final CompilerContext<T, P> ctx;
    final Token name;
    final Token bodyStart;
    final List<Anno> annotations;
    final Set<DtoTypeModifier> modifiers;
    final List<Token> superNames;
    final P recursiveBaseProp;
    final String recursiveAlias;
    final Map<String, DtoPropBuilder<T, P>> autoScalarPropMap = new LinkedHashMap<String, DtoPropBuilder<T, P>>();
    final Map<P, DtoPropBuilder<T, P>> positivePropMap = new LinkedHashMap<P, DtoPropBuilder<T, P>>();
    final Map<String, AbstractPropBuilder> aliasPositivePropMap = new LinkedHashMap<String, AbstractPropBuilder>();
    final List<DtoPropBuilder<T, P>> flatPositiveProps = new ArrayList<DtoPropBuilder<T, P>>();
    final Map<String, Boolean> negativePropAliasMap = new LinkedHashMap<String, Boolean>();
    final List<Token> negativePropAliasTokens = new ArrayList<Token>();
    private List<DtoTypeBuilder<T, P>> superTypeBuilders;
    private DtoType<T, P> dtoType;
    private AliasPattern currentAliasGroup;
    private Map<String, AbstractProp> declaredProps;

    DtoTypeBuilder(T baseType, DtoParser.DtoBodyContext body, Token name, List<DtoParser.AnnotationContext> annotations, Set<DtoTypeModifier> modifiers, List<Token> superNames, P recursiveBaseProp, String recursiveAlias, CompilerContext<T, P> ctx) {
        this.baseType = baseType;
        this.ctx = ctx;
        this.name = name;
        this.bodyStart = body.start;
        if (annotations.isEmpty()) {
            this.annotations = Collections.emptyList();
        } else {
            List<Anno> parsedAnnotations = new ArrayList(annotations.size());
            AnnoParser parser = new AnnoParser(ctx);
            for (DtoParser.AnnotationContext annotation : annotations) {
                parsedAnnotations.add(parser.parse(annotation));
            }
            parsedAnnotations = Collections.unmodifiableList(parsedAnnotations);
            this.annotations = parsedAnnotations;
        }
        this.modifiers = Collections.unmodifiableSet(modifiers);
        this.superNames = superNames;
        this.recursiveBaseProp = recursiveBaseProp;
        this.recursiveAlias = recursiveAlias;
        for (DtoParser.ExplicitPropContext prop : body.explicitProps) {
            if (prop.allScalars() != null) {
                this.handleAllScalars(prop.allScalars());
                continue;
            }
            if (prop.aliasGroup() != null) {
                this.handleAliasGroup(prop.aliasGroup());
                continue;
            }
            if (prop.positiveProp() != null) {
                this.handlePositiveProp(prop.positiveProp());
                continue;
            }
            if (prop.negativeProp() != null) {
                this.handleNegativeProp(prop.negativeProp());
                continue;
            }
            this.handleUserProp(prop.userProp());
        }
    }

    public boolean isAbstract() {
        return this.modifiers.contains((Object)DtoTypeModifier.ABSTRACT);
    }

    private void handleAllScalars(DtoParser.AllScalarsContext allScalars) {
        if (!allScalars.name.getText().equals("allScalars")) {
            throw this.ctx.exception(allScalars.name.getLine(), "Illegal allScalars name \"" + allScalars.name.getText() + "\", it must be \"allScalars\"");
        }
        if (!this.positivePropMap.isEmpty()) {
            throw this.ctx.exception(allScalars.name.getLine(), "`#allScalars` must be defined at the beginning");
        }
        if (allScalars.args.isEmpty()) {
            for (BaseProp baseProp : this.ctx.getProps(this.baseType).values()) {
                Mandatory mandatory = allScalars.required != null ? Mandatory.REQUIRED : (allScalars.optional != null ? Mandatory.OPTIONAL : Mandatory.DEFAULT);
                if (!this.isAutoScalar(baseProp)) continue;
                this.autoScalarPropMap.put(baseProp.getName(), new DtoPropBuilder(this, baseProp, allScalars.start.getLine(), mandatory));
            }
        } else {
            HashMap qualifiedNameTypeMap = new HashMap();
            HashMap<String, Set<T>> nameTypeMap = new HashMap<String, Set<T>>();
            DtoTypeBuilder.collectSuperTypes(this.baseType, qualifiedNameTypeMap, nameTypeMap);
            LinkedHashSet<BaseType> handledBaseTypes = new LinkedHashSet<BaseType>();
            for (DtoParser.QualifiedNameContext qnCtx : allScalars.args) {
                String qualifiedName = qnCtx.parts.stream().map(Token::getText).collect(Collectors.joining("."));
                BaseType baseType = (BaseType)qualifiedNameTypeMap.get(qualifiedName);
                if (baseType == null) {
                    Set baseTypes = (Set)nameTypeMap.get(qualifiedName);
                    if (baseTypes != null) {
                        if (baseTypes.size() == 1) {
                            baseType = (BaseType)baseTypes.iterator().next();
                        } else {
                            throw this.ctx.exception(qnCtx.start.getLine(), "Illegal type name \"" + qualifiedName + "\", it matches several types: " + baseTypes.stream().map(BaseType::getQualifiedName).collect(Collectors.joining(", ")));
                        }
                    }
                    if (baseType == null) {
                        throw this.ctx.exception(qnCtx.start.getLine(), "Illegal type name \"" + qualifiedName + "\", it is not super type of \"" + this.baseType.getQualifiedName() + "\"");
                    }
                }
                if (!handledBaseTypes.add(baseType)) {
                    throw this.ctx.exception(qnCtx.start.getLine(), "Illegal type name \"" + qualifiedName + "\", it is not super type of \"" + baseType.getName() + "\"");
                }
                for (BaseProp baseProp : this.ctx.getDeclaredProps(baseType).values()) {
                    Mandatory mandatory = allScalars.required != null ? Mandatory.REQUIRED : (allScalars.optional != null ? Mandatory.OPTIONAL : Mandatory.DEFAULT);
                    if (!this.isAutoScalar(baseProp) || this.autoScalarPropMap.containsKey(baseProp.getName())) continue;
                    this.autoScalarPropMap.put(baseProp.getName(), new DtoPropBuilder(this, baseProp, qnCtx.stop.getLine(), mandatory));
                }
            }
        }
    }

    public AliasPattern currentAliasGroup() {
        return this.currentAliasGroup;
    }

    private void handlePositiveProp(DtoParser.PositivePropContext prop) {
        DtoPropBuilder builder = new DtoPropBuilder(this, prop);
        if (this.positivePropMap.put(builder.getBaseProp(), builder) != null) {
            throw this.ctx.exception(builder.getBaseLine(), "Base property \"" + builder.getBaseProp() + "\" cannot be referenced twice");
        }
        if (builder.getAlias() != null) {
            if (this.aliasPositivePropMap.put(builder.getAlias(), builder) != null) {
                throw this.ctx.exception(builder.getAliasLine(), "Duplicated property alias \"" + builder.getAlias() + "\"");
            }
        } else {
            this.flatPositiveProps.add(builder);
        }
    }

    private void handleNegativeProp(DtoParser.NegativePropContext prop) {
        if (this.negativePropAliasMap.put(prop.prop.getText(), false) != null) {
            throw this.ctx.exception(prop.prop.getLine(), "Duplicate negative property alias \"" + prop.prop.getText() + "\"");
        }
        this.negativePropAliasTokens.add(prop.prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAliasGroup(DtoParser.AliasGroupContext group) {
        this.currentAliasGroup = new AliasPattern(this.ctx, group.pattern);
        try {
            for (DtoParser.AliasGroupPropContext prop : group.props) {
                if (prop.allScalars() != null) {
                    this.handleAllScalars(prop.allScalars());
                    continue;
                }
                this.handlePositiveProp(prop.positiveProp());
            }
        }
        finally {
            this.currentAliasGroup = null;
        }
    }

    private void handleUserProp(DtoParser.UserPropContext prop) {
        List<Anno> annotations;
        if (prop.annotations.isEmpty()) {
            annotations = Collections.emptyList();
        } else {
            annotations = new ArrayList(prop.annotations.size());
            AnnoParser annoParser = new AnnoParser(this.ctx);
            for (DtoParser.AnnotationContext anno : prop.annotations) {
                annotations.add(annoParser.parse(anno));
            }
            annotations = Collections.unmodifiableList(annotations);
        }
        TypeRef typeRef = this.ctx.resolve(prop.typeRef());
        if (!(typeRef.isNullable() || this.modifiers.contains((Object)DtoTypeModifier.INPUT_ONLY) || TypeRef.TNS_WITH_DEFAULT_VALUE.contains(typeRef.getTypeName()))) {
            throw this.ctx.exception(prop.prop.getLine(), "Illegal user defined property \"" + prop.prop.getText() + "\", it is not null but its default value cannot be determined, so it must be declared in dto type with the modifier 'inputOnly'");
        }
        UserProp userProp = new UserProp(prop.prop, typeRef, annotations);
        if (this.aliasPositivePropMap.put(userProp.getAlias(), userProp) != null) {
            throw this.ctx.exception(prop.prop.getLine(), "Duplicated property alias \"" + prop.prop.getText() + "\"");
        }
    }

    private boolean isAutoScalar(P baseProp) {
        return !baseProp.isFormula() && !baseProp.isTransient() && baseProp.getIdViewBaseProp() == null && baseProp.getManyToManyViewBaseProp() == null && !baseProp.isList() && this.ctx.getTargetType(baseProp) == null;
    }

    private static <T extends BaseType> void collectSuperTypes(T baseType, Map<String, T> qualifiedNameTypeMap, Map<String, Set<T>> nameTypeMap) {
        qualifiedNameTypeMap.put(baseType.getQualifiedName(), baseType);
        nameTypeMap.computeIfAbsent(baseType.getName(), it -> new LinkedHashSet()).add(baseType);
    }

    DtoType<T, P> build() {
        List<DtoType> superTypes;
        if (this.dtoType != null) {
            return this.dtoType;
        }
        this.dtoType = new DtoType(this.baseType, this.annotations, this.modifiers, this.name != null ? this.name.getText() : null, this.ctx.getDtoFilePath());
        this.resolveSuperTypes(new LinkedList<DtoTypeBuilder<T, P>>());
        if (this.superTypeBuilders.isEmpty()) {
            superTypes = Collections.emptyList();
        } else {
            superTypes = new ArrayList<DtoType>(this.superTypeBuilders.size());
            for (DtoTypeBuilder<T, P> superTypeBuilder : this.superTypeBuilders) {
                DtoType<T, P> superType = superTypeBuilder.build();
                if (this.modifiers.contains((Object)DtoTypeModifier.INPUT) && !superType.getModifiers().contains((Object)DtoTypeModifier.INPUT)) {
                    assert (this.name != null);
                    throw this.ctx.exception(this.name.getLine(), "Illegal type \"" + this.name.getText() + "\", it is input type but the super type \"" + superType.getName() + "\" is not input");
                }
                if (this.modifiers.contains((Object)DtoTypeModifier.INPUT_ONLY) && !superType.getModifiers().contains((Object)DtoTypeModifier.INPUT_ONLY)) {
                    assert (this.name != null);
                    throw this.ctx.exception(this.name.getLine(), "Illegal type \"" + this.name.getText() + "\", it is inputOnly type but the super type \"" + superType.getName() + "\" is not inputOnly");
                }
                if (!this.modifiers.contains((Object)DtoTypeModifier.INPUT_ONLY) && superType.getModifiers().contains((Object)DtoTypeModifier.INPUT_ONLY)) {
                    assert (this.name != null);
                    throw this.ctx.exception(this.name.getLine(), "Illegal type \"" + this.name.getText() + "\", it is not inputOnly type but the super type \"" + superType.getName() + "\" is inputOnly");
                }
                superTypes.add(superType);
            }
        }
        Map<String, AbstractProp> declaredProps = this.resolveDeclaredProps();
        LinkedHashMap superProps = new LinkedHashMap();
        if (!superTypes.isEmpty()) {
            LinkedHashMap basePathSuperProps = new LinkedHashMap();
            HashSet<String> declaredBasePaths = new HashSet<String>();
            for (AbstractProp declaredProp : declaredProps.values()) {
                if (!(declaredProp instanceof DtoProp)) continue;
                declaredBasePaths.add(((DtoProp)declaredProp).getBasePath());
            }
            for (DtoType superType : superTypes) {
                for (DtoProp superDtoProp : superType.getDtoProps()) {
                    String alias = superDtoProp.getAlias();
                    if (this.isExcluded(alias) || declaredProps.containsKey(superDtoProp.getAlias()) || declaredBasePaths.contains(superDtoProp.getBasePath())) continue;
                    DtoProp baseConflictProp = basePathSuperProps.put(superDtoProp.getBasePath(), superDtoProp);
                    if (baseConflictProp != null && !DtoPropImpl.canMerge(baseConflictProp, superDtoProp)) {
                        assert (this.name != null);
                        throw this.ctx.exception(this.name.getLine(), "Illegal dto type \"" + this.name.getText() + "\", the base property \"" + superDtoProp.getBasePath() + "\" is defined differently by multiple super type so that it must be overridden");
                    }
                    AbstractProp conflictAliasProp = superProps.put(alias, superDtoProp);
                    if (conflictAliasProp == null || DtoPropImpl.canMerge(conflictAliasProp, superDtoProp)) continue;
                    assert (this.name != null);
                    throw this.ctx.exception(this.name.getLine(), "Illegal dto type \"" + this.name.getText() + "\", the property alias \"" + alias + "\" is defined differently by multiple super type so that it must be overridden");
                }
            }
        }
        ArrayList<AbstractProp> props = new ArrayList<AbstractProp>();
        for (AbstractProp prop : superProps.values()) {
            if (!(prop instanceof DtoProp)) continue;
            props.add(prop);
        }
        for (AbstractProp prop : declaredProps.values()) {
            if (!(prop instanceof DtoProp)) continue;
            props.add(prop);
        }
        for (AbstractProp prop : superProps.values()) {
            if (!(prop instanceof UserProp)) continue;
            props.add(prop);
        }
        for (AbstractProp prop : declaredProps.values()) {
            if (!(prop instanceof UserProp)) continue;
            props.add(prop);
        }
        this.validateUnusedNegativePropTokens();
        this.dtoType.setProps(Collections.unmodifiableList(props));
        return this.dtoType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveSuperTypes(LinkedList<DtoTypeBuilder<T, P>> stack) {
        if (this.superTypeBuilders != null) {
            return;
        }
        if (this.superNames.isEmpty()) {
            this.superTypeBuilders = Collections.emptyList();
            return;
        }
        int index = stack.indexOf(this);
        if (index != -1) {
            throw this.ctx.exception(this.name.getLine(), "Illegal circular inheritance: " + stack.subList(index, stack.size()).stream().map(it -> it.name.getText()).collect(Collectors.joining("->")) + "->" + this.name.getText());
        }
        stack.push(this);
        try {
            ArrayList<DtoTypeBuilder<T, P>> superTypeBuilders = new ArrayList<DtoTypeBuilder<T, P>>(this.superNames.size());
            for (Token superName : this.superNames) {
                DtoTypeBuilder<T, P> superTypeBuilder = this.ctx.get(superName.getText());
                if (superTypeBuilder == null) {
                    throw this.ctx.exception(superName.getLine(), "Illegal super dto name \"" + superName.getText() + "\"");
                }
                superTypeBuilders.add(superTypeBuilder);
            }
            this.superTypeBuilders = superTypeBuilders;
        }
        finally {
            stack.pop();
        }
    }

    private Map<String, AbstractProp> resolveDeclaredProps() {
        RecursiveDtoProp<T, P> recursiveDtoProp;
        AbstractProp abstractProp;
        if (this.declaredProps != null) {
            return this.declaredProps;
        }
        LinkedHashMap<String, AbstractProp> declaredPropMap = new LinkedHashMap<String, AbstractProp>();
        for (DtoPropBuilder<T, P> dtoPropBuilder : this.autoScalarPropMap.values()) {
            if (this.isExcluded(dtoPropBuilder.getAlias()) || this.positivePropMap.containsKey(dtoPropBuilder.getBaseProp())) continue;
            AbstractProp dtoProp = dtoPropBuilder.build();
            declaredPropMap.put(dtoProp.getAlias(), dtoProp);
        }
        for (AbstractPropBuilder abstractPropBuilder : this.aliasPositivePropMap.values()) {
            AbstractProp abstractProp2;
            if (this.isExcluded(abstractPropBuilder.getAlias()) || declaredPropMap.containsKey(abstractPropBuilder.getAlias()) || declaredPropMap.put((abstractProp2 = abstractPropBuilder.build()).getAlias(), abstractProp2) == null) continue;
            throw this.ctx.exception(abstractProp2.getAliasLine(), "Duplicated property alias \"" + abstractPropBuilder.getAlias() + "\"");
        }
        for (DtoPropBuilder dtoPropBuilder : this.flatPositiveProps) {
            AbstractProp head = dtoPropBuilder.build();
            Map<String, AbstractProp> deeperProps = super.resolveDeclaredProps();
            for (AbstractProp deeperProp : deeperProps.values()) {
                DtoPropImpl dtoProp = new DtoPropImpl(head, (DtoProp)deeperProp);
                if (this.isExcluded(dtoProp.getAlias()) || declaredPropMap.put(dtoProp.getAlias(), dtoProp) == null) continue;
                throw this.ctx.exception(dtoProp.getAliasLine(), "Duplicated property alias \"" + dtoProp.getAlias() + "\"");
            }
        }
        if (this.recursiveBaseProp != null && (abstractProp = (AbstractProp)declaredPropMap.put((recursiveDtoProp = new RecursiveDtoProp<T, P>(this.recursiveBaseProp, this.recursiveAlias, this.dtoType)).getAlias(), recursiveDtoProp)) != null) {
            throw this.ctx.exception(abstractProp.getAliasLine(), "Duplicated property alias \"" + abstractProp.getAlias() + "\"");
        }
        this.declaredProps = Collections.unmodifiableMap(declaredPropMap);
        return this.declaredProps;
    }

    private boolean isExcluded(String alias) {
        if (!this.negativePropAliasMap.containsKey(alias)) {
            return false;
        }
        this.negativePropAliasMap.put(alias, true);
        return true;
    }

    private void validateUnusedNegativePropTokens() {
        for (Token token : this.negativePropAliasTokens) {
            if (this.negativePropAliasMap.get(token.getText()).booleanValue()) continue;
            throw this.ctx.exception(token.getLine(), "There is no property alias \"" + token.getText() + "\" that is need to be removed");
        }
    }
}

