/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.dto.compiler.TypeRef;

public class Anno {
    private final String qualifiedName;
    private final Map<String, Value> valueMap;

    public Anno(String qualifiedName, Map<String, Value> valueMap) {
        this.qualifiedName = qualifiedName;
        this.valueMap = valueMap;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public Map<String, Value> getValueMap() {
        return this.valueMap;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('@').append(this.qualifiedName);
        if (!this.valueMap.isEmpty()) {
            builder.append('(');
            boolean addComma = false;
            for (Map.Entry<String, Value> e : this.valueMap.entrySet()) {
                if (addComma) {
                    builder.append(", ");
                } else {
                    addComma = true;
                }
                builder.append(e.getKey()).append(" = ").append(e.getValue());
            }
            builder.append(')');
        }
        return builder.toString();
    }

    public static class LiteralValue
    extends Value {
        public final String value;

        public LiteralValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class TypeRefValue
    extends Value {
        public final TypeRef typeRef;

        public TypeRefValue(TypeRef typeRef) {
            this.typeRef = typeRef;
        }

        public String toString() {
            return this.typeRef + ".class";
        }
    }

    public static class EnumValue
    extends Value {
        public final String qualifiedName;
        public final String constant;

        public EnumValue(String qualifiedName, String constant) {
            this.qualifiedName = qualifiedName;
            this.constant = constant;
        }

        public String toString() {
            return this.qualifiedName + '.' + this.constant;
        }
    }

    public static class AnnoValue
    extends Value {
        public final Anno anno;

        public AnnoValue(Anno anno) {
            this.anno = anno;
        }

        public String toString() {
            return this.anno.toString();
        }
    }

    public static class ArrayValue
    extends Value {
        public final List<Value> elements;

        public ArrayValue(List<Value> elements) {
            this.elements = elements;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            boolean addComma = false;
            for (Value element : this.elements) {
                if (addComma) {
                    builder.append(", ");
                } else {
                    addComma = true;
                }
                builder.append(element);
            }
            builder.append(']');
            return builder.toString();
        }
    }

    public static abstract class Value {
    }
}

