/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.babyfish.jimmer.dto.compiler.AbstractProp;
import org.babyfish.jimmer.dto.compiler.Anno;
import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.EnumType;
import org.babyfish.jimmer.dto.compiler.LikeOption;
import org.babyfish.jimmer.dto.compiler.Mandatory;
import org.babyfish.jimmer.dto.compiler.UserProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;
import org.jetbrains.annotations.Nullable;

class DtoPropImpl<T extends BaseType, P extends BaseProp>
implements DtoProp<T, P> {
    private final Map<String, P> basePropMap;
    @Nullable
    private final DtoProp<T, P> nextProp;
    private final int baseLine;
    private final int baseCol;
    @Nullable
    private final String alias;
    private final int aliasLine;
    private final int aliasCol;
    private final List<Anno> annotations;
    @Nullable
    private final String doc;
    private final DtoType<T, P> targetType;
    private final EnumType enumType;
    private final Mandatory mandatory;
    private final String funcName;
    private final boolean recursive;
    private final String basePath;
    private final Set<LikeOption> likeOptions;
    private final DtoProp<T, P> tail;

    DtoPropImpl(Map<String, P> basePropMap, int baseLine, int baseCol, @Nullable String alias, int aliasLine, int aliasCol, List<Anno> annotations, @Nullable String doc, @Nullable DtoType<T, P> targetType, @Nullable EnumType enumType, Mandatory mandatory, String funcName, boolean recursive, Set<LikeOption> likeOptions) {
        this.basePropMap = basePropMap;
        this.nextProp = null;
        this.baseLine = baseLine;
        this.baseCol = baseCol;
        this.annotations = annotations;
        this.doc = doc;
        this.alias = alias;
        this.aliasLine = aliasLine;
        this.aliasCol = aliasCol;
        this.targetType = targetType;
        this.enumType = enumType;
        this.mandatory = mandatory;
        this.funcName = funcName;
        this.recursive = recursive;
        this.basePath = basePropMap.size() == 1 ? this.getBaseProp().getName() : '(' + basePropMap.values().stream().map(BaseProp::getName).collect(Collectors.joining("|")) + ')';
        this.likeOptions = Collections.unmodifiableSet(likeOptions);
        this.tail = this;
    }

    DtoPropImpl(DtoProp<T, P> head, DtoProp<T, P> next) {
        this.basePropMap = head.getBasePropMap();
        this.nextProp = next;
        this.baseLine = next.getBaseLine();
        this.baseCol = next.getBaseColumn();
        this.alias = next.getAlias();
        this.aliasLine = next.getAliasLine();
        this.aliasCol = next.getAliasColumn();
        this.annotations = next.getAnnotations();
        this.doc = next.getDoc();
        this.targetType = next.getTargetType();
        this.enumType = next.getEnumType();
        this.mandatory = head.isNullable() || next.isNullable() ? Mandatory.OPTIONAL : (head.getMandatory() == Mandatory.REQUIRED || next.getMandatory() == Mandatory.REQUIRED ? Mandatory.REQUIRED : Mandatory.DEFAULT);
        this.funcName = next.getFuncName();
        this.recursive = false;
        StringBuilder builder = new StringBuilder();
        if (this.basePropMap.size() == 1) {
            builder.append(((BaseProp)this.basePropMap.values().iterator().next()).getName());
        } else {
            builder.append('(').append(this.basePropMap.values().stream().map(BaseProp::getName).collect(Collectors.joining(", "))).append(')');
        }
        DtoProp<T, P> tail = this;
        for (DtoProp<T, P> n = next; n != null; n = n.getNextProp()) {
            builder.append('.').append(n.getBasePath());
            tail = n;
        }
        this.basePath = builder.toString();
        this.likeOptions = Collections.emptySet();
        this.tail = tail;
    }

    DtoPropImpl(DtoProp<T, P> original, DtoType<T, P> targetType) {
        this.basePropMap = original.getBasePropMap();
        this.nextProp = null;
        this.baseLine = original.getBaseLine();
        this.baseCol = original.getBaseColumn();
        this.annotations = original.getAnnotations();
        this.doc = original.getDoc();
        this.alias = this.getBaseProp().getName();
        this.aliasLine = original.getAliasLine();
        this.aliasCol = original.getAliasColumn();
        this.targetType = targetType;
        this.enumType = null;
        this.mandatory = original.getMandatory();
        this.funcName = "flat";
        this.recursive = false;
        this.basePath = this.getBaseProp().getName();
        this.likeOptions = original.getLikeOptions();
        this.tail = this;
    }

    @Override
    public P getBaseProp() {
        return (P)((BaseProp)this.basePropMap.values().iterator().next());
    }

    @Override
    public Map<String, P> getBasePropMap() {
        return this.basePropMap;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    @Nullable
    public DtoProp<T, P> getNextProp() {
        return this.nextProp;
    }

    @Override
    public DtoProp<T, P> toTailProp() {
        return this.tail;
    }

    @Override
    public int getBaseLine() {
        return this.baseLine;
    }

    @Override
    public int getBaseColumn() {
        return this.baseCol;
    }

    @Override
    public List<Anno> getAnnotations() {
        return this.annotations;
    }

    @Override
    public String getDoc() {
        return this.doc;
    }

    @Override
    public String getName() {
        return this.alias != null ? this.alias : this.getBaseProp().getName();
    }

    @Override
    public int getAliasLine() {
        return this.aliasLine;
    }

    @Override
    public int getAliasColumn() {
        return this.aliasCol;
    }

    @Override
    public boolean isNullable() {
        switch (this.mandatory) {
            case OPTIONAL: {
                return true;
            }
            case REQUIRED: {
                return false;
            }
        }
        return this.isBaseNullable();
    }

    @Override
    public boolean isBaseNullable() {
        for (DtoProp<T, P> p = this; p != null; p = p.getNextProp()) {
            if (!p.getBaseProp().isNullable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Mandatory getMandatory() {
        return this.mandatory;
    }

    @Override
    public boolean isIdOnly() {
        return "id".equals(this.funcName);
    }

    @Override
    public boolean isFlat() {
        return "flat".equals(this.funcName);
    }

    @Override
    @Nullable
    public String getFuncName() {
        return this.funcName;
    }

    @Override
    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @Override
    @Nullable
    public DtoType<T, P> getTargetType() {
        return this.targetType;
    }

    @Override
    @Nullable
    public EnumType getEnumType() {
        return this.enumType;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public Set<LikeOption> getLikeOptions() {
        return this.likeOptions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.doc != null) {
            builder.append("@doc(").append(this.doc.replace("\n", "\\n")).append(')');
        }
        if (this.mandatory == Mandatory.OPTIONAL) {
            builder.append("@optional ");
        } else if (this.mandatory == Mandatory.REQUIRED) {
            builder.append("@required ");
        }
        for (Anno anno : this.annotations) {
            builder.append(anno).append(' ');
        }
        if (this.funcName != null) {
            builder.append(this.funcName).append('(').append(this.basePath).append(')');
        } else {
            builder.append(this.basePath);
        }
        if (this.alias != null && !this.alias.equals(this.tail.getBaseProp().getName())) {
            builder.append(" as ").append(this.alias);
        }
        if (this.targetType != null) {
            builder.append(": ");
            if (this.recursive) {
                builder.append("...");
            } else {
                builder.append(this.targetType);
            }
        }
        return builder.toString();
    }

    static boolean canMerge(AbstractProp p1, AbstractProp p2) {
        if (p1 instanceof DtoProp && p2 instanceof DtoProp) {
            return DtoPropImpl.canMergeDtoProp((DtoProp)p1, (DtoProp)p2);
        }
        if (p1 instanceof UserProp && p2 instanceof UserProp) {
            return DtoPropImpl.canMergeUerProp((UserProp)p1, (UserProp)p2);
        }
        return false;
    }

    private static boolean canMergeDtoProp(DtoProp<?, ?> p1, DtoProp<?, ?> p2) {
        if (p1.isNullable() != p2.isNullable()) {
            return false;
        }
        if (!p1.getBasePath().equals(p2.getBasePath())) {
            return false;
        }
        if (!Objects.equals(p1.getFuncName(), p2.getFuncName())) {
            return false;
        }
        return p1.getTargetType() == null;
    }

    private static boolean canMergeUerProp(UserProp p1, UserProp p2) {
        return p1.equals(p2);
    }
}

