/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoPropImpl;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;
import org.jetbrains.annotations.Nullable;

public class DtoType<T extends BaseType, P extends BaseProp> {
    private final T baseType;
    private final boolean isInput;
    @Nullable
    private final String name;
    @Nullable
    private final String path;
    private List<DtoProp<T, P>> props;
    private List<DtoProp<T, P>> hiddenFlatProps;

    DtoType(T baseType, boolean isInput, @Nullable String name, @Nullable String path) {
        this.baseType = baseType;
        this.isInput = isInput;
        this.name = name;
        this.path = path;
    }

    public T getBaseType() {
        return this.baseType;
    }

    public boolean isInput() {
        return this.isInput;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public List<DtoProp<T, P>> getProps() {
        return this.props;
    }

    public List<DtoProp<T, P>> getHiddenFlatProps() {
        List<DtoProp<T, P>> hfps = this.hiddenFlatProps;
        if (hfps == null) {
            FlatDtoBuilder<T, P> builder = new FlatDtoBuilder<T, P>(this.isInput, null);
            for (DtoProp<T, P> prop : this.props) {
                if (prop.getNextProp() == null) continue;
                builder.add(prop);
            }
            this.hiddenFlatProps = hfps = builder.build().getProps();
        }
        return hfps;
    }

    void setProps(List<DtoProp<T, P>> props) {
        if (props == null) {
            throw new IllegalArgumentException("`props` cannot be null");
        }
        if (this.props != null) {
            throw new IllegalArgumentException("`props` has already been set");
        }
        this.props = props;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isInput) {
            builder.append("input ");
        }
        if (this.name != null) {
            builder.append(this.name).append(' ');
        }
        builder.append('{');
        boolean addComma = false;
        for (DtoProp<T, P> prop : this.props) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            builder.append(prop);
        }
        builder.append('}');
        return builder.toString();
    }

    private class FlatDtoBuilder<T extends BaseType, P extends BaseProp> {
        private final boolean isInput;
        private final DtoProp<T, P> prop;
        private final Map<String, Object> childNodes = new LinkedHashMap<String, Object>();

        FlatDtoBuilder(boolean isInput, DtoProp<T, P> prop) {
            this.isInput = isInput;
            this.prop = prop;
        }

        public void add(DtoProp<T, P> prop) {
            String baseName = prop.getBaseProp().getName();
            if (prop.getNextProp() == null) {
                this.childNodes.put(baseName, prop);
            } else {
                FlatDtoBuilder<T, P> child = (FlatDtoBuilder<T, P>)this.childNodes.get(baseName);
                if (child == null) {
                    child = new FlatDtoBuilder<T, P>(this.isInput, prop);
                    this.childNodes.put(baseName, child);
                }
                child.add(prop.getNextProp());
            }
        }

        public DtoType<T, P> build() {
            List props;
            if (this.childNodes.isEmpty()) {
                props = Collections.emptyList();
            } else {
                props = new ArrayList();
                for (Object child : this.childNodes.values()) {
                    if (child instanceof DtoProp) {
                        props.add((DtoProp)child);
                        continue;
                    }
                    FlatDtoBuilder builder = (FlatDtoBuilder)child;
                    DtoPropImpl<T, P> prop = new DtoPropImpl<T, P>(builder.prop, builder.build());
                    props.add(prop);
                }
                props = Collections.unmodifiableList(props);
            }
            DtoType dtoType = new DtoType(null, this.isInput, null, null);
            dtoType.setProps(props);
            return dtoType;
        }
    }
}

