/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.dto.compiler;

import org.babyfish.jimmer.dto.compiler.DtoProp;
import org.babyfish.jimmer.dto.compiler.DtoType;
import org.babyfish.jimmer.dto.compiler.spi.BaseProp;
import org.babyfish.jimmer.dto.compiler.spi.BaseType;
import org.jetbrains.annotations.Nullable;

class DtoPropImpl<T extends BaseType, P extends BaseProp>
implements DtoProp<T, P> {
    private final P baseProp;
    @Nullable
    private final String alias;
    @Nullable
    private final DtoType<T, P> targetType;
    private final boolean optional;
    private final boolean idOnly;
    private final boolean recursive;

    DtoPropImpl(P baseProp, @Nullable String alias, @Nullable DtoType<T, P> targetType, boolean optional, boolean idOnly, boolean recursive) {
        this.baseProp = baseProp;
        this.alias = alias;
        this.targetType = targetType;
        this.optional = optional;
        this.idOnly = idOnly;
        this.recursive = recursive;
    }

    @Override
    public P getBaseProp() {
        return this.baseProp;
    }

    @Override
    public String getName() {
        return this.alias != null ? this.alias : this.baseProp.getName();
    }

    @Override
    public boolean isNullable() {
        return this.optional || this.baseProp.isNullable();
    }

    @Override
    public boolean isIdOnly() {
        return this.idOnly;
    }

    @Override
    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @Override
    @Nullable
    public DtoType<T, P> getTargetType() {
        return this.targetType;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public boolean isNewTarget() {
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.optional) {
            builder.append("@optional ");
        }
        if (this.idOnly) {
            builder.append("id(").append(this.baseProp.getName()).append(')');
        } else {
            builder.append(this.baseProp.getName());
        }
        if (this.alias != null) {
            builder.append(" as ").append(this.alias);
        }
        if (this.targetType != null) {
            builder.append(": ");
            builder.append(this.targetType);
        }
        return builder.toString();
    }
}

