/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import org.jetbrains.annotations.NotNull;

public final class TypedList<E>
implements List<E>,
RandomAccess {
    private final String sqlElementType;
    private final E[] arr;
    private final int from;
    private final int to;

    public TypedList(String sqlElementType, E[] arr) {
        this.sqlElementType = sqlElementType;
        this.arr = arr;
        this.from = 0;
        this.to = arr != null ? arr.length : 0;
    }

    private TypedList(String sqlElementType, E[] arr, int from, int to) {
        this.sqlElementType = sqlElementType;
        this.arr = arr;
        this.from = from;
        this.to = to;
    }

    public String getSqlElementType() {
        return this.sqlElementType;
    }

    @Override
    public int size() {
        return this.to - this.from;
    }

    @Override
    public boolean isEmpty() {
        return this.to == this.from;
    }

    @Override
    public E get(int index) {
        try {
            return this.arr[this.from + index];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IndexOutOfBoundsException(ex.getMessage());
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = this.from; i < this.to; ++i) {
            if (!Objects.equals(this.arr[i], o)) continue;
            return this.from + i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.to - 1; i >= this.from; --i) {
            if (!Objects.equals(this.arr[i], o)) continue;
            return this.from + i;
        }
        return -1;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        if (this.from == 0 && this.to == this.arr.length) {
            return this.arr;
        }
        return Arrays.copyOfRange(this.arr, this.from, this.to);
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        System.arraycopy(this.arr, this.from, a, 0, Math.min(a.length, this.to - this.from));
        return a;
    }

    @Override
    @Deprecated
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(@NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(int index, @NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Itr(this.from);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return new Itr(this.from);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.to - this.from) {
            throw new IndexOutOfBoundsException();
        }
        return new Itr(this.from + index);
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.to - this.from) {
            throw new IndexOutOfBoundsException();
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("Illegal index range, \"fromIndex\" cannot be greater than \"toIndex\"");
        }
        return new TypedList<E>(this.sqlElementType, this.arr, this.from + fromIndex, this.from + toIndex);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (int i = this.from; i < this.to; ++i) {
            E e = this.arr[i];
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        if (this.to - this.from != other.size()) {
            return false;
        }
        Iterator itr = other.iterator();
        for (int i = this.from; i < this.to; ++i) {
            if (Objects.equals(this.arr[i], itr.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.from == this.to) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (int i = this.from; i < this.to; ++i) {
            E e = this.arr[i];
            builder.append((Object)(e == this ? "(this Collection)" : e));
            if (i + 1 >= this.to) continue;
            builder.append(',').append(' ');
        }
        builder.append(']');
        return builder.toString();
    }

    public class Itr
    implements ListIterator<E> {
        private int index;

        Itr(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < TypedList.this.to;
        }

        @Override
        public E next() {
            if (this.index >= TypedList.this.to) {
                throw new NoSuchElementException();
            }
            return TypedList.this.arr[this.index++];
        }

        @Override
        public boolean hasPrevious() {
            return this.index > TypedList.this.from;
        }

        @Override
        public E previous() {
            if (this.index <= TypedList.this.from) {
                throw new NoSuchElementException();
            }
            return TypedList.this.arr[--this.index];
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

