/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta.impl;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.sql.Column;
import org.babyfish.jimmer.sql.ForeignKeyType;
import org.babyfish.jimmer.sql.JoinColumn;
import org.babyfish.jimmer.sql.JoinColumns;
import org.babyfish.jimmer.sql.JoinTable;
import org.babyfish.jimmer.sql.ManyToMany;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.DatabaseNamingStrategy;
import org.babyfish.jimmer.sql.meta.ForeignKeyStrategy;
import org.babyfish.jimmer.sql.meta.JoinTableFilterInfo;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.MultipleJoinColumns;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.meta.impl.EmbeddedTree;

public class Storages {
    private Storages() {
    }

    public static Storage of(ImmutableProp prop, MetadataStrategy strategy) {
        if (!prop.hasStorage()) {
            return null;
        }
        DatabaseNamingStrategy namingStrategy = strategy.getNamingStrategy();
        Annotation annotation = prop.getAssociationAnnotation();
        if (annotation == null) {
            String columnName;
            if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
                return new EmbeddedTree(prop).toEmbeddedColumns(namingStrategy);
            }
            Column column = prop.getAnnotation(Column.class);
            String string = columnName = column != null ? column.name() : "";
            if (columnName.isEmpty()) {
                columnName = namingStrategy.columnName(prop);
            }
            if (!(column == null || column.sqlElementType().isEmpty() || prop.getReturnClass().isArray() || Collection.class.isAssignableFrom(prop.getReturnClass()))) {
                throw new ModelException("Illegal property \"" + prop + "\", the \"sqlElementType\" of \"@" + Column.class.getName() + "\" cannot be set because is neither array nor collection");
            }
            return new SingleColumn(columnName, false, column != null ? column.sqlElementType() : null);
        }
        Storage storage = Storages.middleTable(prop, strategy, false);
        if (storage == null) {
            storage = Storages.joinColumn(prop, strategy, false);
        }
        if (storage == null) {
            storage = prop.getAssociationAnnotation() instanceof ManyToMany ? Storages.middleTable(prop, strategy, true) : Storages.joinColumn(prop, strategy, true);
        }
        return storage;
    }

    private static ColumnDefinition joinColumn(ImmutableProp prop, MetadataStrategy strategy, boolean force) {
        ColumnDefinition definition;
        JoinColumn joinColumn = prop.getAnnotation(JoinColumn.class);
        JoinColumns joinColumns = prop.getAnnotation(JoinColumns.class);
        if (joinColumn == null && joinColumns == null && !force) {
            return null;
        }
        DatabaseNamingStrategy namingStrategy = strategy.getNamingStrategy();
        ForeignKeyStrategy foreignKeyStrategy = strategy.getForeignKeyStrategy();
        JoinColumnObj[] columns = joinColumns != null ? JoinColumnObj.array(prop, false, joinColumns.value(), foreignKeyStrategy) : JoinColumnObj.array(prop, false, joinColumn, foreignKeyStrategy);
        try {
            definition = Storages.joinDefinition(columns, prop.getTargetType(), strategy);
        }
        catch (IllegalJoinColumnCount ex) {
            throw new ModelException("Illegal property \"" + prop + "\", it has " + ex.actual + " join column(s), but the referenced property \"" + prop.getTargetType().getIdProp() + "\" has " + ex.expect + " join column(s)");
        }
        catch (NoReference ex) {
            throw new ModelException("Illegal property \"" + prop + "\", the `referencedColumnName` of join columns must be set when multiple join columns are used");
        }
        catch (ReferenceNothing ex) {
            throw new ModelException("Illegal property \"" + prop + "\", the `referencedColumnName` \"" + ex.ref + "\" is illegal");
        }
        catch (SourceConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict column name \"" + ex.name + "\" in several join columns");
        }
        catch (TargetConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict referenced column name \"" + ex.ref + "\" in several join columns");
        }
        catch (ForeignKeyConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict columns \"" + ex.columnName1 + "\" and \"" + ex.columnName2 + "\", their attribute `foreignKey` is different");
        }
        if (definition != null) {
            return definition;
        }
        return new SingleColumn(namingStrategy.foreignKeyColumnName(prop), columns != null ? columns[0].isForeignKey : Storages.isForeignKey(prop, false, ForeignKeyType.AUTO, foreignKeyStrategy), null);
    }

    private static MiddleTable middleTable(ImmutableProp prop, MetadataStrategy strategy, boolean force) {
        String tableName;
        ColumnDefinition targetDefinition;
        ColumnDefinition definition;
        JoinColumnObj[] inverseJoinColumns;
        JoinColumnObj[] joinColumns;
        JoinTable joinTable = prop.getAnnotation(JoinTable.class);
        if (joinTable == null && !force) {
            return null;
        }
        DatabaseNamingStrategy namingStrategy = strategy.getNamingStrategy();
        ForeignKeyStrategy foreignKeyStrategy = strategy.getForeignKeyStrategy();
        if (joinTable != null) {
            if (!joinTable.joinColumnName().isEmpty() && joinTable.joinColumns().length != 0) {
                throw new ModelException("Illegal property \"" + prop + "\", `joinColumnName` and `joinColumns` of `@" + JoinTable.class.getName() + "` cannot be specified at the same time");
            }
            if (!joinTable.inverseJoinColumnName().isEmpty() && joinTable.inverseColumns().length != 0) {
                throw new ModelException("Illegal property \"" + prop + "\", `inverseJoinColumnName` and `inverseColumns` of `@" + JoinTable.class.getName() + "` cannot be specified at the same time");
            }
            joinColumns = JoinColumnObj.array(prop, true, joinTable.joinColumnName(), foreignKeyStrategy);
            if (joinColumns == null) {
                joinColumns = JoinColumnObj.array(prop, true, joinTable.joinColumns(), foreignKeyStrategy);
            }
            if ((inverseJoinColumns = JoinColumnObj.array(prop, false, joinTable.inverseJoinColumnName(), foreignKeyStrategy)) == null) {
                inverseJoinColumns = JoinColumnObj.array(prop, false, joinTable.inverseColumns(), foreignKeyStrategy);
            }
        } else {
            joinColumns = null;
            inverseJoinColumns = null;
        }
        boolean leftParsed = false;
        try {
            definition = Storages.joinDefinition(joinColumns, prop.getDeclaringType(), strategy);
            leftParsed = true;
            targetDefinition = Storages.joinDefinition(inverseJoinColumns, prop.getTargetType(), strategy);
        }
        catch (IllegalJoinColumnCount ex) {
            throw new ModelException("Illegal property \"" + prop + "\", there are " + ex.actual + " `" + (leftParsed ? "inverseColumn(s)" : "joinColumn(s)") + "`, but the id property \"" + (leftParsed ? prop.getTargetType() : prop.getDeclaringType()).getIdProp() + "\" has " + ex.expect + " column(s)");
        }
        catch (NoReference ex) {
            throw new ModelException("Illegal property \"" + prop + "\", the `inverseJoinColumns` of `" + (leftParsed ? "inverseColumns" : "joinColumns") + "` must be specified when multiple `" + (leftParsed ? "inverseColumns" : "joinColumns") + "` are used");
        }
        catch (ReferenceNothing ex) {
            throw new ModelException("Illegal property \"" + prop + "\", the `referencedColumnName` \"" + ex.ref + "\" of `" + (leftParsed ? "inverseColumns" : "joinColumns") + "` is illegal");
        }
        catch (SourceConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict column name \"" + ex.name + "\" in several " + (leftParsed ? "inverseColumns" : "joinColumns"));
        }
        catch (TargetConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict referenced column name \"" + ex.ref + "\" in several " + (leftParsed ? "inverseColumns" : "joinColumns"));
        }
        catch (ForeignKeyConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict columns \"" + ex.columnName1 + "\" and \"" + ex.columnName2 + "\" in " + (leftParsed ? "inverseColumns" : "joinColumns") + ", their attribute `foreignKey` is different");
        }
        String string = tableName = joinTable != null ? joinTable.name() : "";
        if (tableName.isEmpty()) {
            tableName = namingStrategy.middleTableName(prop);
        }
        if (definition == null) {
            definition = new SingleColumn(namingStrategy.middleTableBackRefColumnName(prop), joinColumns != null ? joinColumns[0].isForeignKey : Storages.isForeignKey(prop, true, ForeignKeyType.AUTO, foreignKeyStrategy), null);
        }
        if (targetDefinition == null) {
            targetDefinition = new SingleColumn(namingStrategy.middleTableTargetRefColumnName(prop), inverseJoinColumns != null ? inverseJoinColumns[0].isForeignKey : Storages.isForeignKey(prop, false, ForeignKeyType.AUTO, foreignKeyStrategy), null);
        }
        boolean readonly = joinTable != null && joinTable.readonly();
        LogicalDeletedInfo logicalDeletedInfo = LogicalDeletedInfo.of(prop);
        JoinTableFilterInfo filterInfo = JoinTableFilterInfo.of(prop);
        if (joinTable != null && joinTable.deletedWhenEndpointIsLogicallyDeleted() && logicalDeletedInfo != null) {
            throw new ModelException("Illegal property \"" + prop + "\", the \"logicalDeletedFilter\" of \"@" + JoinTable.class + "\" has already been configured so that \"deletedWhenEndpointIsLogicallyDeleted\" cannot be true");
        }
        if (!readonly && filterInfo != null && filterInfo.getValues().size() > 1) {
            throw new ModelException("Illegal property \"" + prop + "\", the \"values\" of \"@" + JoinTable.JoinTableFilter.class.getName() + "\" has multiple values so that the \"readonly\" of \"" + JoinTable.class.getName() + "\" must be true");
        }
        return new MiddleTable(tableName, definition, targetDefinition, readonly, joinTable != null && joinTable.preventDeletionBySource(), joinTable != null && joinTable.preventDeletionByTarget(), joinTable != null && joinTable.deletedWhenEndpointIsLogicallyDeleted(), logicalDeletedInfo, filterInfo);
    }

    private static ColumnDefinition joinDefinition(JoinColumnObj[] joinColumns, ImmutableType targetType, MetadataStrategy strategy) throws IllegalJoinColumnCount, NoReference, ReferenceNothing, TargetConflict, SourceConflict, ForeignKeyConflict {
        if (joinColumns == null || joinColumns.length == 0) {
            ColumnDefinition definition = (ColumnDefinition)targetType.getIdProp().getStorage(strategy);
            if (definition.size() == 1) {
                return null;
            }
            throw new IllegalJoinColumnCount(definition.size(), 0);
        }
        JoinColumnObj firstJoinColumn = null;
        for (JoinColumnObj joinColumn : joinColumns) {
            if (firstJoinColumn == null) {
                firstJoinColumn = joinColumn;
                continue;
            }
            if (firstJoinColumn.isForeignKey == joinColumn.isForeignKey) continue;
            throw new ForeignKeyConflict(firstJoinColumn.name, joinColumn.name);
        }
        ColumnDefinition targetIdDefinition = (ColumnDefinition)targetType.getIdProp().getStorage(strategy);
        if (joinColumns.length != targetIdDefinition.size()) {
            throw new IllegalJoinColumnCount(targetIdDefinition.size(), joinColumns.length);
        }
        if (joinColumns.length == 1) {
            if (joinColumns[0].name.isEmpty()) {
                return null;
            }
            String ref = joinColumns[0].referencedColumnName;
            if (!ref.isEmpty() && !ref.equals(targetIdDefinition.name(0))) {
                throw new ReferenceNothing(ref);
            }
            return new SingleColumn(joinColumns[0].name, joinColumns[0].isForeignKey, null);
        }
        HashMap<String, String> columnMap = new HashMap<String, String>();
        for (JoinColumnObj joinColumn : joinColumns) {
            String ref = joinColumn.referencedColumnName;
            if (ref.isEmpty()) {
                throw new NoReference();
            }
            if (targetIdDefinition.index(ref) == -1) {
                throw new ReferenceNothing(ref);
            }
            if (columnMap.put(ref, joinColumn.name) == null) continue;
            throw new TargetConflict(ref);
        }
        LinkedHashMap<String, String> referencedColumnMap = new LinkedHashMap<String, String>();
        for (String targetColumnName : targetIdDefinition) {
            String name = (String)columnMap.get(targetColumnName);
            if (referencedColumnMap.put(name, targetColumnName) == null) continue;
            throw new SourceConflict(name);
        }
        return new MultipleJoinColumns(referencedColumnMap, targetType.getIdProp().isEmbedded(EmbeddedLevel.SCALAR), joinColumns[0].isForeignKey);
    }

    private static boolean isForeignKey(ImmutableProp prop, boolean backRef, ForeignKeyType foreignKeyType, ForeignKeyStrategy strategy) {
        switch (foreignKeyType) {
            case REAL: {
                if (strategy == ForeignKeyStrategy.FORCED_FAKE) {
                    throw new ModelException("Illegal property \"" + prop + "\", the `foreignKeyType` of any @JoinColumn cannot be `REAL` because this current database dialect does not support foreign key constraint");
                }
                if (!backRef && prop.isRemote()) {
                    throw new ModelException("Illegal property \"" + prop + "\", the `foreignKeyType` of the @JoinColumn pointing to target type cannot be `REAL` because this property is remote association across microservices");
                }
                return true;
            }
            case FAKE: {
                return false;
            }
        }
        return strategy == ForeignKeyStrategy.REAL && (backRef || !prop.isRemote());
    }

    private static class JoinColumnObj {
        final String name;
        final String referencedColumnName;
        final boolean isForeignKey;

        JoinColumnObj(String name, String referencedColumnName, boolean isForeignKey) {
            this.name = name;
            this.referencedColumnName = referencedColumnName;
            this.isForeignKey = isForeignKey;
        }

        static JoinColumnObj[] array(ImmutableProp prop, boolean backRef, String name, ForeignKeyStrategy strategy) {
            if (name.isEmpty()) {
                return null;
            }
            return new JoinColumnObj[]{new JoinColumnObj(name, "", Storages.isForeignKey(prop, backRef, ForeignKeyType.AUTO, strategy))};
        }

        static JoinColumnObj[] array(ImmutableProp prop, boolean backRef, JoinColumn joinColumn, ForeignKeyStrategy strategy) {
            if (joinColumn == null) {
                return null;
            }
            return new JoinColumnObj[]{new JoinColumnObj(joinColumn.name(), joinColumn.referencedColumnName(), Storages.isForeignKey(prop, backRef, joinColumn.foreignKeyType(), strategy))};
        }

        static JoinColumnObj[] array(ImmutableProp prop, boolean backRef, JoinColumn[] arr, ForeignKeyStrategy strategy) {
            if (arr.length == 0) {
                return null;
            }
            return (JoinColumnObj[])Arrays.stream(arr).map(it -> new JoinColumnObj(it.name(), it.referencedColumnName(), Storages.isForeignKey(prop, backRef, it.foreignKeyType(), strategy))).toArray(JoinColumnObj[]::new);
        }
    }

    private static class IllegalJoinColumnCount
    extends Exception {
        final int expect;
        final int actual;

        private IllegalJoinColumnCount(int expect, int actual) {
            this.expect = expect;
            this.actual = actual;
        }
    }

    private static class NoReference
    extends Exception {
        private NoReference() {
        }
    }

    private static class ReferenceNothing
    extends Exception {
        final String ref;

        ReferenceNothing(String ref) {
            this.ref = ref;
        }
    }

    private static class SourceConflict
    extends Exception {
        final String name;

        SourceConflict(String name) {
            this.name = name;
        }
    }

    private static class TargetConflict
    extends Exception {
        final String ref;

        TargetConflict(String ref) {
            this.ref = ref;
        }
    }

    private static class ForeignKeyConflict
    extends Exception {
        final String columnName1;
        final String columnName2;

        private ForeignKeyConflict(String columnName1, String columnName2) {
            this.columnName1 = columnName1;
            this.columnName2 = columnName2;
        }
    }
}

