/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.impl.DatabaseIdentifiers;
import org.jetbrains.annotations.NotNull;

public abstract class MultipleColumns
implements ColumnDefinition {
    protected final String[] arr;
    protected final boolean embedded;

    public MultipleColumns(String[] arr, boolean embedded) {
        if (arr.length > 1 && !embedded) {
            throw new IllegalArgumentException("`embedded` must be true where there are several join columns: " + Arrays.toString(arr));
        }
        this.arr = arr;
        this.embedded = embedded;
    }

    @Override
    public boolean isEmbedded() {
        return this.embedded;
    }

    @Override
    public int size() {
        return this.arr.length;
    }

    @Override
    public String name(int index) {
        return this.arr[index];
    }

    @Override
    public int index(String name) {
        int len = this.arr.length;
        for (int i = 0; i < len; ++i) {
            if (!this.arr[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleColumns that = (MultipleColumns)o;
        return this.embedded == that.embedded && Arrays.equals(this.arr, that.arr);
    }

    public int hashCode() {
        int result = Objects.hash(this.embedded);
        result = 31 * result + Arrays.hashCode(this.arr);
        return result;
    }

    public String toString() {
        return "MultipleColumns{arr=" + Arrays.toString(this.arr) + '}';
    }

    @Override
    public Set<String> toColumnNames() {
        LinkedHashSet<String> set = new LinkedHashSet<String>((this.arr.length * 4 + 2) / 3);
        for (String name : this.arr) {
            set.add(DatabaseIdentifiers.comparableIdentifier(name));
        }
        return set;
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return new Itr(this.arr);
    }

    private static class Itr
    implements Iterator<String> {
        private final String[] arr;
        private int index;

        private Itr(String[] arr) {
            this.arr = arr;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.arr.length;
        }

        @Override
        public String next() {
            if (this.index < this.arr.length) {
                return this.arr[this.index++];
            }
            throw new NoSuchElementException();
        }
    }
}

