/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta;

import java.util.Objects;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.Storage;

public class MiddleTable
implements Storage {
    private final String tableName;
    private final ColumnDefinition definition;
    private final ColumnDefinition targetDefinition;
    private final boolean deletionBySourcePrevented;
    private final boolean deletionByTargetPrevented;
    private MiddleTable inverse;

    public MiddleTable(String tableName, ColumnDefinition definition, ColumnDefinition targetDefinition, boolean deletionBySourcePrevented, boolean deletionByTargetPrevented) {
        this.tableName = tableName;
        this.definition = definition;
        this.targetDefinition = targetDefinition;
        this.deletionBySourcePrevented = deletionBySourcePrevented;
        this.deletionByTargetPrevented = deletionByTargetPrevented;
    }

    public String getTableName() {
        return this.tableName;
    }

    public ColumnDefinition getColumnDefinition() {
        return this.definition;
    }

    public ColumnDefinition getTargetColumnDefinition() {
        return this.targetDefinition;
    }

    public boolean isDeletionBySourcePrevented() {
        return this.deletionBySourcePrevented;
    }

    public boolean isDeletionByTargetPrevented() {
        return this.deletionByTargetPrevented;
    }

    public MiddleTable getInverse() {
        MiddleTable iv = this.inverse;
        if (iv == null) {
            this.inverse = iv = new MiddleTable(this.tableName, this.targetDefinition, this.definition, this.deletionByTargetPrevented, this.deletionBySourcePrevented);
        }
        return iv;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MiddleTable that = (MiddleTable)o;
        return this.deletionBySourcePrevented == that.deletionBySourcePrevented && this.deletionByTargetPrevented == that.deletionByTargetPrevented && this.tableName.equals(that.tableName) && this.definition.equals(that.definition) && this.targetDefinition.equals(that.targetDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.definition, this.targetDefinition, this.deletionBySourcePrevented, this.deletionByTargetPrevented);
    }
}

