/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractIdViewList<E, ID>
implements List<ID> {
    final ImmutableType entityType;
    final PropId idPropId;
    final List<E> entityList;

    public AbstractIdViewList(ImmutableType entityType, List<E> entityList) {
        this.entityType = entityType;
        this.idPropId = entityType.getIdProp().getId();
        this.entityList = entityList;
    }

    @Override
    public boolean isEmpty() {
        return this.entityList.isEmpty();
    }

    @Override
    public int size() {
        return this.entityList.size();
    }

    @Override
    public boolean contains(Object o) {
        for (E entity : this.entityList) {
            if (!this.toId(entity).equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object target : c) {
            if (this.contains(target)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object o) {
        ListIterator<E> itr = this.entityList.listIterator(0);
        while (itr.hasNext()) {
            if (!itr.next().equals(o)) continue;
            return itr.nextIndex() - 1;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        ListIterator<E> itr = this.entityList.listIterator(this.entityList.size());
        while (itr.hasPrevious()) {
            if (!itr.previous().equals(o)) continue;
            return itr.previousIndex() + 1;
        }
        return -1;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] arr = new Object[this.entityList.size()];
        int index = 0;
        for (E entity : this.entityList) {
            arr[index++] = this.toId(entity);
        }
        return arr;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        int size = this.entityList.size();
        if (size > a.length) {
            a = new Object[size];
        }
        int index = 0;
        for (E entity : this.entityList) {
            a[index++] = this.toId(entity);
        }
        return a;
    }

    @Override
    public ID get(int index) {
        return this.toId(this.entityList.get(index));
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E entity : this.entityList) {
            hashCode = 31 * hashCode + this.toId(entity).hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (this.entityList.size() != ((List)o).size()) {
            return false;
        }
        Iterator<E> entityItr = this.entityList.iterator();
        Iterator otherItr = ((List)o).iterator();
        while (entityItr.hasNext() && otherItr.hasNext()) {
            if (this.toId(entityItr.next()).equals(otherItr.next())) continue;
            return false;
        }
        return !entityItr.hasNext() && !otherItr.hasNext();
    }

    public String toString() {
        Iterator<E> itr = this.entityList.iterator();
        if (!itr.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            E entity = itr.next();
            sb.append(this.toId(entity));
            if (!itr.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    ID toId(E entity) {
        return (ID)((ImmutableSpi)entity).__get(this.idPropId);
    }

    static abstract class Itr<E, ID>
    implements ListIterator<ID> {
        final AbstractIdViewList<E, ID> owner;
        final ListIterator<E> itr;

        Itr(AbstractIdViewList<E, ID> owner, ListIterator<E> itr) {
            this.owner = owner;
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public ID next() {
            return this.owner.toId(this.itr.next());
        }

        @Override
        public boolean hasPrevious() {
            return this.itr.hasPrevious();
        }

        @Override
        public ID previous() {
            return this.owner.toId(this.itr.previous());
        }

        @Override
        public int nextIndex() {
            return this.itr.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.itr.previousIndex();
        }
    }
}

