/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.jackson.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.babyfish.jimmer.jackson.impl.JacksonUtils;
import org.babyfish.jimmer.jackson.impl.PropNameConverter;
import org.babyfish.jimmer.jackson.meta.BeanProps;
import org.babyfish.jimmer.jackson.meta.ConverterMetadata;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;

public class ImmutableSerializer
extends StdSerializer<ImmutableSpi> {
    private final ImmutableType immutableType;
    private final PropNameConverter propNameConverter;

    public ImmutableSerializer(ImmutableType immutableType, PropNameConverter propNameConverter) {
        super(immutableType.getJavaClass());
        this.immutableType = immutableType;
        this.propNameConverter = propNameConverter;
    }

    public void serialize(ImmutableSpi value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        this.serializeFields(value, gen, provider);
        gen.writeEndObject();
    }

    public void serializeWithType(ImmutableSpi value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefix(gen, typeSer.typeId((Object)value, JsonToken.START_OBJECT));
        this.serializeFields(value, gen, serializers);
        gen.writeEndObject();
    }

    private void serializeFields(ImmutableSpi immutable, JsonGenerator gen, SerializerProvider provider) throws IOException {
        for (ImmutableProp prop : this.immutableType.getProps().values()) {
            JsonIgnore ignore = prop.getAnnotation(JsonIgnore.class);
            if (ignore != null && ignore.value() || !immutable.__isLoaded(prop.getId()) || !immutable.__isVisible(prop.getId())) continue;
            Object value = immutable.__get(prop.getId());
            ConverterMetadata metadata = prop.getConverterMetadata();
            if (value != null && metadata != null) {
                value = metadata.getConverter().output(value);
            }
            if (value == null) {
                provider.defaultSerializeField(this.propNameConverter.fieldName(prop), null, gen);
                continue;
            }
            if (prop.isAssociation(TargetLevel.OBJECT) || prop.isScalarList()) {
                gen.writeFieldName(this.propNameConverter.fieldName(prop));
                TypeSerializer typeSer = null;
                if (!prop.isReferenceList(TargetLevel.OBJECT) && value instanceof ImmutableSpi && ((ImmutableSpi)value).__type() != this.immutableType) {
                    typeSer = provider.findTypeSerializer(JacksonUtils.getJacksonType(prop));
                }
                if (typeSer != null) {
                    provider.findValueSerializer(value.getClass()).serializeWithType(value, gen, provider, typeSer);
                    continue;
                }
                provider.findValueSerializer(JacksonUtils.getJacksonType(prop)).serialize(value, gen, provider);
                continue;
            }
            gen.writeFieldName(this.propNameConverter.fieldName(prop));
            JsonSerializer serializer = prop.getConverterMetadata() == null ? (prop.getGenericType() instanceof Class ? provider.findValueSerializer(prop.getReturnClass(), (BeanProperty)BeanProps.get(provider.getTypeFactory(), prop)) : provider.findValueSerializer(JacksonUtils.getJacksonType(prop), (BeanProperty)BeanProps.get(provider.getTypeFactory(), prop))) : provider.findValueSerializer(prop.getConverterMetadata().getTargetJacksonType(), (BeanProperty)BeanProps.get(provider.getTypeFactory(), prop));
            serializer.serialize(value, gen, provider);
        }
    }
}

