/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.error;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import org.babyfish.jimmer.error.CodeBasedException;
import org.babyfish.jimmer.error.CodeBasedRuntimeException;
import org.babyfish.jimmer.impl.util.ClassCache;
import org.babyfish.jimmer.internal.ClientException;
import org.babyfish.jimmer.meta.ModelException;

class ClientExceptionMetadata {
    private static final Cache CACHE = new Cache(ClientExceptionMetadata::create);
    private final Class<?> exceptionType;
    private final String family;
    private final String code;
    private final ClientExceptionMetadata superMetadata;
    private List<ClientExceptionMetadata> subMetadatas;

    private ClientExceptionMetadata(Class<?> exceptionType, String family, String code, ClientExceptionMetadata superMetadata) {
        this.exceptionType = exceptionType;
        this.family = family;
        this.code = code;
        this.superMetadata = superMetadata;
    }

    public String getFamily() {
        return this.family;
    }

    public String getCode() {
        return this.code;
    }

    public ClientExceptionMetadata getSuperMetadata() {
        return this.superMetadata;
    }

    public List<ClientExceptionMetadata> getSubMetadatas() {
        return this.subMetadatas;
    }

    public static ClientExceptionMetadata of(Class<?> exceptionType) {
        return (ClientExceptionMetadata)CACHE.get(exceptionType);
    }

    private static ClientExceptionMetadata create(Class<?> type) {
        String family;
        ClientException sce;
        if (!CodeBasedException.class.isAssignableFrom(type) && !CodeBasedRuntimeException.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Illegal type \"" + type.getName() + "\" extends neither \"" + CodeBasedException.class.getName() + "\" nor \"" + CodeBasedRuntimeException.class.getName() + "\"");
        }
        ClientException ce = type.getAnnotation(ClientException.class);
        if (ce == null) {
            throw new ModelException("Illegal type \"" + type.getName() + "\", the exception type extends \"" + CodeBasedException.class.getName() + "\" or \"" + CodeBasedRuntimeException.class.getName() + "\" must be decorated by \"@" + ClientException.class.getName() + "\"");
        }
        String code = ce.code();
        Class<?>[] subTypes = ce.subTypes();
        if (code.isEmpty() && subTypes.length == 0) {
            throw new ModelException("Illegal type \"" + type.getName() + "\", it is decorated by @\"" + ClientException.class.getName() + "\" but neither \"code\" nor \"subTypes\" of the annotation is specified");
        }
        if (!code.isEmpty() && subTypes.length != 0) {
            throw new ModelException("Illegal type \"" + type.getName() + "\", it is decorated by @\"" + ClientException.class.getName() + "\" but both \"code\" and \"subTypes\" of the annotation are specified");
        }
        if (!code.isEmpty() && Modifier.isAbstract(type.getModifiers())) {
            throw new ModelException("Illegal type \"" + type.getName() + "\", it is decorated by @\"" + ClientException.class.getName() + "\" and the \"code\" of the annotation is specified so that it cannot be abstract");
        }
        if (subTypes.length != 0 && !Modifier.isAbstract(type.getModifiers())) {
            throw new ModelException("Illegal type \"" + type.getName() + "\", it is decorated by @\"" + ClientException.class.getName() + "\" and the \"subTypes\" of the annotation is specified so that it must be abstract");
        }
        Class<?> superType = type.getSuperclass();
        ClientExceptionMetadata superMetadata = null;
        if (superType != CodeBasedException.class && superType != CodeBasedRuntimeException.class && (sce = superType.getAnnotation(ClientException.class)) != null) {
            boolean match = false;
            for (Class<?> bacRefType : sce.subTypes()) {
                if (bacRefType != type) continue;
                match = true;
                break;
            }
            if (!match) {
                throw new ModelException("Illegal type \"" + type.getName() + "\", its super type \"" + superType.getName() + "\" is decorated by " + ClientException.class.getName() + "\" but the \"subTypes\" of the annotation does not contain current type");
            }
            superMetadata = CACHE.internallyGet(superType);
        }
        if ((family = ce.family()).isEmpty()) {
            family = superMetadata != null ? superMetadata.family : "DEFAULT";
        } else if (superMetadata != null && !superMetadata.getFamily().equals(family)) {
            throw new ModelException("Illegal type \"" + type.getName() + "\", its family is \"" + family + "\" but the family of super exception is \"" + superMetadata.getFamily() + "\"");
        }
        return new ClientExceptionMetadata(type, family, code.isEmpty() ? null : code, superMetadata);
    }

    void init() {
        ClientException ce = this.exceptionType.getAnnotation(ClientException.class);
        Class<?>[] subTypes = ce.subTypes();
        LinkedHashSet<ClientExceptionMetadata> metadataSet = new LinkedHashSet<ClientExceptionMetadata>((subTypes.length * 4 + 2) / 3);
        for (Class<?> subType : subTypes) {
            if (subType.getSuperclass() != this.exceptionType) {
                throw new ModelException("Illegal type \"" + this.exceptionType.getName() + "\", it is decorated by \"@" + ClientException.class.getName() + "\" which specifies the sub type \"" + subType.getName() + "\", but the super type of that sub type is not current type");
            }
            if (subType.getAnnotation(ClientException.class) == null) {
                throw new ModelException("Illegal type \"" + this.exceptionType.getName() + "\", it is decorated by \"@" + ClientException.class.getName() + "\" which specifies the sub type \"" + subType.getName() + "\", but that sub type is not decorated by \"@" + ClientException.class.getName() + "\"");
            }
            metadataSet.add(CACHE.internallyGet(subType));
        }
        this.subMetadatas = Collections.unmodifiableList(new ArrayList(metadataSet));
    }

    private static class Cache
    extends ClassCache<ClientExceptionMetadata> {
        public Cache(Function<Class<?>, ClientExceptionMetadata> creator) {
            super(creator, false);
        }

        ClientExceptionMetadata internallyGet(Class<?> type) {
            return (ClientExceptionMetadata)this.getWithoutLock(type);
        }

        @Override
        protected void onCreated(Class<?> key, ClientExceptionMetadata value) {
            value.init();
        }
    }
}

