/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class Doc {
    private final String value;
    private final Map<String, String> parameterValueMap;
    private final String returnValue;
    private final Map<String, String> propertyValueMap;
    private String toString;

    @JsonCreator
    public Doc(String value, Map<String, String> parameterValueMap, String returnValue, Map<String, String> propertyValueMap) {
        this.value = value;
        this.parameterValueMap = parameterValueMap == null || parameterValueMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(parameterValueMap);
        this.returnValue = returnValue;
        this.propertyValueMap = propertyValueMap == null || propertyValueMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(propertyValueMap);
    }

    public String getValue() {
        return this.value;
    }

    public Map<String, String> getParameterValueMap() {
        return this.parameterValueMap;
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    public Map<String, String> getPropertyValueMap() {
        return this.propertyValueMap;
    }

    public String toString() {
        String str = this.toString;
        if (str == null) {
            this.toString = str = this.toStringImpl();
        }
        return str;
    }

    private String toStringImpl() {
        StringBuilder builder = new StringBuilder();
        if (this.value != null) {
            builder.append(this.value).append('\n');
        }
        for (Map.Entry<String, String> e : this.parameterValueMap.entrySet()) {
            builder.append("@param ").append(e.getKey()).append(' ').append(e.getValue()).append('\n');
        }
        for (Map.Entry<String, String> e : this.propertyValueMap.entrySet()) {
            builder.append("@property ").append(e.getKey()).append(' ').append(e.getValue()).append('\n');
        }
        if (this.returnValue != null) {
            builder.append("@return ").append(this.returnValue).append('\n');
        }
        return builder.toString();
    }

    public static Doc parse(String doc) {
        if (doc != null) {
            doc = doc.trim();
        }
        if (doc == null || doc.isEmpty()) {
            return null;
        }
        Builder builder = new Builder();
        try (BufferedReader reader = new BufferedReader(new StringReader(doc));){
            String line;
            while ((line = reader.readLine()) != null) {
                int rest;
                int end;
                int begin;
                int start = Doc.indexOfNonWhiteSpace(line, 0);
                if (start == -1) {
                    builder.append(line);
                    continue;
                }
                if (line.startsWith("@param", start) && Character.isWhitespace(line.charAt(start + 6))) {
                    begin = Doc.indexOfNonWhiteSpace(line, start + 6);
                    if (begin != -1) {
                        end = Doc.indexOfWhiteSpace(line, begin + 1);
                        if (end == -1) {
                            builder.switchToParam(line.substring(begin));
                            continue;
                        }
                        builder.switchToParam(line.substring(begin, end));
                        rest = Doc.indexOfNonWhiteSpace(line, end);
                        if (rest != -1) {
                            builder.append(line.substring(rest));
                            continue;
                        }
                        builder.append(line.substring(end));
                        continue;
                    }
                    int rest2 = Doc.indexOfNonWhiteSpace(line, start + 6);
                    if (rest2 != -1) {
                        builder.append(line.substring(rest2));
                        continue;
                    }
                    builder.append(line.substring(start + 6));
                    continue;
                }
                if (line.startsWith("@property", start) && Character.isWhitespace(line.charAt(start + 9))) {
                    begin = Doc.indexOfNonWhiteSpace(line, start + 9);
                    if (begin != -1) {
                        end = Doc.indexOfWhiteSpace(line, begin + 1);
                        if (end == -1) {
                            builder.switchToProperty(line.substring(begin));
                            continue;
                        }
                        builder.switchToProperty(line.substring(begin, end));
                        rest = Doc.indexOfNonWhiteSpace(line, end);
                        if (rest != -1) {
                            builder.append(line.substring(rest));
                            continue;
                        }
                        builder.append(line.substring(end));
                        continue;
                    }
                    builder.append(line.substring(start + 9));
                    continue;
                }
                if (line.startsWith("@return", start)) {
                    begin = Doc.indexOfNonWhiteSpace(line, start + 7);
                    builder.switchToReturn();
                    if (begin != -1) {
                        builder.append(line.substring(begin));
                        continue;
                    }
                    builder.append(line.substring(start + 7));
                    continue;
                }
                if (line.startsWith("@", start)) {
                    builder.switchToIgnored();
                    continue;
                }
                if (line.charAt(0) <= ' ') {
                    builder.append(line.substring(1));
                    continue;
                }
                builder.append(line);
            }
        }
        catch (IOException ex) {
            throw new AssertionError((Object)"Cannot parse documentation comment");
        }
        return builder.build();
    }

    public static String valueOf(@Nullable Doc doc) {
        return doc != null ? doc.getValue() : null;
    }

    public static String returnOf(@Nullable Doc doc) {
        return doc != null ? doc.getReturnValue() : null;
    }

    public static String paramOf(@Nullable Doc doc, String param) {
        return doc != null ? doc.getParameterValueMap().get(param) : null;
    }

    public static String propertyOf(@Nullable Doc doc, String property) {
        return doc != null ? doc.getPropertyValueMap().get(property) : null;
    }

    private static int indexOfNonWhiteSpace(String line, int start) {
        int size = line.length();
        for (int i = start; i < size; ++i) {
            if (line.charAt(i) <= ' ') continue;
            return i;
        }
        return -1;
    }

    private static int indexOfWhiteSpace(String line, int start) {
        int size = line.length();
        for (int i = start; i < size; ++i) {
            if (line.charAt(i) > ' ') continue;
            return i;
        }
        return -1;
    }

    private static class Builder {
        private String value;
        private final Map<String, String> parameterValueMap = new LinkedHashMap<String, String>();
        private final Map<String, String> propertyValueMap = new LinkedHashMap<String, String>();
        private String returnValue;
        private String currentParamName;
        private String currentPropertyName;
        private boolean currentReturn;
        private boolean currentIgnored;
        private StringBuilder sb = new StringBuilder();

        private Builder() {
        }

        public void switchToParam(String name) {
            this.commit();
            this.currentParamName = name != null ? name : "<unknown>";
        }

        public void switchToProperty(String name) {
            this.commit();
            this.currentPropertyName = name != null ? name : "<unknown>";
        }

        public void switchToReturn() {
            this.commit();
            this.currentReturn = true;
        }

        public void switchToIgnored() {
            this.commit();
            this.currentIgnored = false;
        }

        public void append(String text) {
            if (!this.currentIgnored) {
                this.sb.append(text).append('\n');
            }
        }

        public Doc build() {
            this.commit();
            return new Doc(this.value != null && !this.value.isEmpty() ? this.value : null, this.parameterValueMap, this.returnValue != null && !this.returnValue.isEmpty() ? this.returnValue : null, this.propertyValueMap);
        }

        private void commit() {
            if (this.sb.length() != 0 && this.sb.charAt(this.sb.length() - 1) == '\n') {
                this.sb.setLength(this.sb.length() - 1);
            }
            if (this.currentParamName != null) {
                this.parameterValueMap.put(this.currentParamName, this.sb.toString());
                this.currentParamName = null;
            } else if (this.currentPropertyName != null) {
                this.propertyValueMap.put(this.currentPropertyName, this.sb.toString());
                this.currentPropertyName = null;
            } else if (this.currentReturn) {
                this.returnValue = this.sb.toString();
                this.currentReturn = false;
            } else if (!this.currentIgnored) {
                this.value = this.sb.toString();
            }
            this.sb = new StringBuilder();
        }
    }

    public static class Deserializer
    extends JsonDeserializer<Doc> {
        private static final JavaType DOC_MAP_TYPE = MapType.construct(LinkedHashMap.class, null, null, null, (JavaType)SimpleType.constructUnsafe(String.class), (JavaType)SimpleType.constructUnsafe(String.class));

        public Doc deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JacksonException {
            JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
            String value = jsonNode.has("value") ? jsonNode.get("value").asText() : null;
            Map<String, String> parameters = jsonNode.has("parameters") ? Collections.unmodifiableMap((Map)ctx.readTreeAsValue(jsonNode.get("parameters"), DOC_MAP_TYPE)) : Collections.emptyMap();
            String returnValue = jsonNode.has("return") ? jsonNode.get("return").asText() : null;
            Map<String, String> properties = jsonNode.has("properties") ? Collections.unmodifiableMap((Map)ctx.readTreeAsValue(jsonNode.get("properties"), DOC_MAP_TYPE)) : Collections.emptyMap();
            return new Doc(value, parameters, returnValue, properties);
        }
    }

    public static class Serializer
    extends JsonSerializer<Doc> {
        public void serialize(Doc doc, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            if (doc.getValue() != null) {
                provider.defaultSerializeField("value", (Object)doc.getValue(), gen);
            }
            if (!doc.getParameterValueMap().isEmpty()) {
                provider.defaultSerializeField("parameters", doc.getParameterValueMap(), gen);
            }
            if (doc.getReturnValue() != null) {
                provider.defaultSerializeField("return", (Object)doc.getReturnValue(), gen);
            }
            if (!doc.getPropertyValueMap().isEmpty()) {
                provider.defaultSerializeField("properties", doc.getPropertyValueMap(), gen);
            }
            gen.writeEndObject();
        }
    }
}

