/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;

public class MetaCache<T> {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Function<MetadataStrategy, T> creator;
    private MetadataStrategy primaryKey;
    private T primaryValue;
    private Map<MetadataStrategy, T> otherMap;

    public MetaCache(Function<MetadataStrategy, T> creator) {
        this.creator = creator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(MetadataStrategy strategy) {
        T value;
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            value = strategy.equals(this.primaryKey) ? this.primaryValue : (this.otherMap != null ? this.otherMap.get(strategy) : null);
        }
        finally {
            lock.unlock();
        }
        if (value == null) {
            lock = this.readWriteLock.writeLock();
            lock.lock();
            try {
                Object object = strategy.equals(this.primaryKey) ? this.primaryValue : (value = this.otherMap != null ? this.otherMap.get(strategy) : null);
                if (value == null) {
                    value = this.creator.apply(strategy);
                    if (value == null) {
                        throw new AssertionError((Object)"Internal bug: creator of MetaCache cannot return null");
                    }
                    if (this.primaryKey == null) {
                        this.primaryKey = strategy;
                        this.primaryValue = value;
                    } else {
                        Map<MetadataStrategy, T> om = this.otherMap;
                        if (om == null) {
                            om = new HashMap<MetadataStrategy, T>();
                            this.otherMap = om;
                        }
                        om.put(strategy, value);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        return value;
    }
}

