/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.EnumConstant;
import org.babyfish.jimmer.client.meta.Prop;
import org.babyfish.jimmer.client.meta.TypeDefinition;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.babyfish.jimmer.client.meta.impl.AstNode;
import org.babyfish.jimmer.client.meta.impl.AstNodeVisitor;
import org.babyfish.jimmer.client.meta.impl.EnumConstantImpl;
import org.babyfish.jimmer.client.meta.impl.PropImpl;
import org.babyfish.jimmer.client.meta.impl.Schemas;
import org.babyfish.jimmer.client.meta.impl.TypeRefImpl;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class TypeDefinitionImpl<S>
extends AstNode<S>
implements TypeDefinition {
    private final TypeName typeName;
    private TypeDefinition.Kind kind;
    private TypeDefinition.Error error;
    private boolean apiIgnore;
    private List<String> groups = Collections.emptyList();
    private final Map<String, PropImpl<S>> propMap = new LinkedHashMap<String, PropImpl<S>>();
    private final List<TypeRefImpl<S>> superTypes = new ArrayList<TypeRefImpl<S>>();
    private Doc doc;
    private final Map<String, EnumConstantImpl<S>> enumConstantMap = new LinkedHashMap<String, EnumConstantImpl<S>>();

    TypeDefinitionImpl(S source, TypeName typeName) {
        super(source);
        this.typeName = typeName;
    }

    @Override
    public TypeName getTypeName() {
        return this.typeName;
    }

    @Override
    public TypeDefinition.Kind getKind() {
        return this.kind;
    }

    public void setKind(TypeDefinition.Kind kind) {
        this.kind = kind;
    }

    @Override
    @Nullable
    public Doc getDoc() {
        return this.doc;
    }

    public void setDoc(Doc doc) {
        this.doc = doc;
    }

    @Override
    @Nullable
    public TypeDefinition.Error getError() {
        return this.error;
    }

    public void setError(TypeDefinition.Error error) {
        this.error = error;
    }

    @Override
    public boolean isApiIgnore() {
        return this.apiIgnore;
    }

    @Override
    @Nullable
    public List<String> getGroups() {
        return this.groups;
    }

    public void mergeGroups(List<String> groups) {
        if (this.groups == null) {
            return;
        }
        if (groups == null) {
            this.groups = null;
            return;
        }
        ArrayList<String> merged = new ArrayList<String>(this.groups);
        merged.addAll(groups);
        this.groups = merged.stream().distinct().collect(Collectors.toList());
    }

    public void setApiIgnore(boolean apiIgnore) {
        this.apiIgnore = apiIgnore;
    }

    @Override
    public Map<String, Prop> getPropMap() {
        return this.propMap;
    }

    public void addProp(PropImpl<S> prop) {
        this.propMap.put(prop.getName(), prop);
    }

    @Override
    public List<TypeRef> getSuperTypes() {
        return this.superTypes;
    }

    public void addSuperType(TypeRefImpl<S> superType) {
        this.superTypes.add(superType);
    }

    @Override
    public Map<String, EnumConstant> getEnumConstantMap() {
        return this.enumConstantMap;
    }

    public void addEnumConstant(EnumConstantImpl<S> constant) {
        this.enumConstantMap.put(constant.getName(), constant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(AstNodeVisitor<S> visitor) {
        visitor.visitAstNode(this);
        try {
            for (PropImpl<S> propImpl : this.propMap.values()) {
                propImpl.accept(visitor);
            }
            for (TypeRefImpl typeRefImpl : this.superTypes) {
                typeRefImpl.accept(visitor);
            }
        }
        finally {
            visitor.visitedAstNode(this);
        }
    }

    public String toString() {
        return "TypeDefinitionImpl{typeName='" + this.typeName + '\'' + ", propMap=" + this.propMap + ", superTypes=" + this.superTypes + '}';
    }

    public static class Deserializer
    extends JsonDeserializer<TypeDefinitionImpl<?>> {
        private static final JavaType GROUPS_TYPE = CollectionType.construct(List.class, null, null, null, (JavaType)SimpleType.constructUnsafe(String.class));

        public TypeDefinitionImpl<?> deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JacksonException {
            JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
            TypeDefinitionImpl<Object> definition = new TypeDefinitionImpl<Object>(null, (TypeName)ctx.readTreeAsValue(jsonNode.get("typeName"), TypeName.class));
            if (jsonNode.has("groups")) {
                definition.mergeGroups(Collections.unmodifiableList((List)ctx.readTreeAsValue(jsonNode.get("groups"), GROUPS_TYPE)));
                if (!Schemas.isAllowed(ctx, definition.getGroups())) {
                    return definition;
                }
            }
            if (jsonNode.has("kind")) {
                definition.setKind(TypeDefinition.Kind.valueOf(jsonNode.get("kind").asText()));
            }
            if (jsonNode.has("doc")) {
                definition.setDoc((Doc)ctx.readTreeAsValue(jsonNode.get("doc"), Doc.class));
            }
            if (jsonNode.has("error")) {
                definition.setError((TypeDefinition.Error)ctx.readTreeAsValue(jsonNode.get("error"), TypeDefinition.Error.class));
            }
            if (jsonNode.has("apiIgnore")) {
                definition.setApiIgnore(jsonNode.get("apiIgnore").asBoolean());
            }
            if (jsonNode.has("props")) {
                for (JsonNode propNode : jsonNode.get("props")) {
                    definition.addProp((PropImpl)ctx.readTreeAsValue(propNode, PropImpl.class));
                }
            }
            if (jsonNode.has("superTypes")) {
                for (JsonNode superNode : jsonNode.get("superTypes")) {
                    definition.addSuperType((TypeRefImpl)ctx.readTreeAsValue(superNode, TypeRefImpl.class));
                }
            }
            if (jsonNode.has("constants")) {
                for (JsonNode propNode : jsonNode.get("constants")) {
                    definition.addEnumConstant((EnumConstantImpl)ctx.readTreeAsValue(propNode, EnumConstantImpl.class));
                }
            }
            return definition;
        }
    }

    public static class Serializer
    extends JsonSerializer<TypeDefinitionImpl<?>> {
        public void serialize(TypeDefinitionImpl<?> definition, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            provider.defaultSerializeField("typeName", (Object)definition.getTypeName(), gen);
            if (definition.getKind() != TypeDefinition.Kind.OBJECT) {
                gen.writeFieldName("kind");
                gen.writeString(definition.getKind().name());
            }
            if (definition.getDoc() != null) {
                provider.defaultSerializeField("doc", (Object)definition.getDoc(), gen);
            }
            if (definition.getError() != null) {
                provider.defaultSerializeField("error", (Object)definition.getError(), gen);
            }
            if (definition.isApiIgnore()) {
                gen.writeFieldName("apiIgnore");
                gen.writeBoolean(true);
            }
            if (definition.getGroups() != null) {
                provider.defaultSerializeField("groups", definition.getGroups(), gen);
            }
            if (!definition.getPropMap().isEmpty()) {
                provider.defaultSerializeField("props", definition.getPropMap().values(), gen);
            }
            if (!definition.getSuperTypes().isEmpty()) {
                provider.defaultSerializeField("superTypes", definition.getSuperTypes(), gen);
            }
            if (!definition.getEnumConstantMap().isEmpty()) {
                provider.defaultSerializeField("constants", definition.getEnumConstantMap().values(), gen);
            }
            gen.writeEndObject();
        }
    }
}

