/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta.impl;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.babyfish.jimmer.sql.meta.SqlContext;

public class SqlContextCache<T> {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Function<SqlContext, T> creator;
    private SqlContext primaryKey;
    private T primaryValue;
    private Map<SqlContext, T> otherMap;

    public SqlContextCache(Function<SqlContext, T> creator) {
        this.creator = creator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(SqlContext strategy) {
        T value;
        Object unwrapped = strategy.unwrap();
        if (unwrapped != null) {
            strategy = unwrapped;
        }
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            value = strategy.equals(this.primaryKey) ? this.primaryValue : (this.otherMap != null ? this.otherMap.get(strategy) : null);
        }
        finally {
            lock.unlock();
        }
        if (value == null) {
            lock = this.readWriteLock.writeLock();
            lock.lock();
            try {
                Map<SqlContext, T> om = this.otherMap;
                if (om != null && om.size() > 512) {
                    om = null;
                    this.otherMap = null;
                }
                Object object = strategy.equals(this.primaryKey) ? this.primaryValue : (value = om != null ? om.get(strategy) : null);
                if (value == null) {
                    value = this.creator.apply(strategy);
                    if (value == null) {
                        throw new AssertionError((Object)"Internal bug: creator of MetaCache cannot return null");
                    }
                    if (this.primaryKey == null) {
                        this.primaryKey = strategy;
                        this.primaryValue = value;
                    } else {
                        if (om == null) {
                            om = new WeakHashMap<SqlContext, T>();
                            this.otherMap = om;
                        }
                        om.put(strategy, value);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        return value;
    }
}

