/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.impl.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.babyfish.jimmer.impl.util.LRUMap;
import org.babyfish.jimmer.meta.ImmutableType;

public class TypeCache<V> {
    private final Function<ImmutableType, V> creator;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final Map<ImmutableType, V> positiveMap = new HashMap<ImmutableType, V>();
    private final Map<String, V> positiveMap2 = new HashMap<String, V>();
    private final Map<ImmutableType, Void> negativeMap;
    private final Map<String, Void> negativeMap2;

    public TypeCache(Function<ImmutableType, V> creator) {
        this(creator, false);
    }

    public TypeCache(Function<ImmutableType, V> creator, boolean nullable) {
        this.creator = creator;
        this.negativeMap = nullable ? new LRUMap() : null;
        this.negativeMap2 = nullable ? new LRUMap() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(ImmutableType key) {
        V value;
        block18: {
            String keyString = key != null ? key.toString() : null;
            Lock lock = this.cacheLock.readLock();
            lock.lock();
            try {
                if (this.negativeMap != null && this.negativeMap.containsKey(key)) {
                    V v = null;
                    return v;
                }
                if (this.negativeMap2 != null && this.negativeMap2.containsKey(keyString)) {
                    this.negativeMap.put(key, null);
                }
                if ((value = this.positiveMap.get(key)) == null && (value = this.positiveMap2.get(keyString)) != null) {
                    this.positiveMap.put(key, value);
                }
            }
            finally {
                lock.unlock();
            }
            if (value == null) {
                lock = this.cacheLock.writeLock();
                lock.lock();
                try {
                    if (this.negativeMap != null && this.negativeMap.containsKey(key)) {
                        V v = null;
                        return v;
                    }
                    if (this.negativeMap2 != null && this.negativeMap2.containsKey(keyString)) {
                        this.negativeMap.put(key, null);
                    }
                    if ((value = this.positiveMap.get(key)) != null) break block18;
                    value = this.positiveMap2.get(keyString);
                    if (value != null) {
                        this.positiveMap.put(key, value);
                        break block18;
                    }
                    value = this.creator.apply(key);
                    if (value != null) {
                        this.positiveMap.put(key, value);
                        this.positiveMap2.put(keyString, value);
                        break block18;
                    }
                    if (this.negativeMap != null) {
                        this.negativeMap.put(key, null);
                        this.negativeMap2.put(keyString, null);
                        break block18;
                    }
                    throw new IllegalStateException("The creator cannot return null because current type cache does not accept null values");
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return value;
    }
}

