/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.jackson.impl;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.babyfish.jimmer.impl.util.StaticCache;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;

public class PropNameConverter {
    private final Map<ImmutableProp, String> fieldNameMap;
    private final Map<ImmutableProp, List<String>> aliasesMap;
    private static final StaticCache<Key, PropNameConverter> CACHE = new StaticCache<Key, PropNameConverter>(PropNameConverter::create, false);

    private PropNameConverter(Map<ImmutableProp, String> fieldNameMap, Map<ImmutableProp, List<String>> aliasesMap) {
        this.fieldNameMap = fieldNameMap;
        this.aliasesMap = aliasesMap;
    }

    public static PropNameConverter of(MapperConfig<?> cfg, ImmutableType type) {
        return CACHE.get(new Key(cfg, Objects.requireNonNull(type, "`type` cannot be null")));
    }

    /*
     * WARNING - void declaration
     */
    private static PropNameConverter create(Key key) {
        void var7_18;
        HashMap<ImmutableProp, String> fieldNameMap;
        MapperConfig<?> cfg = key.config;
        PropertyNamingStrategy strategy = cfg.getPropertyNamingStrategy();
        HashMap<void, ImmutableProp> propMap = new HashMap<void, ImmutableProp>();
        if (strategy != null && !(strategy instanceof PropertyNamingStrategies.NamingBase)) {
            throw new IllegalArgumentException("property naming strategy that does not inherit \"" + PropertyNamingStrategies.NamingBase.class + "\" cannot be supported by jimmer jackson module");
        }
        PropertyNamingStrategies.NamingBase namingBase = (PropertyNamingStrategies.NamingBase)strategy;
        for (ImmutableProp immutableProp : key.type.getProps().values()) {
            void var7_10;
            ImmutableProp conflictProp;
            JsonProperty jsonProperty = immutableProp.getAnnotation(JsonProperty.class);
            if (jsonProperty != null && !jsonProperty.value().equals("")) {
                String string = jsonProperty.value();
            } else {
                if (namingBase == null) continue;
                String string = namingBase.translate(immutableProp.getName());
            }
            if ((conflictProp = propMap.put(var7_10, immutableProp)) == null) continue;
            throw new IllegalArgumentException("Same json field name \"" + (String)var7_10 + "\" for both \"" + immutableProp + "\" and \"" + conflictProp + "\"");
        }
        if (propMap.isEmpty()) {
            fieldNameMap = null;
        } else {
            fieldNameMap = new HashMap<ImmutableProp, String>((propMap.size() * 4 + 2) / 3);
            for (Map.Entry entry : propMap.entrySet()) {
                fieldNameMap.put((ImmutableProp)entry.getValue(), (String)entry.getKey());
            }
        }
        HashMap<String, ImmutableProp> hashMap = new HashMap<String, ImmutableProp>();
        for (ImmutableProp prop : key.type.getProps().values()) {
            JsonAlias jsonAlias = prop.getAnnotation(JsonAlias.class);
            if (jsonAlias == null) continue;
            for (String alias : jsonAlias.value()) {
                ImmutableProp conflictProp;
                if (alias.isEmpty() || (conflictProp = hashMap.put(alias, prop)) == null) continue;
                throw new IllegalArgumentException("Same json alias \"" + alias + "\" translated by property naming strategy for both \"" + prop + "\" and \"" + conflictProp + "\"");
            }
        }
        if (hashMap.isEmpty()) {
            Object var7_16 = null;
        } else {
            HashMap<ImmutableProp, List> hashMap2 = new HashMap<ImmutableProp, List>();
            for (Map.Entry e : hashMap.entrySet()) {
                hashMap2.computeIfAbsent((ImmutableProp)e.getValue(), it -> new ArrayList()).add((String)e.getKey());
            }
        }
        return new PropNameConverter(fieldNameMap, (Map<ImmutableProp, List<String>>)var7_18);
    }

    public String fieldName(ImmutableProp prop) {
        if (this.fieldNameMap == null) {
            return prop.getName();
        }
        String fieldName = this.fieldNameMap.get(prop);
        return fieldName != null ? fieldName : prop.getName();
    }

    public List<String> aliases(ImmutableProp prop) {
        if (this.aliasesMap == null) {
            return Collections.emptyList();
        }
        List<String> aliases = this.aliasesMap.get(prop);
        return aliases != null ? Collections.unmodifiableList(aliases) : Collections.emptyList();
    }

    private static class Key {
        final MapperConfig<?> config;
        final ImmutableType type;

        private Key(MapperConfig<?> config, ImmutableType type) {
            this.config = config;
            this.type = type;
        }

        public int hashCode() {
            return Objects.hash(this.config, this.type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return this.config.equals(key.config) && this.type.equals(key.type);
        }

        public String toString() {
            return "Key{strategy=" + this.config + ", type=" + this.type + '}';
        }
    }
}

