/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta;

import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.babyfish.jimmer.impl.util.GenericValidator;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.LogicalDeleted;
import org.babyfish.jimmer.sql.meta.LogicalDeletedUUIDGenerator;
import org.babyfish.jimmer.sql.meta.LogicalDeletedValueGenerator;

public final class LogicalDeletedInfo {
    private static final Map<Class<?>, Supplier<Object>> NOW_SUPPLIER_MAP;
    private final ImmutableProp prop;
    private final Action action;
    private final Object value;
    private final Class<? extends LogicalDeletedValueGenerator<?>> generatorType;
    private final String generatorRef;

    private LogicalDeletedInfo(ImmutableProp prop, Action action, Object value, Class<? extends LogicalDeletedValueGenerator<?>> generatorType, String generatorRef) {
        this.prop = prop;
        this.action = action;
        this.value = value;
        this.generatorType = generatorType;
        this.generatorRef = generatorRef;
    }

    public LogicalDeletedInfo to(ImmutableProp prop) {
        if (this.prop == prop) {
            return this;
        }
        return new LogicalDeletedInfo(this, prop);
    }

    private LogicalDeletedInfo(LogicalDeletedInfo base, ImmutableProp prop) {
        if (!base.prop.getName().equals(prop.getName()) || !base.prop.getDeclaringType().isAssignableFrom(prop.getDeclaringType())) {
            throw new IllegalArgumentException("\"" + prop + "\" does not hide \"" + base.prop + "\"");
        }
        this.prop = prop;
        this.action = base.action;
        this.value = base.value;
        this.generatorType = base.generatorType;
        this.generatorRef = base.generatorRef;
    }

    public ImmutableProp getProp() {
        return this.prop;
    }

    public Action getAction() {
        return this.action;
    }

    public Object generateValue() {
        if (this.generatorType != null || this.generatorRef != null) {
            throw new AssertionError((Object)"Internal bug, cannot generate value, please use generator");
        }
        if (this.value instanceof Supplier) {
            return ((Supplier)this.value).get();
        }
        return this.value;
    }

    public Class<? extends LogicalDeletedValueGenerator<?>> getGeneratorType() {
        return this.generatorType;
    }

    public String getGeneratorRef() {
        return this.generatorRef;
    }

    public String toString() {
        return "LogicalDeletedInfo{prop=" + this.prop + ", action=" + this.action + ", value=" + this.value + '}';
    }

    public static LogicalDeletedInfo of(ImmutableProp prop) {
        String generatorRef;
        Class<LogicalDeletedValueGenerator<Object>> generatorType;
        String valueText;
        LogicalDeleted deleted = prop.getAnnotation(LogicalDeleted.class);
        if (deleted == null) {
            return null;
        }
        Class<?> returnType = prop.getElementClass();
        if (prop.isAssociation(TargetLevel.OBJECT) || returnType != Boolean.TYPE && returnType != Integer.TYPE && returnType != Long.TYPE && returnType != Long.class && returnType != UUID.class && !returnType.isEnum() && !NOW_SUPPLIER_MAP.containsKey(returnType)) {
            throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` so that it type must be boolean, integer, enum, long, long, uuid or time");
        }
        if (NOW_SUPPLIER_MAP.containsKey(returnType)) {
            if (!prop.isNullable()) {
                throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` and returns \"" + returnType.getName() + "\" so that it must be nullable");
            }
        } else if (returnType != Long.TYPE && returnType != Long.class && returnType != UUID.class && prop.isNullable()) {
            throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` and returns \"" + returnType.getName() + "\" so that it cannot be nullable");
        }
        if ((valueText = deleted.value()).isEmpty()) {
            valueText = null;
        }
        if ((generatorType = deleted.generatorType()) == LogicalDeletedValueGenerator.None.class) {
            generatorType = null;
        }
        if ((generatorRef = deleted.generatorRef()).isEmpty()) {
            generatorRef = null;
        }
        if (valueText != null && generatorType != null) {
            throw new ModelException("Illegal property \"" + prop + "\", `value` and `generatorType` of `@LogicalDeleted` cannot be specified at the same time");
        }
        if (valueText != null && generatorRef != null) {
            throw new ModelException("Illegal property \"" + prop + "\", `value` and `generatorRef` of `@LogicalDeleted` cannot be specified at the same time");
        }
        if (generatorType != null && generatorRef != null) {
            throw new ModelException("Illegal property \"" + prop + "\", `generatorType` and `generatorRef` of `@LogicalDeleted` cannot be specified at the same time");
        }
        if (returnType == Long.TYPE || returnType == Long.class || returnType == UUID.class) {
            if (valueText != null) {
                throw new ModelException("Illegal property \"" + prop + "\", the property returns \"" + returnType + "\" does not require `value` of `@LogicalDeleted`");
            }
            if (generatorType != null) {
                new GenericValidator(prop, LogicalDeleted.class, generatorType, LogicalDeletedValueGenerator.class).expect(0, (Type)((Object)UUID.class)).validate();
            }
            if (generatorType == null && generatorRef == null) {
                if (returnType == UUID.class) {
                    generatorType = LogicalDeletedUUIDGenerator.class;
                } else {
                    throw new ModelException("Illegal property \"" + prop + "\", the property returns \"" + returnType + "\" requires `generatorType` or `generatorRef` of `@LogicalDeleted`");
                }
            }
            if (prop.isNullable()) {
                return new LogicalDeletedInfo(prop, Action.IsNull.INSTANCE, null, generatorType, generatorRef);
            }
            Comparable<UUID> notDeletedValue = returnType == UUID.class ? UUID.fromString("00000000-0000-0000-0000-000000000000") : Long.valueOf(0L);
            return new LogicalDeletedInfo(prop, new Action.Eq(notDeletedValue), null, generatorType, generatorRef);
        }
        if (deleted.value().isEmpty()) {
            throw new ModelException("Illegal property \"" + prop + "\", the property returns \"" + returnType + "\" requires `value` of `@LogicalDeleted`");
        }
        Object value = LogicalDeletedInfo.parseValue(prop, deleted.value());
        Action action = prop.isNullable() ? (value != null ? Action.IsNull.INSTANCE : Action.IsNotNull.INSTANCE) : new Action.Ne(value);
        return new LogicalDeletedInfo(prop, action, value, null, null);
    }

    private static Object parseValue(ImmutableProp prop, String value) {
        Class<?> type = prop.getElementClass();
        if (type == Boolean.TYPE) {
            switch (value) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` and its type is boolean, but the `value` is \"" + value + "\" is neither \"true\" nor \"false\"");
        }
        if (type == Integer.TYPE) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` and its type is int, but the `value` is \"" + value + "\" which is not a valid integer");
            }
        }
        if (type.isEnum()) {
            Enum[] constants;
            for (Enum constant : constants = (Enum[])type.getEnumConstants()) {
                if (!constant.name().equals(value)) continue;
                return constant;
            }
            throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` and its type is the enum type \"" + type.getName() + "\", but the `value` is \"" + value + "\" which is not any one of: " + Arrays.stream(constants).map(Enum::name).collect(Collectors.toList()));
        }
        switch (value) {
            case "null": {
                return null;
            }
            case "now": {
                return NOW_SUPPLIER_MAP.get(type);
            }
        }
        throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` and its type is the time type \"" + type.getName() + "\", but the `value` is \"" + value + "\" which is neither \"null\" or \"now\"");
    }

    static {
        HashMap map = new HashMap();
        map.put(java.util.Date.class, java.util.Date::new);
        map.put(Date.class, () -> new Date(System.currentTimeMillis()));
        map.put(Time.class, () -> new Timestamp(System.currentTimeMillis()));
        map.put(Timestamp.class, () -> new Timestamp(System.currentTimeMillis()));
        map.put(LocalDateTime.class, LocalDateTime::now);
        map.put(LocalDate.class, LocalDate::now);
        map.put(LocalTime.class, LocalTime::now);
        map.put(OffsetDateTime.class, OffsetDateTime::now);
        map.put(ZonedDateTime.class, ZonedDateTime::now);
        NOW_SUPPLIER_MAP = map;
    }

    public static abstract class Action {
        Action() {
        }

        public abstract Action reversed();

        public static class IsNotNull
        extends Action {
            static final IsNotNull INSTANCE = new IsNotNull();

            private IsNotNull() {
            }

            @Override
            public Action reversed() {
                return IsNull.INSTANCE;
            }
        }

        public static class IsNull
        extends Action {
            static final IsNull INSTANCE = new IsNull();

            private IsNull() {
            }

            @Override
            public Action reversed() {
                return IsNotNull.INSTANCE;
            }
        }

        public static class Ne
        extends Action {
            private final Object value;
            private Action reversed;

            Ne(Object value) {
                this.value = value;
            }

            public Object getValue() {
                return this.value;
            }

            @Override
            public Action reversed() {
                if (this.reversed == null) {
                    this.reversed = new Eq(this.value);
                }
                return this.reversed;
            }
        }

        public static class Eq
        extends Action {
            private final Object value;
            private Action reversed;

            Eq(Object value) {
                this.value = value;
            }

            public Object getValue() {
                return this.value;
            }

            @Override
            public Action reversed() {
                if (this.reversed == null) {
                    this.reversed = new Ne(this.value);
                }
                return this.reversed;
            }
        }
    }
}

