/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.babyfish.jimmer.client.meta.ApiService;
import org.babyfish.jimmer.client.meta.Schema;
import org.babyfish.jimmer.client.meta.TypeDefinition;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.meta.impl.ApiServiceImpl;
import org.babyfish.jimmer.client.meta.impl.AstNode;
import org.babyfish.jimmer.client.meta.impl.AstNodeVisitor;
import org.babyfish.jimmer.client.meta.impl.Schemas;
import org.babyfish.jimmer.client.meta.impl.TypeDefinitionImpl;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class SchemaImpl<S>
extends AstNode<S>
implements Schema {
    private Map<String, ApiServiceImpl<S>> apiServiceMap;
    private Map<TypeName, TypeDefinitionImpl<S>> typeDefinitionMap = new TreeMap<TypeName, TypeDefinitionImpl<S>>();

    SchemaImpl() {
        this(null);
    }

    SchemaImpl(Map<String, ApiServiceImpl<S>> apiServiceMap) {
        super(null);
        this.apiServiceMap = apiServiceMap != null ? apiServiceMap : new TreeMap();
    }

    SchemaImpl(Map<String, ApiServiceImpl<S>> apiServiceMap, Map<TypeName, TypeDefinitionImpl<S>> typeDefinitionMap) {
        this.apiServiceMap = apiServiceMap;
        this.typeDefinitionMap = typeDefinitionMap;
    }

    @Override
    public Map<String, ApiService> getApiServiceMap() {
        return this.apiServiceMap;
    }

    @Override
    public Map<TypeName, TypeDefinition> getTypeDefinitionMap() {
        return this.typeDefinitionMap;
    }

    public void addApiService(ApiServiceImpl<S> apiService) {
        this.apiServiceMap.put(apiService.getTypeName(), apiService);
    }

    public void addTypeDefinition(TypeDefinitionImpl<S> typeDefinition) {
        this.typeDefinitionMap.put(typeDefinition.getTypeName(), typeDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(AstNodeVisitor<S> visitor) {
        visitor.visitAstNode(this);
        try {
            for (ApiServiceImpl<S> apiService : this.apiServiceMap.values()) {
                apiService.accept(visitor);
            }
        }
        finally {
            visitor.visitedAstNode(this);
        }
    }

    public String toString() {
        return "SchemaImpl{apiServiceMap=" + this.apiServiceMap + ", typeDefinitionMap=" + this.typeDefinitionMap + '}';
    }

    public static class Deserializer
    extends JsonDeserializer<SchemaImpl<?>> {
        public SchemaImpl<?> deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JacksonException {
            JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
            SchemaImpl schema = new SchemaImpl();
            for (JsonNode serviceNode : jsonNode.get("services")) {
                schema.addApiService((ApiServiceImpl)ctx.readTreeAsValue(serviceNode, ApiServiceImpl.class));
            }
            if (ctx.getAttribute(Schemas.IGNORE_DEFINITIONS) == null) {
                for (JsonNode definitionNode : jsonNode.get("definitions")) {
                    schema.addTypeDefinition((TypeDefinitionImpl)ctx.readTreeAsValue(definitionNode, TypeDefinitionImpl.class));
                }
            }
            return schema;
        }
    }

    public static class Serializer
    extends JsonSerializer<SchemaImpl<?>> {
        public void serialize(SchemaImpl<?> schema, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            provider.defaultSerializeField("services", schema.getApiServiceMap().values(), gen);
            provider.defaultSerializeField("definitions", schema.getTypeDefinitionMap().values(), gen);
            gen.writeEndObject();
        }
    }
}

