/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.client.meta.ApiOperation;
import org.babyfish.jimmer.client.meta.ApiService;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.impl.ApiOperationImpl;
import org.babyfish.jimmer.client.meta.impl.AstNode;
import org.babyfish.jimmer.client.meta.impl.AstNodeVisitor;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class ApiServiceImpl<S>
extends AstNode<S>
implements ApiService {
    private String typeName;
    private List<String> groups;
    private List<ApiOperationImpl<S>> operations = new ArrayList<ApiOperationImpl<S>>();
    private Doc doc;

    ApiServiceImpl(S source, String typeName) {
        super(source);
        this.typeName = typeName;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    @Nullable
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups == null || groups.isEmpty() ? null : Collections.unmodifiableList(groups);
    }

    @Override
    public List<ApiOperation> getOperations() {
        return this.operations;
    }

    @Override
    @Nullable
    public ApiOperation findOperation(String name, Class<?> ... types) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(name);
        for (Class<?> type : types) {
            keyBuilder.append(':').append(type.getName());
        }
        String key = keyBuilder.toString();
        for (ApiOperationImpl<S> operation : this.operations) {
            if (!operation.key().equals(key)) continue;
            return operation;
        }
        return null;
    }

    public void addOperation(ApiOperationImpl<S> operation) {
        this.operations.add(operation);
    }

    @Override
    @Nullable
    public Doc getDoc() {
        return this.doc;
    }

    public void setDoc(Doc doc) {
        this.doc = doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(AstNodeVisitor<S> visitor) {
        visitor.visitAstNode(this);
        try {
            for (ApiOperationImpl<S> operation : this.operations) {
                operation.accept(visitor);
            }
        }
        finally {
            visitor.visitedAstNode(this);
        }
    }

    public String toString() {
        return this.typeName;
    }

    @JsonValue
    public String value() {
        return "<api>";
    }

    public static class Deserializer
    extends JsonDeserializer<ApiServiceImpl<?>> {
        private static final CollectionType GROUPS_TYPE = CollectionType.construct(List.class, null, null, null, (JavaType)SimpleType.constructUnsafe(String.class));

        public ApiServiceImpl<?> deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JacksonException {
            JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
            ApiServiceImpl<Object> service = new ApiServiceImpl<Object>(null, jsonNode.get("typeName").asText());
            if (jsonNode.has("groups")) {
                service.setGroups(Collections.unmodifiableList((List)ctx.readTreeAsValue(jsonNode.get("groups"), (JavaType)GROUPS_TYPE)));
            }
            if (jsonNode.has("doc")) {
                service.setDoc((Doc)ctx.readTreeAsValue(jsonNode.get("doc"), Doc.class));
            }
            if (jsonNode.has("operations")) {
                for (JsonNode operationNode : jsonNode.get("operations")) {
                    service.addOperation((ApiOperationImpl)ctx.readTreeAsValue(operationNode, ApiOperationImpl.class));
                }
            }
            return service;
        }
    }

    public static class Serializer
    extends JsonSerializer<ApiServiceImpl<?>> {
        public void serialize(ApiServiceImpl<?> service, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName("typeName");
            gen.writeString(service.getTypeName());
            if (service.getGroups() != null) {
                provider.defaultSerializeField("groups", service.getGroups(), gen);
            }
            if (service.getDoc() != null) {
                provider.defaultSerializeField("doc", (Object)service.getDoc(), gen);
            }
            if (!service.getOperations().isEmpty()) {
                provider.defaultSerializeField("operations", service.getOperations(), gen);
            }
            gen.writeEndObject();
        }
    }
}

