/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.impl.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ModelException;

public class GenericValidator {
    private final ImmutableProp prop;
    private final Class<? extends Annotation> annotationType;
    private final Class<?> configImplType;
    private final Class<?> configItfType;
    private final TypeVariable<?>[] parameters;
    private final Map<Integer, Expected> expectedMap = new TreeMap<Integer, Expected>();

    public GenericValidator(ImmutableProp prop, Class<? extends Annotation> annotationType, Class<?> configImplType, Class<?> configItfType) {
        if (configImplType.isInterface() || !configItfType.isAssignableFrom(configImplType)) {
            this.ex("it is not a class implements \"" + configItfType.getName() + "\"");
        }
        if (configImplType.getTypeParameters().length != 0) {
            this.ex("it has type parameters");
        }
        TypeVariable<Class<?>>[] parameters = configItfType.getTypeParameters();
        this.prop = prop;
        this.annotationType = annotationType;
        this.configImplType = configImplType;
        this.configItfType = configItfType;
        this.parameters = parameters;
    }

    public GenericValidator expect(int typeParameterIndex, Type type) {
        return this.expect(typeParameterIndex, type, false);
    }

    public GenericValidator expect(int typeParameterIndex, Type type, boolean allowSubType) {
        if (typeParameterIndex < 0 || typeParameterIndex >= this.parameters.length) {
            throw new IllegalArgumentException("The argument \"genericParameterIndex\" must between 0 and " + (this.parameters.length - 1));
        }
        if (type instanceof Class) {
            Class clazz = type;
            type = Classes.boxTypeOf(clazz);
        }
        this.expectedMap.put(typeParameterIndex, new Expected(typeParameterIndex, type, allowSubType));
        return this;
    }

    public void validate() {
        Map argumentMap = TypeUtils.getTypeArguments(this.configImplType, this.configItfType);
        for (Expected expected : this.expectedMap.values()) {
            Type actualType = (Type)argumentMap.get(this.parameters[expected.typeParameterIndex]);
            if (actualType == null) {
                this.ex("\"that type does not specify type arguments for \"" + this.configItfType.getName() + "\"");
            }
            if (expected.allowSubType) {
                if (TypeUtils.isAssignable((Type)actualType, (Type)expected.type)) continue;
                this.ex("that type specifies the type arguments[" + expected.typeParameterIndex + "] of \"" + this.configItfType.getName() + "\" as \"" + actualType + "\" which is cannot be assigned to the type \"" + expected.type + "\"");
                continue;
            }
            if (expected.type.equals(actualType)) continue;
            this.ex("that type specifies the type arguments[" + expected.typeParameterIndex + "] of \"" + this.configItfType.getName() + "\" as \"" + actualType + "\" which is not the expected type \"" + expected.type + "\"");
        }
    }

    private void ex(String message) {
        throw new ModelException("Illegal property \"" + this.prop + "\", it does not accept the type \"" + this.configImplType.getName() + "\" configured by the annotation \"@" + this.annotationType.getName() + "\", " + message);
    }

    private static class Expected {
        final int typeParameterIndex;
        final Type type;
        final boolean allowSubType;

        private Expected(int typeParameterIndex, Type type, boolean allowSubType) {
            this.typeParameterIndex = typeParameterIndex;
            this.type = type;
            this.allowSubType = allowSubType;
        }
    }
}

