/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta;

import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.EnumConstant;
import org.babyfish.jimmer.client.meta.Prop;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.jetbrains.annotations.Nullable;

public interface TypeDefinition {
    public TypeName getTypeName();

    public Kind getKind();

    public boolean isApiIgnore();

    @Nullable
    public Doc getDoc();

    @Nullable
    public Error getError();

    @Nullable
    public List<String> getGroups();

    public Map<String, Prop> getPropMap();

    public List<TypeRef> getSuperTypes();

    public Map<String, EnumConstant> getEnumConstantMap();

    public static final class Error {
        private final String family;
        private final String code;

        public Error(String family, String code) {
            this.family = family;
            this.code = code;
        }

        public String getFamily() {
            return this.family;
        }

        public String getCode() {
            return this.code;
        }

        public int hashCode() {
            int result = this.family.hashCode();
            result = 31 * result + this.code.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Error error = (Error)o;
            if (!this.family.equals(error.family)) {
                return false;
            }
            return this.code.equals(error.code);
        }

        public String toString() {
            return "Error{family='" + this.family + '\'' + ", code='" + this.code + '\'' + '}';
        }
    }

    public static enum Kind {
        IMMUTABLE,
        OBJECT,
        ENUM;

    }
}

