/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.security.Principal;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.babyfish.jimmer.client.meta.ApiOperation;
import org.babyfish.jimmer.client.meta.ApiParameter;
import org.babyfish.jimmer.client.meta.ApiService;
import org.babyfish.jimmer.client.meta.Schema;
import org.babyfish.jimmer.client.meta.TypeDefinition;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.meta.impl.ApiOperationImpl;
import org.babyfish.jimmer.client.meta.impl.ApiParameterImpl;
import org.babyfish.jimmer.client.meta.impl.ApiServiceImpl;
import org.babyfish.jimmer.client.meta.impl.AstNode;
import org.babyfish.jimmer.client.meta.impl.EnumConstantImpl;
import org.babyfish.jimmer.client.meta.impl.PropImpl;
import org.babyfish.jimmer.client.meta.impl.SchemaImpl;
import org.babyfish.jimmer.client.meta.impl.TypeDefinitionImpl;
import org.babyfish.jimmer.client.meta.impl.TypeDefinitionVisitor;
import org.babyfish.jimmer.client.meta.impl.TypeRefImpl;
import org.jetbrains.annotations.Nullable;

public abstract class SchemaBuilder<S> {
    private static final Set<String> IGNORED_PARAMETER_TYPES;
    private static final Set<String> ILLEGAL_PARAMETER_TYPES;
    private LinkedList<AstNode<S>> stack = new LinkedList();

    public SchemaBuilder(Schema original) {
        Map<String, ApiService> serviceMap = null;
        if (original != null) {
            serviceMap = original.getApiServiceMap();
            serviceMap = new TreeMap<String, ApiService>(serviceMap);
            serviceMap.keySet().removeIf(s -> this.loadSource((String)s) == null);
        }
        SchemaImpl schema = new SchemaImpl(serviceMap);
        this.stack.push(schema);
    }

    public <X extends AstNode<S>> X ancestor(Class<?> type) {
        for (AstNode astNode : this.stack) {
            if (astNode.getClass() != type) continue;
            return (X)astNode;
        }
        return null;
    }

    @SafeVarargs
    public final S ancestorSource(Class<? extends AstNode> ... types) {
        for (AstNode astNode : this.stack) {
            if (astNode.getSource() == null) continue;
            if (types.length == 0) {
                return astNode.getSource();
            }
            for (Class<? extends AstNode> otherType : types) {
                if (astNode.getClass() != otherType) continue;
                return astNode.getSource();
            }
        }
        return null;
    }

    public <X extends AstNode<S>> X current() {
        return (X)this.stack.peek();
    }

    public void api(S source, String className, Consumer<ApiServiceImpl<S>> block) {
        this.run(new ApiServiceImpl<S>(source, className), block);
    }

    public void operation(S source, String name, Consumer<ApiOperationImpl<S>> block) {
        this.run(new ApiOperationImpl<S>(source, name), block);
    }

    public void parameter(S source, String name, Consumer<ApiParameterImpl<S>> block) {
        this.run(new ApiParameterImpl<S>(source, name), block);
    }

    public void typeRef(Consumer<TypeRefImpl<S>> block) {
        this.run(new TypeRefImpl(), block);
    }

    public void definition(S source, TypeName typeName, Consumer<TypeDefinitionImpl<S>> block) {
        this.run(new TypeDefinitionImpl<S>(source, typeName), block);
    }

    public void prop(S source, String name, Consumer<PropImpl<S>> block) {
        this.run(new PropImpl<S>(source, name), block);
    }

    public void constant(S source, String name, Consumer<EnumConstantImpl<S>> block) {
        this.run(new EnumConstantImpl<S>(source, name), block);
    }

    private <X extends AstNode<S>> void run(X child, Consumer<X> block) {
        this.stack.push(child);
        try {
            block.accept(child);
        }
        finally {
            this.stack.pop();
        }
    }

    public void push(AstNode<S> child) {
        this.stack.push(child);
    }

    public void pop() {
        this.stack.pop();
    }

    public Schema build() {
        this.resolve();
        this.unnecessaryPart();
        return (Schema)((Object)this.stack.peek());
    }

    @Nullable
    protected abstract S loadSource(String var1);

    protected abstract void throwException(S var1, String var2);

    protected abstract void fillDefinition(S var1);

    private void resolve() {
        SchemaImpl schema = (SchemaImpl)this.current();
        schema.accept(new TypeDefinitionVisitor(this));
    }

    private void unnecessaryPart() {
        SchemaImpl schema = (SchemaImpl)this.current();
        for (ApiService service : schema.getApiServiceMap().values()) {
            for (ApiOperation operation : service.getOperations()) {
                List<ApiParameter> parameters = operation.getParameters();
                parameters.removeIf(parameter -> {
                    TypeDefinition typeDefinition;
                    if (IGNORED_PARAMETER_TYPES.contains(parameter.getType().getTypeName().toString())) {
                        return true;
                    }
                    if (ILLEGAL_PARAMETER_TYPES.contains(parameter.getType().getTypeName().toString())) {
                        this.throwException(parameter.getSource(), "The parameter whose type \"" + parameter.getType() + "\" is not supported by jimmer client code generation, please use \"@ApiIgnore\" to decorate \"" + operation + "\" of \"" + service + "\"");
                    }
                    return (typeDefinition = schema.getTypeDefinitionMap().get(parameter.getType().getTypeName())) != null && typeDefinition.isApiIgnore();
                });
            }
        }
    }

    static {
        HashSet<String> ignoredParameterTypes = new HashSet<String>();
        ignoredParameterTypes.add("javax.servlet.http.HttpServletRequest");
        ignoredParameterTypes.add("javax.servlet.http.ServletRequest");
        ignoredParameterTypes.add("javax.servlet.http.HttpServletResponse");
        ignoredParameterTypes.add("javax.servlet.http.ServletResponse");
        ignoredParameterTypes.add("jakarta.servlet.http.HttpServletRequest");
        ignoredParameterTypes.add("jakarta.servlet.http.ServletRequest");
        ignoredParameterTypes.add("jakarta.servlet.http.HttpServletResponse");
        ignoredParameterTypes.add("jakarta.servlet.http.ServletResponse");
        ignoredParameterTypes.add(Principal.class.getName());
        IGNORED_PARAMETER_TYPES = ignoredParameterTypes;
        HashSet<String> illegalParameterTypes = new HashSet<String>();
        illegalParameterTypes.add("org.springframework.web.multipart.MultipartFile");
        ILLEGAL_PARAMETER_TYPES = illegalParameterTypes;
    }
}

